/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon.process;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.AddonDiscoveryMethod;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonMatchProperty;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AddonFinder.class}, name="process-addon-suggestion-finder")
public class ProcessAddonFinder
extends BaseAddonFinder {
    public static final String SERVICE_TYPE = "process";
    public static final String CFG_FINDER_PROCESS = "suggestionFinderProcess";
    public static final String SERVICE_NAME = "process-addon-suggestion-finder";
    private static final String COMMAND = "command";
    private static final String COMMAND_LINE = "commandLine";
    private static final Set<String> SUPPORTED_PROPERTIES = Set.of("command", "commandLine");
    private final Logger logger = LoggerFactory.getLogger(ProcessAddonFinder.class);

    public Set<AddonInfo> getSuggestedAddons() {
        Set processInfos;
        this.logger.trace("ProcessAddonFinder::getSuggestedAddons");
        HashSet<AddonInfo> result = new HashSet<AddonInfo>();
        try {
            processInfos = ProcessHandle.allProcesses().map(process -> ProcessInfo.from(process.info())).filter(info -> info.command != null || info.commandLine != null).collect(Collectors.toUnmodifiableSet());
        }
        catch (SecurityException | UnsupportedOperationException unused) {
            this.logger.info("Cannot obtain process list, suggesting add-ons based on running processes is not possible");
            return result;
        }
        block2: for (AddonInfo candidate : this.addonCandidates) {
            block3: for (AddonDiscoveryMethod method2 : candidate.getDiscoveryMethods().stream().filter(method -> SERVICE_TYPE.equals(method.getServiceType())).toList()) {
                boolean noSupportedProperty;
                Map<String, Pattern> matchProperties = method2.getMatchProperties().stream().collect(Collectors.toMap(AddonMatchProperty::getName, AddonMatchProperty::getPattern));
                if (matchProperties.isEmpty()) {
                    this.logger.warn("Add-on info for '{}' contains no 'match-property'", (Object)candidate.getUID());
                    continue block2;
                }
                HashSet<String> propertyNames = new HashSet<String>(matchProperties.keySet());
                boolean bl = noSupportedProperty = !propertyNames.removeAll(SUPPORTED_PROPERTIES);
                if (!propertyNames.isEmpty()) {
                    this.logger.warn("Add-on info for '{}' contains unsupported 'match-property' [{}]", (Object)candidate.getUID(), (Object)String.join((CharSequence)",", propertyNames));
                    if (noSupportedProperty) continue block2;
                }
                this.logger.trace("Checking candidate: {}", (Object)candidate.getUID());
                for (ProcessInfo processInfo : processInfos) {
                    if (!ProcessAddonFinder.propertyMatches(matchProperties, (String)COMMAND, (String)processInfo.command) || !ProcessAddonFinder.propertyMatches(matchProperties, (String)COMMAND_LINE, (String)processInfo.commandLine)) continue;
                    result.add(candidate);
                    this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                    continue block3;
                }
            }
        }
        return result;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected record ProcessInfo(@Nullable String command, @Nullable String commandLine) {
        protected static ProcessInfo from(ProcessHandle.Info info) {
            String commandLine = info.commandLine().orElse(null);
            String cmd = info.command().orElse(null);
            if ((cmd == null || cmd.isEmpty()) && commandLine != null) {
                cmd = commandLine;
                String[] args = info.arguments().orElse(null);
                if (args != null) {
                    int i = args.length - 1;
                    while (i >= 0) {
                        int index = cmd.lastIndexOf(args[i]);
                        if (index >= 0) {
                            cmd = cmd.substring(0, index);
                        }
                        --i;
                    }
                }
                cmd = cmd.stripTrailing();
            }
            return new ProcessInfo(cmd, commandLine);
        }
    }
}

