/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationSelectionOption;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.ClientAuthenticationFlow;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.ClientAuthenticationFlowContextSupplier;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.DefaultAuthenticationFlow;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.ForkFlowException;
import org.keycloak.authentication.FormAuthenticationFlow;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.authentication.authenticators.util.AcrStore;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.protocol.ClientData;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;
import org.keycloak.utils.StringUtil;

public class AuthenticationProcessor {
    public static final String CURRENT_AUTHENTICATION_EXECUTION = "current.authentication.execution";
    public static final String LAST_PROCESSED_EXECUTION = "last.processed.execution";
    public static final String CURRENT_FLOW_PATH = "current.flow.path";
    public static final String FORKED_FROM = "forked.from";
    public static final String AUTHN_CREDENTIALS = "authn.credentials";
    public static final String BROKER_SESSION_ID = "broker.session.id";
    public static final String BROKER_USER_ID = "broker.user.id";
    public static final String FORWARDED_PASSIVE_LOGIN = "forwarded.passive.login";
    public static final String AUTHENTICATION_SELECTOR_SCREEN_DISPLAYED = "auth.selector.screen.rendered";
    public static final String FIRST_OFFLINE_ACCESS = "first.offline.access";
    protected static final Logger logger = Logger.getLogger(AuthenticationProcessor.class);
    protected RealmModel realm;
    protected UserSessionModel userSession;
    protected AuthenticationSessionModel authenticationSession;
    protected ClientConnection connection;
    protected UriInfo uriInfo;
    protected KeycloakSession session;
    protected EventBuilder event;
    protected HttpRequest request;
    protected String flowId;
    protected String flowPath;
    protected boolean browserFlow;
    protected BruteForceProtector protector;
    protected Runnable afterResetListener;
    protected ForwardedFormMessageStore forwardedErrorMessageStore = new ForwardedFormMessageStore(ForwardedFormMessageType.ERROR);
    protected ForwardedFormMessageStore forwardedSuccessMessageStore = new ForwardedFormMessageStore(ForwardedFormMessageType.SUCCESS);
    protected ForwardedFormMessageStore forwardedInfoMessageStore = new ForwardedFormMessageStore(ForwardedFormMessageType.INFO);
    protected ClientModel client;
    protected Map<String, String> clientAuthAttributes = new HashMap<String, String>();

    public boolean isBrowserFlow() {
        return this.browserFlow;
    }

    public AuthenticationProcessor setBrowserFlow(boolean browserFlow) {
        this.browserFlow = browserFlow;
        return this;
    }

    public BruteForceProtector getBruteForceProtector() {
        if (this.protector == null) {
            this.protector = (BruteForceProtector)this.session.getProvider(BruteForceProtector.class);
        }
        return this.protector;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public Map<String, String> getClientAuthAttributes() {
        return this.clientAuthAttributes;
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public AuthenticationProcessor setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public AuthenticationProcessor setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
        return this;
    }

    public AuthenticationProcessor setConnection(ClientConnection connection) {
        this.connection = connection;
        return this;
    }

    public AuthenticationProcessor setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public AuthenticationProcessor setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public AuthenticationProcessor setEventBuilder(EventBuilder eventBuilder) {
        this.event = eventBuilder;
        return this;
    }

    public AuthenticationProcessor setRequest(HttpRequest request) {
        this.request = request;
        return this;
    }

    public AuthenticationProcessor setFlowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    public AuthenticationProcessor setFlowPath(String flowPath) {
        this.flowPath = flowPath;
        return this;
    }

    public AuthenticationProcessor setForwardedErrorMessage(FormMessage forwardedErrorMessage) {
        this.forwardedErrorMessageStore.setForwardedMessage(forwardedErrorMessage);
        return this;
    }

    FormMessage getAndRemoveForwardedErrorMessage() {
        FormMessage formMessage = this.forwardedErrorMessageStore.getForwardedMessage();
        if (formMessage != null) {
            this.forwardedErrorMessageStore.removeForwardedMessage();
        }
        return formMessage;
    }

    public AuthenticationProcessor setForwardedSuccessMessage(FormMessage forwardedSuccessMessage) {
        this.forwardedSuccessMessageStore.setForwardedMessage(forwardedSuccessMessage);
        return this;
    }

    public AuthenticationProcessor setForwardedInfoMessage(FormMessage forwardedInfoMessage) {
        this.forwardedInfoMessageStore.setForwardedMessage(forwardedInfoMessage);
        return this;
    }

    public String generateCode() {
        ClientSessionCode<AuthenticationSessionModel> accessCode = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.getRealm(), this.getAuthenticationSession());
        this.authenticationSession.getParentSession().setTimestamp(Time.currentTime());
        return accessCode.getOrGenerateCode();
    }

    public EventBuilder newEvent() {
        this.event = new EventBuilder(this.realm, this.session, this.connection);
        return this.event;
    }

    public EventBuilder getEvent() {
        return this.event;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public String getFlowPath() {
        return this.flowPath;
    }

    public void setAutheticatedUser(UserModel user) {
        UserModel previousUser = this.getAuthenticationSession().getAuthenticatedUser();
        if (previousUser != null && !user.getId().equals(previousUser.getId())) {
            throw new AuthenticationFlowException(AuthenticationFlowError.USER_CONFLICT);
        }
        this.validateUser(user);
        this.getAuthenticationSession().setAuthenticatedUser(user);
    }

    public void clearAuthenticatedUser() {
        this.getAuthenticationSession().setAuthenticatedUser(null);
    }

    private String getClientData() {
        return AuthenticationProcessor.getClientData(this.getSession(), this.getAuthenticationSession());
    }

    public static String getClientData(KeycloakSession session, AuthenticationSessionModel authSession) {
        LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authSession.getProtocol());
        ClientData clientData = protocol.getClientData(authSession);
        return clientData.encode();
    }

    private String getSignedAuthSessionId() {
        AuthenticationSessionManager authenticationSessionManager = new AuthenticationSessionManager(this.session);
        return authenticationSessionManager.signAndEncodeToBase64AuthSessionId(this.getAuthenticationSession().getParentSession().getId());
    }

    public URI getRefreshUrl(boolean authSessionIdParam) {
        UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(this.getUriInfo()).path(this.flowPath).queryParam("client_id", new Object[]{this.getAuthenticationSession().getClient().getClientId()}).queryParam("tab_id", new Object[]{this.getAuthenticationSession().getTabId()}).queryParam("client_data", new Object[]{this.getClientData()});
        if (authSessionIdParam) {
            uriBuilder.queryParam("auth_session_id", new Object[]{this.getSignedAuthSessionId()});
        }
        return uriBuilder.build(new Object[]{this.getRealm().getName()});
    }

    public void logFailure() {
        UserModel user;
        if (this.realm.isBruteForceProtected() && (user = AuthenticationManager.lookupUserForBruteForceLog(this.session, this.realm, this.authenticationSession)) != null) {
            this.getBruteForceProtector().failedLogin(this.realm, user, this.connection, this.session.getContext().getHttpRequest().getUri());
        }
    }

    public boolean isSuccessful(AuthenticationExecutionModel model) {
        CommonClientSessionModel.ExecutionStatus status = (CommonClientSessionModel.ExecutionStatus)this.authenticationSession.getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == CommonClientSessionModel.ExecutionStatus.SUCCESS;
    }

    public Response handleBrowserExceptionList(AuthenticationFlowException e) {
        LoginFormsProvider forms = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(this.authenticationSession);
        ServicesLogger.LOGGER.failedAuthentication(e);
        forms.addError(new FormMessage("unexpectedErrorHandlingRequestMessage", new Object[0]));
        for (AuthenticationFlowException afe : e.getAfeList()) {
            ServicesLogger.LOGGER.failedAuthentication(afe);
            switch (afe.getError()) {
                case INVALID_USER: {
                    this.event.error("user_not_found");
                    forms.addError(new FormMessage("invalidUserMessage", new Object[0]));
                    break;
                }
                case USER_DISABLED: {
                    this.event.error("user_disabled");
                    forms.addError(new FormMessage("accountDisabledMessage", new Object[0]));
                    break;
                }
                case USER_TEMPORARILY_DISABLED: {
                    this.event.error("user_temporarily_disabled");
                    forms.addError(new FormMessage("invalidUserMessage", new Object[0]));
                    break;
                }
                case INVALID_CLIENT_SESSION: {
                    this.event.error("invalid_code");
                    forms.addError(new FormMessage("invalidCodeMessage", new Object[0]));
                    break;
                }
                case EXPIRED_CODE: {
                    this.event.error("expired_code");
                    forms.addError(new FormMessage("expiredCodeMessage", new Object[0]));
                    break;
                }
                case DISPLAY_NOT_SUPPORTED: {
                    this.event.error("display_unsupported");
                    forms.addError(new FormMessage("displayUnsupported", new Object[0]));
                    break;
                }
                case CREDENTIAL_SETUP_REQUIRED: {
                    this.event.error("invalid_user_credentials");
                    forms.addError(new FormMessage("credentialSetupRequired", new Object[0]));
                }
            }
        }
        return forms.createErrorPage(Response.Status.BAD_REQUEST);
    }

    public Response handleBrowserException(Exception failure) {
        if (failure instanceof AuthenticationFlowException) {
            AuthenticationFlowException e = (AuthenticationFlowException)((Object)failure);
            if (e.getAfeList() != null && !e.getAfeList().isEmpty()) {
                return this.handleBrowserExceptionList(e);
            }
            if (e.getError() == AuthenticationFlowError.INVALID_USER) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("user_not_found");
                if (e.getResponse() != null) {
                    return e.getResponse();
                }
                return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "invalidUserMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.USER_DISABLED) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("user_disabled");
                if (e.getResponse() != null) {
                    return e.getResponse();
                }
                return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "accountDisabledMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.USER_TEMPORARILY_DISABLED) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("user_temporarily_disabled");
                if (e.getResponse() != null) {
                    return e.getResponse();
                }
                return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "accountTemporarilyDisabledMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.INVALID_CLIENT_SESSION) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("invalid_code");
                if (e.getResponse() != null) {
                    return e.getResponse();
                }
                return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "invalidCodeMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.EXPIRED_CODE) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("expired_code");
                if (e.getResponse() != null) {
                    return e.getResponse();
                }
                return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "expiredCodeMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.FORK_FLOW) {
                ForkFlowException reset = (ForkFlowException)e;
                AuthenticationSessionModel clone = AuthenticationProcessor.clone(this.session, this.authenticationSession);
                clone.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
                this.setAuthenticationSession(clone);
                ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(clone);
                AuthenticationProcessor processor = new AuthenticationProcessor();
                processor.setAuthenticationSession(clone).setFlowPath("authenticate").setFlowId(AuthenticationFlowResolver.resolveBrowserFlow((AuthenticationSessionModel)clone).getId()).setForwardedErrorMessage(reset.getErrorMessage()).setForwardedSuccessMessage(reset.getSuccessMessage()).setConnection(this.connection).setEventBuilder(this.event).setRealm(this.realm).setBrowserFlow(this.isBrowserFlow()).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
                CacheControlUtil.noBackButtonCacheControlHeader(this.session);
                return processor.authenticate();
            }
            if (e.getError() == AuthenticationFlowError.DISPLAY_NOT_SUPPORTED) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("display_unsupported");
                if (e.getResponse() != null) {
                    return e.getResponse();
                }
                return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "displayUnsupported", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.CREDENTIAL_SETUP_REQUIRED) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                this.event.error("invalid_user_credentials");
                if (e.getResponse() != null) {
                    return e.getResponse();
                }
                return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "credentialSetupRequired", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.GENERIC_AUTHENTICATION_ERROR) {
                ServicesLogger.LOGGER.failedAuthentication(e);
                if (e.getEventDetails() != null) {
                    this.event.detail("authentication_error_detail", e.getEventDetails());
                }
                this.event.error("generic_authentication_error");
                if (e.getResponse() != null) {
                    return e.getResponse();
                }
                return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, e.getUserErrorMessage(), new Object[0]);
            }
            ServicesLogger.LOGGER.failedAuthentication(e);
            this.event.error("invalid_user_credentials");
            if (e.getResponse() != null) {
                return e.getResponse();
            }
            return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "invalidUserMessage", new Object[0]);
        }
        ServicesLogger.LOGGER.failedAuthentication(failure);
        this.event.error("invalid_user_credentials");
        return ErrorPage.error(this.session, this.authenticationSession, Response.Status.BAD_REQUEST, "unexpectedErrorHandlingRequestMessage", new Object[0]);
    }

    public Response handleClientAuthException(Exception failure) {
        if (failure instanceof AuthenticationFlowException) {
            AuthenticationFlowException e = (AuthenticationFlowException)((Object)failure);
            ServicesLogger.LOGGER.failedClientAuthentication(e);
            if (e.getError() == AuthenticationFlowError.CLIENT_NOT_FOUND) {
                this.event.error("client_not_found");
                return ClientAuthUtil.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_client", "Invalid client or Invalid client credentials");
            }
            if (e.getError() == AuthenticationFlowError.CLIENT_DISABLED) {
                this.event.error("client_disabled");
                return ClientAuthUtil.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_client", "Invalid client or Invalid client credentials");
            }
            if (e.getError() == AuthenticationFlowError.CLIENT_CREDENTIALS_SETUP_REQUIRED) {
                this.event.error("invalid_client_credentials");
                return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", "Client credentials setup required");
            }
            this.event.error("invalid_client_credentials");
            return ClientAuthUtil.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_client", "Invalid client or Invalid client credentials");
        }
        ServicesLogger.LOGGER.errorAuthenticatingClient(failure);
        this.event.error("invalid_client_credentials");
        return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", "Unexpected error when authenticating client");
    }

    public AuthenticationFlow createFlowExecution(String flowId, AuthenticationExecutionModel execution) {
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(flowId);
        if (flow == null) {
            logger.error((Object)"Unknown flow to execute with");
            throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
        }
        if (flow.getProviderId() == null || flow.getProviderId().equals("basic-flow")) {
            return new DefaultAuthenticationFlow(this, flow);
        }
        if (flow.getProviderId().equals("form-flow")) {
            return new FormAuthenticationFlow(this, execution);
        }
        if (flow.getProviderId().equals("client-flow")) {
            return new ClientAuthenticationFlow(this, flow);
        }
        throw new AuthenticationFlowException("Unknown flow provider type", AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response authenticate() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE");
        Response challenge = this.authenticateOnly();
        if (challenge != null) {
            return challenge;
        }
        return this.authenticationComplete();
    }

    public Response authenticateClient() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE CLIENT");
        AuthenticationFlow authenticationFlow = this.createFlowExecution(this.flowId, null);
        try {
            Response challenge = authenticationFlow.processFlow();
            if (challenge != null) {
                return challenge;
            }
            if (!authenticationFlow.isSuccessful()) {
                throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
            }
            return null;
        }
        catch (Exception e) {
            return this.handleClientAuthException(e);
        }
    }

    public Response redirectToFlow() {
        URI redirect = new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).getLastExecutionUrl(this.authenticationSession);
        logger.debugf("Redirecting to URL: %s", (Object)redirect.toString());
        return Response.status((int)302).location(redirect).build();
    }

    public void resetFlow() {
        AuthenticationProcessor.resetFlow(this.authenticationSession, this.flowPath);
        if (this.afterResetListener != null) {
            this.afterResetListener.run();
        }
    }

    public static void resetFlow(AuthenticationSessionModel authSession, String flowPath) {
        logger.debug((Object)"RESET FLOW");
        authSession.getParentSession().setTimestamp(Time.currentTime());
        authSession.setAuthenticatedUser(null);
        authSession.clearExecutionStatus();
        authSession.clearUserSessionNotes();
        authSession.clearAuthNotes();
        Set requiredActions = authSession.getRequiredActions();
        for (String reqAction : requiredActions) {
            authSession.removeRequiredAction(reqAction);
        }
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setAuthNote(CURRENT_FLOW_PATH, flowPath);
    }

    public static AuthenticationSessionModel recreate(KeycloakSession session, AuthenticationSessionModel authSession) {
        AuthenticationSessionManager authenticationSessionManager = new AuthenticationSessionManager(session);
        RootAuthenticationSessionModel rootAuthenticationSession = authenticationSessionManager.createAuthenticationSession(authSession.getRealm(), true);
        AuthenticationSessionModel newAuthSession = rootAuthenticationSession.createAuthenticationSession(authSession.getClient());
        newAuthSession.setRedirectUri(authSession.getRedirectUri());
        newAuthSession.setProtocol(authSession.getProtocol());
        for (Map.Entry clientNote : authSession.getClientNotes().entrySet()) {
            newAuthSession.setClientNote((String)clientNote.getKey(), (String)clientNote.getValue());
        }
        authenticationSessionManager.removeAuthenticationSession(authSession.getRealm(), authSession, true);
        RestartLoginCookie.setRestartCookie(session, authSession);
        return newAuthSession;
    }

    public static AuthenticationSessionModel clone(KeycloakSession session, AuthenticationSessionModel authSession) {
        AuthenticationSessionModel clone = authSession.getParentSession().createAuthenticationSession(authSession.getClient());
        clone.setRedirectUri(authSession.getRedirectUri());
        clone.setProtocol(authSession.getProtocol());
        for (Map.Entry clientNote : authSession.getClientNotes().entrySet()) {
            clone.setClientNote((String)clientNote.getKey(), (String)clientNote.getValue());
        }
        clone.setAuthNote(FORKED_FROM, authSession.getTabId());
        if (authSession.getAuthNote("END_AFTER_REQUIRED_ACTIONS") != null) {
            clone.setAuthNote("END_AFTER_REQUIRED_ACTIONS", authSession.getAuthNote("END_AFTER_REQUIRED_ACTIONS"));
        }
        logger.debugf("Forked authSession %s from authSession %s . Client: %s, Root session: %s", new Object[]{clone.getTabId(), authSession.getTabId(), authSession.getClient().getClientId(), authSession.getParentSession().getId()});
        return clone;
    }

    public Response authenticationAction(String execution) {
        AuthenticationFlow authenticationFlow;
        Response challenge;
        logger.debug((Object)"authenticationAction");
        this.checkClientSession(true);
        String current = this.authenticationSession.getAuthNote(CURRENT_AUTHENTICATION_EXECUTION);
        if (execution == null || !execution.equals(current)) {
            logger.debug((Object)"Current execution does not equal executed execution.  Might be a page refresh");
            return new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).showPageExpired(this.authenticationSession);
        }
        UserModel authUser = this.authenticationSession.getAuthenticatedUser();
        this.validateUser(authUser);
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            logger.debug((Object)"Cannot find execution, reseting flow");
            this.logFailure();
            this.resetFlow();
            return this.authenticate();
        }
        this.event.client(this.authenticationSession.getClient().getClientId()).detail("redirect_uri", this.authenticationSession.getRedirectUri()).detail("auth_method", this.authenticationSession.getProtocol());
        String authType = this.authenticationSession.getAuthNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        if ((challenge = (authenticationFlow = this.createFlowExecution(this.flowId, model)).processAction(execution)) != null) {
            return challenge;
        }
        if (this.authenticationSession.getAuthenticatedUser() == null) {
            throw new AuthenticationFlowException(AuthenticationFlowError.UNKNOWN_USER);
        }
        if (!authenticationFlow.isSuccessful()) {
            throw new AuthenticationFlowException(authenticationFlow.getFlowExceptions());
        }
        return this.authenticationComplete();
    }

    private void checkClientSession(boolean checkAction) {
        String action;
        ClientSessionCode<AuthenticationSessionModel> code = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.realm, this.authenticationSession);
        if (checkAction && !code.isValidAction(action = CommonClientSessionModel.Action.AUTHENTICATE.name())) {
            throw new AuthenticationFlowException(AuthenticationFlowError.INVALID_CLIENT_SESSION);
        }
        if (!code.isActionActive(ClientSessionCode.ActionType.LOGIN)) {
            throw new AuthenticationFlowException(AuthenticationFlowError.EXPIRED_CODE);
        }
        this.authenticationSession.getParentSession().setTimestamp(Time.currentTime());
    }

    public Response authenticateOnly() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE ONLY");
        this.checkClientSession(false);
        this.event.client(this.authenticationSession.getClient().getClientId()).detail("redirect_uri", this.authenticationSession.getRedirectUri()).detail("auth_method", this.authenticationSession.getProtocol());
        String authType = this.authenticationSession.getAuthNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        UserModel authUser = this.authenticationSession.getAuthenticatedUser();
        this.validateUser(authUser);
        AuthenticationFlow authenticationFlow = this.createFlowExecution(this.flowId, null);
        Response challenge = authenticationFlow.processFlow();
        if (challenge != null) {
            return challenge;
        }
        if (this.authenticationSession.getAuthenticatedUser() == null) {
            if (this.forwardedErrorMessageStore.getForwardedMessage() != null) {
                LoginFormsProvider forms = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(this.authenticationSession);
                forms.addError(this.forwardedErrorMessageStore.getForwardedMessage());
                return forms.createErrorPage(Response.Status.BAD_REQUEST);
            }
            throw new AuthenticationFlowException(AuthenticationFlowError.UNKNOWN_USER);
        }
        if (!authenticationFlow.isSuccessful()) {
            throw new AuthenticationFlowException(authenticationFlow.getFlowExceptions());
        }
        return null;
    }

    public ClientSessionContext attachSession() {
        ClientSessionContext clientSessionCtx = AuthenticationProcessor.attachSession(this.authenticationSession, this.userSession, this.session, this.realm, this.connection, this.event);
        if (this.userSession == null) {
            this.userSession = clientSessionCtx.getClientSession().getUserSession();
        }
        return clientSessionCtx;
    }

    public static ClientSessionContext attachSession(AuthenticationSessionModel authSession, UserSessionModel userSession, KeycloakSession session, RealmModel realm, ClientConnection connection, EventBuilder event) {
        ClientSessionContext clientSessionCtx;
        String rememberMe;
        String username = authSession.getAuthenticatedUser().getUsername();
        String attemptedUsername = authSession.getAuthNote("ATTEMPTED_USERNAME");
        if (attemptedUsername != null) {
            username = attemptedUsername;
        }
        boolean remember = (rememberMe = authSession.getAuthNote("remember_me")) != null && rememberMe.equalsIgnoreCase("true");
        String brokerSessionId = authSession.getAuthNote(BROKER_SESSION_ID);
        String brokerUserId = authSession.getAuthNote(BROKER_USER_ID);
        if (userSession == null) {
            userSession = session.sessions().getUserSession(realm, authSession.getParentSession().getId());
            if (userSession == null) {
                UserSessionModel.SessionPersistenceState persistenceState = UserSessionModel.SessionPersistenceState.fromString((String)authSession.getClientNote("USER_SESSION_PERSISTENT_STATE"));
                userSession = new UserSessionManager(session).createUserSession(authSession.getParentSession().getId(), realm, authSession.getAuthenticatedUser(), username, connection.getRemoteHost(), authSession.getProtocol(), remember, brokerSessionId, brokerUserId, persistenceState);
                if (LightweightUserAdapter.isLightweightUser((UserModel)userSession.getUser())) {
                    LightweightUserAdapter lua = (LightweightUserAdapter)userSession.getUser();
                    lua.setOwningUserSessionId(userSession.getId());
                }
            } else if (userSession.getUser() == null || !AuthenticationManager.isSessionValid(realm, userSession)) {
                userSession.restartSession(realm, authSession.getAuthenticatedUser(), username, connection.getRemoteHost(), authSession.getProtocol(), remember, brokerSessionId, brokerUserId);
            } else {
                logger.debugf("No SSO login, but found existing userSession with ID '%s' after finished authentication.", (Object)userSession.getId());
                if (!authSession.getAuthenticatedUser().equals(userSession.getUser())) {
                    event.detail("previous_user", userSession.getUser().getId());
                    event.error("different_user_authenticated");
                    throw new ErrorPageException(session, authSession, Response.Status.BAD_REQUEST, "differentUserAuthenticated", userSession.getUser().getUsername());
                }
            }
            userSession.setState(UserSessionModel.State.LOGGED_IN);
            session.getContext().setUserSession(userSession);
        }
        if (remember) {
            event.detail("remember_me", "true");
        }
        if (userSession.getStarted() == userSession.getLastSessionRefresh()) {
            int clientSessions = userSession.getAuthenticatedClientSessions().size();
            clientSessionCtx = TokenManager.attachAuthenticationSession(session, userSession, authSession);
            if (clientSessions == 0 && TokenUtil.hasScope((String)clientSessionCtx.getScopeString(), (String)"offline_access")) {
                clientSessionCtx.getClientSession().setNote(FIRST_OFFLINE_ACCESS, Boolean.TRUE.toString());
            } else {
                clientSessionCtx.getClientSession().removeNote(FIRST_OFFLINE_ACCESS);
            }
        } else {
            clientSessionCtx = TokenManager.attachAuthenticationSession(session, userSession, authSession);
            clientSessionCtx.getClientSession().removeNote(FIRST_OFFLINE_ACCESS);
        }
        event.user(userSession.getUser()).detail("username", username).session(userSession);
        return clientSessionCtx;
    }

    public void evaluateRequiredActionTriggers() {
        AuthenticationManager.evaluateRequiredActionTriggers(this.session, this.authenticationSession, this.request, this.event, this.realm, this.authenticationSession.getAuthenticatedUser());
    }

    public Response finishAuthentication(LoginProtocol protocol) {
        RealmModel realm = this.authenticationSession.getRealm();
        ClientSessionContext clientSessionCtx = this.attachSession();
        this.event.success();
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, realm, this.userSession, clientSessionCtx, this.request, this.uriInfo, this.connection, this.event, this.authenticationSession, protocol);
    }

    public void validateUser(UserModel authenticatedUser) {
        if (authenticatedUser == null) {
            return;
        }
        if (!authenticatedUser.isEnabled()) {
            this.event.user(authenticatedUser).detail("username", authenticatedUser.getUsername());
            throw new AuthenticationFlowException(AuthenticationFlowError.USER_DISABLED);
        }
        if (authenticatedUser.getServiceAccountClientLink() != null) {
            throw new AuthenticationFlowException(AuthenticationFlowError.UNKNOWN_USER);
        }
    }

    protected Response authenticationComplete() {
        new AcrStore(this.session, this.authenticationSession).setAuthFlowLevelAuthenticatedToCurrentRequest();
        AuthenticationManager.setClientScopesInSession(this.session, this.authenticationSession);
        String nextRequiredAction = this.nextRequiredAction();
        if (nextRequiredAction != null) {
            return AuthenticationManager.redirectToRequiredActions(this.session, this.realm, this.authenticationSession, this.uriInfo, nextRequiredAction);
        }
        this.event.detail("code_id", this.authenticationSession.getParentSession().getId());
        return AuthenticationManager.finishedRequiredActions(this.session, this.authenticationSession, this.userSession, this.connection, this.request, this.uriInfo, this.event);
    }

    public String nextRequiredAction() {
        return AuthenticationManager.nextRequiredAction(this.session, this.authenticationSession, this.request, this.event);
    }

    public Result createAuthenticatorContext(AuthenticationExecutionModel model, Authenticator authenticator, List<AuthenticationExecutionModel> executions) {
        return new Result(model, authenticator, executions);
    }

    public Result createClientAuthenticatorContext(AuthenticationExecutionModel model, ClientAuthenticator clientAuthenticator, List<AuthenticationExecutionModel> executions) {
        return new Result(model, clientAuthenticator, executions);
    }

    private class ForwardedFormMessageStore {
        private final String messageKey;

        private ForwardedFormMessageStore(ForwardedFormMessageType messageType) {
            this.messageKey = messageType.getKey();
        }

        private void setForwardedMessage(FormMessage message) {
            try {
                logger.tracef("Saving message %s to the authentication session under key %s", (Object)message, (Object)this.messageKey);
                AuthenticationProcessor.this.getAuthenticationSession().setAuthNote(this.messageKey, JsonSerialization.writeValueAsString((Object)message));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unexpected exception when serializing formMessage: " + String.valueOf(message), ioe);
            }
        }

        private FormMessage getForwardedMessage() {
            String note = AuthenticationProcessor.this.getAuthenticationSession().getAuthNote(this.messageKey);
            try {
                return note == null ? null : (FormMessage)JsonSerialization.readValue((String)note, FormMessage.class);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unexpected exception when deserializing formMessage JSON: " + note, ioe);
            }
        }

        private void removeForwardedMessage() {
            logger.tracef("Removing message %s from the authentication session", (Object)this.messageKey);
            AuthenticationProcessor.this.getAuthenticationSession().removeAuthNote(this.messageKey);
        }
    }

    private static enum ForwardedFormMessageType {
        SUCCESS("fwMessageSuccess"),
        ERROR("fwMessageError"),
        INFO("fwMessageInfo");

        private final String key;

        private ForwardedFormMessageType(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }

    public class Result
    implements AuthenticationFlowContext,
    ClientAuthenticationFlowContext {
        AuthenticatorConfigModel authenticatorConfig;
        AuthenticationExecutionModel execution;
        Authenticator authenticator;
        FlowStatus status;
        ClientAuthenticator clientAuthenticator;
        Response challenge;
        AuthenticationFlowError error;
        List<AuthenticationExecutionModel> currentExecutions;
        FormMessage errorMessage;
        FormMessage successMessage;
        List<AuthenticationSelectionOption> authenticationSelections;
        String eventDetails;
        String userErrorMessage;
        Map<Class<?>, Object> state;

        private Result(AuthenticationExecutionModel execution, Authenticator authenticator, List<AuthenticationExecutionModel> currentExecutions) {
            this.execution = execution;
            this.authenticator = authenticator;
            this.currentExecutions = currentExecutions;
        }

        private Result(AuthenticationExecutionModel execution, ClientAuthenticator clientAuthenticator, List<AuthenticationExecutionModel> currentExecutions) {
            this.execution = execution;
            this.clientAuthenticator = clientAuthenticator;
            this.currentExecutions = currentExecutions;
        }

        public EventBuilder newEvent() {
            return AuthenticationProcessor.this.newEvent();
        }

        public AuthenticationExecutionModel.Requirement getCategoryRequirementFromCurrentFlow(String authenticatorCategory) {
            return AuthenticationProcessor.this.realm.getAuthenticationExecutionsStream(this.execution.getParentFlow()).filter(e -> {
                AuthenticatorFactory factory = (AuthenticatorFactory)this.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, e.getAuthenticator());
                return factory != null && factory.getReferenceCategory().equals(authenticatorCategory);
            }).map(AuthenticationExecutionModel::getRequirement).findFirst().orElse(null);
        }

        public AuthenticationExecutionModel getExecution() {
            return this.execution;
        }

        public AuthenticationFlowModel getTopLevelFlow() {
            return AuthenticatorUtil.getTopParentFlow(AuthenticationProcessor.this.realm, this.execution);
        }

        public AuthenticatorConfigModel getAuthenticatorConfig() {
            if (this.execution.getAuthenticatorConfig() == null) {
                return null;
            }
            if (this.authenticatorConfig != null) {
                return this.authenticatorConfig;
            }
            this.authenticatorConfig = AuthenticationProcessor.this.realm.getAuthenticatorConfigById(this.execution.getAuthenticatorConfig());
            return this.authenticatorConfig;
        }

        public Authenticator getAuthenticator() {
            return this.authenticator;
        }

        public FlowStatus getStatus() {
            return this.status;
        }

        public ClientAuthenticator getClientAuthenticator() {
            return this.clientAuthenticator;
        }

        public void success() {
            this.success(null);
        }

        public void success(String credentialType) {
            if (credentialType != null) {
                AuthenticatorUtil.addAuthCredential(this.getAuthenticationSession(), credentialType);
            }
            this.status = FlowStatus.SUCCESS;
        }

        public void failure(AuthenticationFlowError error) {
            this.status = FlowStatus.FAILED;
            this.error = error;
        }

        public void challenge(Response challenge) {
            this.status = FlowStatus.CHALLENGE;
            this.challenge = challenge;
        }

        public void forceChallenge(Response challenge) {
            this.status = FlowStatus.FORCE_CHALLENGE;
            this.challenge = challenge;
        }

        public void failureChallenge(AuthenticationFlowError error, Response challenge) {
            this.error = error;
            this.status = FlowStatus.FAILURE_CHALLENGE;
            this.challenge = challenge;
        }

        public void failure(AuthenticationFlowError error, Response challenge) {
            this.error = error;
            this.status = FlowStatus.FAILED;
            this.challenge = challenge;
        }

        public void failure(AuthenticationFlowError error, Response challenge, String eventDetails, String userErrorMessage) {
            this.error = error;
            this.status = FlowStatus.FAILED;
            this.challenge = challenge;
            this.eventDetails = eventDetails;
            this.userErrorMessage = userErrorMessage;
        }

        public void attempted() {
            this.status = FlowStatus.ATTEMPTED;
        }

        public UserModel getUser() {
            return this.getAuthenticationSession().getAuthenticatedUser();
        }

        public void setUser(UserModel user) {
            AuthenticationProcessor.this.setAutheticatedUser(user);
        }

        public List<AuthenticationSelectionOption> getAuthenticationSelections() {
            return this.authenticationSelections;
        }

        public void setAuthenticationSelections(List<AuthenticationSelectionOption> authenticationSelections) {
            this.authenticationSelections = authenticationSelections;
        }

        public void clearUser() {
            AuthenticationProcessor.this.clearAuthenticatedUser();
        }

        public RealmModel getRealm() {
            return AuthenticationProcessor.this.getRealm();
        }

        public ClientModel getClient() {
            return AuthenticationProcessor.this.getClient();
        }

        public void setClient(ClientModel client) {
            AuthenticationProcessor.this.setClient(client);
        }

        public Map<String, String> getClientAuthAttributes() {
            return AuthenticationProcessor.this.getClientAuthAttributes();
        }

        public <T> T getState(Class<T> type, ClientAuthenticationFlowContextSupplier<T> supplier) throws Exception {
            Object value;
            if (this.state == null) {
                this.state = new HashMap();
            }
            if ((value = type.cast(this.state.get(type))) == null) {
                value = supplier.get((ClientAuthenticationFlowContext)this);
                this.state.put(type, value);
            }
            return value;
        }

        public AuthenticationSessionModel getAuthenticationSession() {
            return AuthenticationProcessor.this.getAuthenticationSession();
        }

        public String getFlowPath() {
            return AuthenticationProcessor.this.getFlowPath();
        }

        public ClientConnection getConnection() {
            return AuthenticationProcessor.this.getConnection();
        }

        public UriInfo getUriInfo() {
            return AuthenticationProcessor.this.getUriInfo();
        }

        public KeycloakSession getSession() {
            return AuthenticationProcessor.this.getSession();
        }

        public HttpRequest getHttpRequest() {
            return AuthenticationProcessor.this.request;
        }

        public void attachUserSession(UserSessionModel userSession) {
            AuthenticationProcessor.this.userSession = userSession;
            if (LightweightUserAdapter.isLightweightUser((UserModel)userSession.getUser())) {
                AuthenticationProcessor.this.authenticationSession.setAuthenticatedUser(userSession.getUser());
            }
        }

        public BruteForceProtector getProtector() {
            return AuthenticationProcessor.this.getBruteForceProtector();
        }

        public EventBuilder getEvent() {
            return AuthenticationProcessor.this.event;
        }

        public FormMessage getForwardedErrorMessage() {
            return AuthenticationProcessor.this.forwardedErrorMessageStore.getForwardedMessage();
        }

        public String generateAccessCode() {
            return AuthenticationProcessor.this.generateCode();
        }

        public Response getChallenge() {
            return this.challenge;
        }

        public AuthenticationFlowError getError() {
            return this.error;
        }

        public LoginFormsProvider form() {
            String accessCode = this.generateAccessCode();
            URI action = this.getActionUrl(accessCode);
            LoginFormsProvider provider = ((LoginFormsProvider)this.getSession().getProvider(LoginFormsProvider.class)).setAuthContext((AuthenticationFlowContext)this).setAuthenticationSession(this.getAuthenticationSession()).setUser(this.getUser()).setActionUri(action).setExecution(this.getExecution().getId()).setFormData((MultivaluedMap)(AuthenticationProcessor.this.request.getHttpMethod().equalsIgnoreCase("post") ? AuthenticationProcessor.this.request.getDecodedFormParameters() : new MultivaluedHashMap())).setClientSessionCode(accessCode);
            if (this.getForwardedErrorMessage() != null) {
                provider.addError(this.getForwardedErrorMessage());
                AuthenticationProcessor.this.forwardedErrorMessageStore.removeForwardedMessage();
            } else if (this.getForwardedSuccessMessage() != null) {
                provider.addSuccess(this.getForwardedSuccessMessage());
                AuthenticationProcessor.this.forwardedSuccessMessageStore.removeForwardedMessage();
            } else if (this.getForwardedInfoMessage() != null) {
                provider.setInfo(this.getForwardedInfoMessage().getMessage(), this.getForwardedInfoMessage().getParameters());
                AuthenticationProcessor.this.forwardedInfoMessageStore.removeForwardedMessage();
            }
            return provider;
        }

        public URI getActionUrl(String code) {
            UriInfo uriInfo = this.getUriInfo();
            UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(uriInfo).path(AuthenticationProcessor.this.flowPath).queryParam("session_code", new Object[]{code}).queryParam("execution", new Object[]{this.getExecution().getId()}).queryParam("client_id", new Object[]{this.getAuthenticationSession().getClient().getClientId()}).queryParam("tab_id", new Object[]{this.getAuthenticationSession().getTabId()}).queryParam("client_data", new Object[]{AuthenticationProcessor.this.getClientData()});
            MultivaluedMap queryParameters = uriInfo.getQueryParameters();
            String token = (String)queryParameters.getFirst((Object)"token");
            if (StringUtil.isNotBlank((String)token)) {
                uriBuilder.queryParam("token", new Object[]{token});
            }
            if (queryParameters.containsKey((Object)"auth_session_id")) {
                uriBuilder.queryParam("auth_session_id", new Object[]{AuthenticationProcessor.this.getSignedAuthSessionId()});
            }
            return uriBuilder.build(new Object[]{this.getRealm().getName()});
        }

        public URI getActionTokenUrl(String tokenString) {
            UriBuilder uriBuilder = LoginActionsService.actionTokenProcessor(this.getUriInfo()).queryParam("key", new Object[]{tokenString}).queryParam("execution", new Object[]{this.getExecution().getId()}).queryParam("client_id", new Object[]{this.getAuthenticationSession().getClient().getClientId()}).queryParam("tab_id", new Object[]{this.getAuthenticationSession().getTabId()}).queryParam("client_data", new Object[]{AuthenticationProcessor.this.getClientData()});
            if (this.getUriInfo().getQueryParameters().containsKey((Object)"auth_session_id")) {
                uriBuilder.queryParam("auth_session_id", new Object[]{AuthenticationProcessor.this.getSignedAuthSessionId()});
            }
            return uriBuilder.build(new Object[]{this.getRealm().getName()});
        }

        public URI getRefreshExecutionUrl() {
            UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(this.getUriInfo()).path(AuthenticationProcessor.this.flowPath).queryParam("execution", new Object[]{this.getExecution().getId()}).queryParam("client_id", new Object[]{this.getAuthenticationSession().getClient().getClientId()}).queryParam("tab_id", new Object[]{this.getAuthenticationSession().getTabId()}).queryParam("client_data", new Object[]{AuthenticationProcessor.this.getClientData()});
            if (this.getUriInfo().getQueryParameters().containsKey((Object)"auth_session_id")) {
                uriBuilder.queryParam("auth_session_id", new Object[]{AuthenticationProcessor.this.getSignedAuthSessionId()});
            }
            return uriBuilder.build(new Object[]{this.getRealm().getName()});
        }

        public URI getRefreshUrl(boolean authSessionIdParam) {
            return AuthenticationProcessor.this.getRefreshUrl(authSessionIdParam);
        }

        public void cancelLogin() {
            this.getEvent().error("rejected_by_user");
            LoginProtocol protocol = (LoginProtocol)this.getSession().getProvider(LoginProtocol.class, this.getAuthenticationSession().getProtocol());
            protocol.setRealm(this.getRealm()).setHttpHeaders(this.getHttpRequest().getHttpHeaders()).setUriInfo(this.getUriInfo()).setEventBuilder(AuthenticationProcessor.this.event);
            Response response = protocol.sendError(this.getAuthenticationSession(), LoginProtocol.Error.CANCELLED_BY_USER, null);
            this.forceChallenge(response);
        }

        public void resetFlow() {
            this.status = FlowStatus.FLOW_RESET;
        }

        public void resetFlow(Runnable afterResetListener) {
            this.status = FlowStatus.FLOW_RESET;
            AuthenticationProcessor.this.afterResetListener = afterResetListener;
        }

        public void fork() {
            this.status = FlowStatus.FORK;
        }

        public void forkWithSuccessMessage(FormMessage message) {
            this.status = FlowStatus.FORK;
            this.successMessage = message;
        }

        public void forkWithErrorMessage(FormMessage message) {
            this.status = FlowStatus.FORK;
            this.errorMessage = message;
        }

        public FormMessage getForwardedSuccessMessage() {
            return AuthenticationProcessor.this.forwardedSuccessMessageStore.getForwardedMessage();
        }

        public void setForwardedInfoMessage(String message, Object ... parameters) {
            AuthenticationProcessor.this.setForwardedInfoMessage(new FormMessage(message, parameters));
        }

        public FormMessage getForwardedInfoMessage() {
            return AuthenticationProcessor.this.forwardedInfoMessageStore.getForwardedMessage();
        }

        public FormMessage getErrorMessage() {
            return this.errorMessage;
        }

        public FormMessage getSuccessMessage() {
            return this.successMessage;
        }

        public String getEventDetails() {
            return this.eventDetails;
        }

        public String getUserErrorMessage() {
            return this.userErrorMessage;
        }
    }
}

