/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters.converters;

import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.reactive.common.model.ResourceParamConverterProvider;
import org.jboss.resteasy.reactive.server.core.parameters.converters.DelegatingParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;

public class RuntimeResolvedConverter
implements ParameterConverter {
    private volatile ParamConverter<?> runtimeConverter;
    private final ParameterConverter quarkusConverter;

    public RuntimeResolvedConverter(ParameterConverter quarkusConverter) {
        this.quarkusConverter = quarkusConverter;
    }

    @Override
    public Object convert(Object parameter) {
        if (this.runtimeConverter != null) {
            return this.runtimeConverter.fromString(parameter != null ? parameter.toString() : null);
        }
        return this.quarkusConverter.convert(parameter);
    }

    @Override
    public void init(ParamConverterProviders deployment, Class<?> rawType, Type genericType, Annotation[] annotations) {
        for (ResourceParamConverterProvider i : deployment.getParamConverterProviders()) {
            ParamConverterProvider instance = (ParamConverterProvider)i.getFactory().createInstance().getInstance();
            ParamConverter converter = instance.getConverter(rawType, genericType, annotations);
            if (converter == null) continue;
            this.runtimeConverter = converter;
            break;
        }
        if (this.runtimeConverter == null && this.quarkusConverter == null) {
            throw new RuntimeException("Unable to create param converter for parameter " + String.valueOf(genericType));
        }
    }

    public static class Supplier
    implements DelegatingParameterConverterSupplier {
        private ParameterConverterSupplier delegate;

        public Supplier() {
        }

        public Supplier(ParameterConverterSupplier delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getClassName() {
            return RuntimeResolvedConverter.class.getName();
        }

        @Override
        public ParameterConverter get() {
            return new RuntimeResolvedConverter(this.delegate == null ? null : (ParameterConverter)this.delegate.get());
        }

        public ParameterConverterSupplier setDelegate(ParameterConverterSupplier delegate) {
            this.delegate = delegate;
            return this;
        }

        @Override
        public ParameterConverterSupplier getDelegate() {
            return this.delegate;
        }
    }
}

