/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.LowAllocationMetricsRequestMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.BiFunction;

public class MetricReusableDataMarshaler {
    private final Deque<LowAllocationMetricsRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationMetricsRequestMarshaler>();
    private final MemoryMode memoryMode;
    private final BiFunction<Marshaler, Integer, CompletableResultCode> doExport;

    public MetricReusableDataMarshaler(MemoryMode memoryMode, BiFunction<Marshaler, Integer, CompletableResultCode> doExport) {
        this.memoryMode = memoryMode;
        this.doExport = doExport;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationMetricsRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationMetricsRequestMarshaler();
            }
            LowAllocationMetricsRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(metrics);
            return this.doExport.apply(exportMarshaler, metrics.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
        return this.doExport.apply((Marshaler)request, metrics.size());
    }
}

