/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.FormatterImpl;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import com.intellij.database.run.ui.grid.renderers.DefaultBooleanRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.ParsePosition;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.Objects;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBooleanEditorFactory
implements GridCellEditorFactory {
    protected static final Formatter myParser = new FormatterImpl(){

        @Nls
        @NotNull
        protected String getErrorMessage() {
            String string = DataGridBundle.message((String)"expected.boolean.value", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        public Object parse(@NotNull String value, ParsePosition position) {
            String text;
            if (value == null) {
                1.$$$reportNull$$$0(1);
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)(text = StringUtil.trim((String)value)), (CharSequence)"true") || StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"1")) {
                position.setIndex(value.length());
                return Boolean.TRUE;
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"false") || StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"0")) {
                position.setIndex(value.length());
                return Boolean.FALSE;
            }
            position.setErrorIndex(0);
            return null;
        }

        public String format(Object value) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    };

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(2);
        }
        int type = GridCellEditorHelper.get((CoreGrid)grid).guessJdbcTypeForEditing((CoreGrid)grid, row, column);
        GridModel model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        GridColumn c2 = Objects.requireNonNull((GridColumn)model2.getColumn(column));
        return ObjectFormatterUtil.isBooleanColumn((GridColumn)c2, (int)type) ? 2 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (value, grid, column) -> true;
        if (isEditableChecker == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(3);
        }
        return isEditableChecker;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(4);
        }
        if (row == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(5);
        }
        if (column == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(6);
        }
        EnumSet opts = GridCellEditorHelper.get((CoreGrid)grid).getSpecialValues((CoreGrid)grid, column);
        KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)initiator, KeyEvent.class);
        Boolean typedValue = null;
        if (keyEvent != null) {
            int code = keyEvent.getKeyCode();
            Object object2 = 84 == code || 49 == code ? Boolean.valueOf(true) : (70 == code || 48 == code ? Boolean.valueOf(false) : (78 == code && opts.contains(ReservedCellValue.NULL) ? ReservedCellValue.NULL : (68 == code && opts.contains(ReservedCellValue.DEFAULT) ? ReservedCellValue.DEFAULT : (67 == code && opts.contains(ReservedCellValue.COMPUTED) ? ReservedCellValue.COMPUTED : (71 == code && opts.contains(ReservedCellValue.GENERATED) ? ReservedCellValue.GENERATED : (32 == code ? Boolean.valueOf(!Boolean.TRUE.equals(object)) : (typedValue = null)))))));
        }
        return grid.getAppearance().getBooleanMode() == DataGridAppearanceSettings.BooleanMode.TEXT ? new TextBooleanCellEditor(grid, row, column, object == null ? ReservedCellValue.NULL : object, opts, typedValue) : new CheckboxBooleanCellEditor(grid, row, column, object == null ? ReservedCellValue.NULL : object, typedValue);
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(7);
        }
        if (rowIdx == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(9);
        }
        GridCellEditorHelper editorHelper = GridCellEditorHelper.get((CoreGrid)grid);
        return new ValueParserWrapper(myParser, editorHelper.isNullable((CoreGrid)grid, columnIdx), editorHelper.getDefaultNullValue((CoreGrid)grid, columnIdx), (Function2<? super String, ? super UnparsedValue.ParsingError, ? extends UnparsedValue>)((Function2)(text, e) -> editorHelper.createUnparsedValue(text, e, (CoreGrid)grid, rowIdx, columnIdx)));
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx, @Nullable Object value) {
        if (grid == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(10);
        }
        if (rowIdx == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(11);
        }
        if (columnIdx == null) {
            DefaultBooleanEditorFactory.$$$reportNull$$$0(12);
        }
        return new GridCellEditorFactory.DefaultValueToText(grid, columnIdx, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValueFormatter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class TextBooleanCellEditor
    extends AbstractBooleanCellEditor {
        final EnumSet<ReservedCellValue> myAllowedValues;

        private TextBooleanCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull Object value, @NotNull EnumSet<ReservedCellValue> allowedValues, @Nullable Object typedValue) {
            if (grid == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(1);
            }
            if (column == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(2);
            }
            if (value == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(3);
            }
            if (allowedValues == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(4);
            }
            super(grid, row, column, value, typedValue);
            this.myAllowedValues = allowedValues;
            if (typedValue == null) {
                final Ref popupShown = new Ref((Object)false);
                this.myComponent.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (!((Boolean)popupShown.get()).booleanValue()) {
                            popupShown.set((Object)true);
                            this.showPopup();
                        } else {
                            this.editingEnded();
                        }
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                    }
                });
            }
        }

        private void showPopup() {
            Object[] options = ArrayUtil.mergeArrays((Object[])new Object[]{Boolean.TRUE, Boolean.FALSE}, (Object[])ArrayUtil.toObjectArray(this.myAllowedValues));
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new ChooseBooleanActionGroup(options, this), DataManager.getInstance().getDataContext((Component)this.getComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            popup.showUnderneathOf((Component)this.myComponent);
        }

        @Override
        @NotNull
        protected JComponent createComponent(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull Object value) {
            if (row == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(5);
            }
            if (column == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(6);
            }
            if (value == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(7);
            }
            DefaultTextRendererFactory.TextRenderer myRenderer = value instanceof UnparsedValue ? new DefaultTextRendererFactory.TextRenderer(this.myGrid) : new DefaultBooleanRendererFactory.TextBooleanRenderer(this.myGrid);
            Disposer.register((Disposable)this, (Disposable)myRenderer);
            Pair viewRowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2View().fun((Object)row.asInteger(), (Object)column.asInteger());
            ViewIndex viewRow = ViewIndex.forRow((CoreGrid)this.myGrid, (int)((Integer)viewRowAndColumn.first));
            ViewIndex viewColumn = ViewIndex.forColumn((CoreGrid)this.myGrid, (int)((Integer)viewRowAndColumn.second));
            JComponent component = ((GridCellRenderer)myRenderer).getComponent((ViewIndex<GridRow>)viewRow, (ViewIndex<GridColumn>)viewColumn, value);
            ResultViewWithCells view = (ResultViewWithCells)ObjectUtils.tryCast((Object)this.myGrid.getResultView(), ResultViewWithCells.class);
            if (view != null) {
                ResultViewWithCells.prepareComponent(component, this.myGrid, view, (ViewIndex<GridRow>)viewRow, (ViewIndex<GridColumn>)viewColumn, true);
            }
            component.setRequestFocusEnabled(true);
            JComponent jComponent = component;
            if (jComponent == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(8);
            }
            return jComponent;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                TextBooleanCellEditor.$$$reportNull$$$0(9);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allowedValues";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$TextBooleanCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$TextBooleanCellEditor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static class CheckboxBooleanCellEditor
    extends AbstractBooleanCellEditor {
        CheckboxBooleanCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull Object value, @Nullable Object typedValue) {
            if (grid == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(1);
            }
            if (column == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(2);
            }
            if (value == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(3);
            }
            super(grid, row, column, value, typedValue != null ? typedValue : (Boolean.TRUE.equals(value) ? Boolean.FALSE : Boolean.TRUE));
        }

        @Override
        @NotNull
        protected JComponent createComponent(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull Object value) {
            if (row == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(4);
            }
            if (column == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(5);
            }
            if (value == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(6);
            }
            DefaultBooleanRendererFactory.CheckboxBooleanRenderer myRenderer = new DefaultBooleanRendererFactory.CheckboxBooleanRenderer(this.myGrid);
            Disposer.register((Disposable)this, (Disposable)myRenderer);
            Pair viewRowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2View().fun((Object)row.asInteger(), (Object)column.asInteger());
            ViewIndex viewRow = ViewIndex.forRow((CoreGrid)this.myGrid, (int)((Integer)viewRowAndColumn.first));
            ViewIndex viewColumn = ViewIndex.forColumn((CoreGrid)this.myGrid, (int)((Integer)viewRowAndColumn.second));
            JComponent component = myRenderer.getComponent((ViewIndex<GridRow>)viewRow, (ViewIndex<GridColumn>)viewColumn, value);
            ResultViewWithCells view = (ResultViewWithCells)ObjectUtils.tryCast((Object)this.myGrid.getResultView(), ResultViewWithCells.class);
            if (view != null) {
                ResultViewWithCells.prepareComponent(component, this.myGrid, view, (ViewIndex<GridRow>)viewRow, (ViewIndex<GridColumn>)viewColumn, true);
            }
            component.setRequestFocusEnabled(true);
            JComponent jComponent = component;
            if (jComponent == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(7);
            }
            return jComponent;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                CheckboxBooleanCellEditor.$$$reportNull$$$0(8);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$CheckboxBooleanCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$CheckboxBooleanCellEditor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ChooseBooleanAction
    extends AnAction {
        final Object value;
        final TextBooleanCellEditor myEditor;

        private ChooseBooleanAction(@NotNull Object value, @NotNull TextBooleanCellEditor editor) {
            if (value == null) {
                ChooseBooleanAction.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ChooseBooleanAction.$$$reportNull$$$0(1);
            }
            this.value = value;
            this.myEditor = editor;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ChooseBooleanAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseBooleanAction.$$$reportNull$$$0(3);
            }
            this.myEditor.setValue(this.value);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseBooleanAction.$$$reportNull$$$0(4);
            }
            e.getPresentation().setText(this.value == ReservedCellValue.UNSET ? DataGridBundle.message((String)"action.Console.TableResult.ClearCell.text", (Object[])new Object[0]) : StringUtil.toLowerCase((String)this.value.toString()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$ChooseBooleanAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$ChooseBooleanAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ChooseBooleanActionGroup
    extends ActionGroup {
        final Object[] myValues;
        final TextBooleanCellEditor myEditor;

        ChooseBooleanActionGroup(Object @NotNull [] values, @NotNull TextBooleanCellEditor editor) {
            if (editor == null) {
                ChooseBooleanActionGroup.$$$reportNull$$$0(0);
            }
            if (values == null) {
                ChooseBooleanActionGroup.$$$reportNull$$$0(1);
            }
            this.myValues = values;
            this.myEditor = editor;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = (AnAction[])JBIterable.of((Object[])this.myValues).map(value -> new ChooseBooleanAction(value, this.myEditor)).toArray((Object[])new ChooseBooleanAction[0]);
            if (anActionArray == null) {
                ChooseBooleanActionGroup.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$ChooseBooleanActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$ChooseBooleanActionGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class AbstractBooleanCellEditor
    extends GridCellEditor.Adapter {
        final DataGrid myGrid;
        final Object myInitialValue;
        private final boolean shouldMoveFocus;
        final JComponent myComponent;
        Object myValue;

        AbstractBooleanCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull Object value, final @Nullable Object typedValue) {
            if (grid == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(1);
            }
            if (column == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(2);
            }
            if (value == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(3);
            }
            this.myGrid = grid;
            this.myInitialValue = value;
            this.shouldMoveFocus = typedValue == null;
            this.myComponent = this.createComponent(row, column, value);
            if (typedValue != null) {
                this.myComponent.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        this.setValue(typedValue);
                        this.editingEnded();
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                    }
                });
            }
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myInitialValue.toString();
            if (string == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(4);
            }
            return string;
        }

        abstract JComponent createComponent(@NotNull ModelIndex<GridRow> var1, @NotNull ModelIndex<GridColumn> var2, @NotNull Object var3);

        void setValue(@NotNull Object value) {
            if (value == null) {
                AbstractBooleanCellEditor.$$$reportNull$$$0(5);
            }
            this.myValue = value;
            this.fireEditing(value);
            this.myGrid.getResultView().getComponent().requestFocus();
        }

        void editingEnded() {
            if (this.myValue == null) {
                this.myGrid.cancelEditing();
            } else if (!this.myGrid.stopEditing()) {
                this.myGrid.cancelEditing();
            }
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.myValue != null ? this.myValue : this.myInitialValue;
        }

        @Override
        public boolean isColumnSpanAllowed() {
            return false;
        }

        @Override
        public boolean shouldMoveFocus() {
            return this.shouldMoveFocus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$AbstractBooleanCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$AbstractBooleanCellEditor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

