/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.move.MoveKotlinDeclarationsHandlerActions;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.KotlinAwareMoveFilesOrDirectoriesDialog;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.KotlinSelectNestedClassRefactoringDialog;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinNestedClassesDialog;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsDialog;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\u0001\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0014\u0010\u0003\u001a\u00020\u00048CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"defaultHandlerActions", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsHandlerKt$defaultHandlerActions$1", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsHandlerKt$defaultHandlerActions$1;", "MOVE_DECLARATIONS", "", "getMOVE_DECLARATIONS", "()Ljava/lang/String;", "kotlin.idea"})
public final class MoveKotlinDeclarationsHandlerKt {
    @NotNull
    private static final defaultHandlerActions.1 defaultHandlerActions = new MoveKotlinDeclarationsHandlerActions(){

        public void showErrorHint(Project project, Editor editor, @NlsContexts.DialogMessage String message2, @NlsContexts.DialogTitle String title, String helpId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)title, (String)helpId);
        }

        public void invokeMoveKotlinNestedClassesRefactoring(Project project, List<? extends KtClassOrObject> elementsToMove, KtClassOrObject originalClass, KtClassOrObject targetClass, MoveCallback moveCallback) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
            Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
            Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
            new MoveKotlinNestedClassesDialog(project, elementsToMove, originalClass, targetClass, null, moveCallback).show();
        }

        public void invokeMoveKotlinTopLevelDeclarationsRefactoring(Project project, Set<? extends KtNamedDeclaration> elementsToMove, String targetPackageName, PsiDirectory targetDirectory, KtFile targetFile, boolean freezeTargets, boolean moveToPackage, MoveCallback moveCallback) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
            Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
            MoveKotlinTopLevelDeclarationsDialog it = new MoveKotlinTopLevelDeclarationsDialog(project, elementsToMove, targetPackageName, targetDirectory, targetFile, freezeTargets, moveToPackage, moveCallback);
            boolean bl = false;
            if (Boolean.getBoolean("ide.performance.skip.refactoring.dialogs")) {
                it.performOKAction();
            } else {
                it.show();
            }
        }

        public void invokeKotlinSelectNestedClassChooser(KtClassOrObject nestedClass, PsiElement targetContainer) {
            Intrinsics.checkNotNullParameter((Object)nestedClass, (String)"nestedClass");
            KotlinSelectNestedClassRefactoringDialog.Companion.chooseNestedClassRefactoring(nestedClass, targetContainer);
        }

        public void invokeKotlinAwareMoveFilesOrDirectoriesRefactoring(Project project, PsiDirectory initialDirectory, List<? extends PsiFileSystemItem> elements, MoveCallback moveCallback) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            KotlinAwareMoveFilesOrDirectoriesDialog it = new KotlinAwareMoveFilesOrDirectoriesDialog(project, initialDirectory, elements, moveCallback);
            boolean bl = false;
            if (Boolean.getBoolean("ide.performance.skip.refactoring.dialogs")) {
                it.performOKAction();
            } else {
                it.show();
            }
        }
    };

    @Nls
    private static final String getMOVE_DECLARATIONS() {
        return KotlinBundle.message((String)"text.move.declarations", (Object[])new Object[0]);
    }

    public static final /* synthetic */ defaultHandlerActions.1 access$getDefaultHandlerActions$p() {
        return defaultHandlerActions;
    }

    public static final /* synthetic */ String access$getMOVE_DECLARATIONS() {
        return MoveKotlinDeclarationsHandlerKt.getMOVE_DECLARATIONS();
    }
}

