/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeActionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.DeleteEqualsAndHashCodeFix;
import org.jetbrains.kotlin.idea.inspections.GenerateEqualsOrHashCodeFix;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/EqualsOrHashCodeInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class EqualsOrHashCodeInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.classOrObjectVisitor(arg_0 -> EqualsOrHashCodeInspection.buildVisitor$lambda$0(holder2, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(ProblemsHolder $holder, KtClassOrObject classOrObject) {
        boolean hasHashCode;
        PsiElement psiElement = classOrObject.getNameIdentifier();
        if (psiElement == null) {
            return Unit.INSTANCE;
        }
        PsiElement nameIdentifier = psiElement;
        ClassDescriptor classDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(classOrObject, null, 1, null);
        if (classDescriptor == null) {
            return Unit.INSTANCE;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        boolean hasEquals = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredEquals(classDescriptor2, false) != null;
        boolean bl = hasHashCode = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredHashCode(classDescriptor2, false) != null;
        if (!hasEquals && !hasHashCode) {
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[classDescriptor2.getKind().ordinal()]) {
            case 1: {
                if (!((Collection)classOrObject.getSuperTypeListEntries()).isEmpty()) {
                    return Unit.INSTANCE;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{DeleteEqualsAndHashCodeFix.INSTANCE};
                $holder.registerProblem(nameIdentifier, KotlinBundle.message((String)"equals.hashcode.in.object.declaration", (Object[])new Object[0]), localQuickFixArray);
                break;
            }
            case 2: {
                if (hasEquals && hasHashCode) {
                    return Unit.INSTANCE;
                }
                Object[] objectArray = new Object[]{hasEquals ? "<code>equals()</code>" : "<code>hashCode()</code>", hasEquals ? "<code>hashCode()</code>" : "<code>equals()</code>"};
                String string = InspectionsBundle.message((String)"inspection.equals.hashcode.only.one.defined.problem.descriptor", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String description = string;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{hasEquals ? (GenerateEqualsOrHashCodeFix)GenerateEqualsOrHashCodeFix.HashCode.INSTANCE : (GenerateEqualsOrHashCodeFix)GenerateEqualsOrHashCodeFix.Equals.INSTANCE};
                $holder.registerProblem(nameIdentifier, description, localQuickFixArray);
                break;
            }
            default: {
                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

