/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.ArrayList;

public class ListStack<T>
extends ArrayList<T> {
    private int pointer = 0;

    public ListStack() {
    }

    public ListStack(int initialCapacity) {
        super(initialCapacity);
    }

    private ListStack(ArrayList<? extends T> list) {
        super(list);
    }

    public ListStack<T> copy() {
        ListStack<T> copy = new ListStack<T>(this);
        copy.pointer = this.pointer;
        return copy;
    }

    public void push(T item) {
        this.add(item);
        ++this.pointer;
    }

    public T pop() {
        --this.pointer;
        Object o = this.get(this.pointer);
        this.remove(this.pointer);
        return (T)o;
    }

    public T pop(int count) {
        T o = null;
        for (int i = count; i > 0; --i) {
            o = this.pop();
        }
        return o;
    }

    public void removeMultiple(int count) {
        while (count > 0) {
            --this.pointer;
            this.remove(this.pointer);
            --count;
        }
    }

    public T getByOffset(int offset) {
        return (T)this.get(this.pointer + offset);
    }

    public void insertByOffset(int offset, T item) {
        this.add(this.pointer + offset, item);
        ++this.pointer;
    }

    @Override
    public void clear() {
        super.clear();
        this.pointer = 0;
    }
}

