/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.geometry.DouglasPeuckerSimplification;
import org.jetbrains.letsPlot.core.commons.geometry.VisvalingamWhyattSimplification;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB#\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0011R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier;", "", "geometry", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "strategy", "Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$RankingStrategy;", "(Ljava/util/List;Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$RankingStrategy;)V", "indices", "", "getIndices", "()Ljava/util/List;", "isWeightLimitSet", "", "()Z", "myCountLimit", "myWeightLimit", "", "myWeights", "Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$WeightedPoint;", "points", "getPoints", "points$delegate", "Lkotlin/Lazy;", "setCountLimit", "countLimit", "setWeightLimit", "weightLimit", "Companion", "RankingStrategy", "WeightedPoint", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPolylineSimplifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolylineSimplifier.kt\norg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,116:1\n1559#2:117\n1590#2,3:118\n1559#2:121\n1590#2,4:122\n1593#2:126\n766#2:127\n857#2,2:128\n1054#2:130\n1477#2:131\n1502#2,3:132\n1505#2,3:142\n1045#2:145\n1549#2:146\n1620#2,2:147\n1549#2:149\n1620#2,3:150\n1622#2:153\n372#3,7:135\n*S KotlinDebug\n*F\n+ 1 PolylineSimplifier.kt\norg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier\n*L\n14#1:117\n14#1:118,3\n16#1:121\n16#1:122,4\n14#1:126\n30#1:127\n30#1:128,2\n31#1:130\n35#1:131\n35#1:132,3\n35#1:142,3\n37#1:145\n38#1:146\n38#1:147,2\n40#1:149\n40#1:150,3\n38#1:153\n35#1:135,7\n*E\n"})
public final class PolylineSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<List<DoubleVector>> geometry;
    @NotNull
    private final List<WeightedPoint> myWeights;
    private double myWeightLimit;
    private int myCountLimit;
    @NotNull
    private final Lazy points$delegate;
    public static final double DOUGLAS_PEUCKER_PIXEL_THRESHOLD = 0.25;

    /*
     * WARNING - void declaration
     */
    private PolylineSimplifier(List<? extends List<DoubleVector>> geometry, RankingStrategy strategy) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        this.geometry = geometry;
        Iterable iterable = this.geometry;
        PolylineSimplifier polylineSimplifier = this;
        boolean $i$f$mapIndexed = false;
        void var5_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv2;
            void subPath;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<Double> weights = strategy.computeWeights((List<DoubleVector>)subPath);
            Iterable $this$mapIndexed$iv2 = weights;
            boolean $i$f$mapIndexed2 = false;
            Iterable iterable2 = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv2 = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                void weight;
                void pointIndex;
                void subPathIndex;
                int n3;
                if ((n3 = index$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                double d = ((Number)item$iv$iv2).doubleValue();
                int n4 = n3;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new WeightedPoint((int)subPathIndex, (int)pointIndex, (double)weight));
            }
            collection.add((List)destination$iv$iv2);
        }
        polylineSimplifier.myWeights = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        this.myWeightLimit = Double.NaN;
        this.myCountLimit = -1;
        this.points$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends List<? extends DoubleVector>>>(this){
            final /* synthetic */ PolylineSimplifier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<List<DoubleVector>> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = CollectionsKt.zip((Iterable)this.this$0.getIndices(), (Iterable)PolylineSimplifier.access$getGeometry$p(this.this$0));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List indices2 = (List)pair2.component1();
                    List points2 = (List)pair2.component2();
                    collection.add(CollectionsKt.slice((List)points2, (Iterable)indices2));
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @NotNull
    public final List<List<DoubleVector>> getPoints() {
        Lazy lazy = this.points$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<Integer>> getIndices() {
        void $this$mapTo$iv$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        List list2;
        boolean bl = this.isWeightLimitSet();
        if (bl) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.myWeights;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                WeightedPoint it = (WeightedPoint)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getWeight() > this.myWeightLimit)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else if (!bl) {
            Iterable $this$sortedByDescending$iv = this.myWeights;
            boolean $i$f$sortedByDescending = false;
            list2 = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    WeightedPoint p0 = (WeightedPoint)b2;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(p0.getWeight());
                    p0 = (WeightedPoint)a2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(p0.getWeight()));
                }
            }), (int)this.myCountLimit);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List filtered = list2;
        Iterable $this$groupBy$iv = filtered;
        boolean $i$f$groupBy = false;
        Iterable $i$f$sortedByDescending = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            WeightedPoint p0 = (WeightedPoint)element$iv$iv;
            boolean bl3 = false;
            Integer key$iv$iv = p0.getSubPathIndex();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = destination$iv$iv.entrySet();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Map.Entry entry = (Map.Entry)a2;
                boolean bl = false;
                int subPathIndex = ((Number)entry.getKey()).intValue();
                entry = (Map.Entry)b2;
                Comparable comparable = Integer.valueOf(subPathIndex);
                bl = false;
                subPathIndex = ((Number)entry.getKey()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(subPathIndex));
            }
        });
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl5 = false;
            List weightedPoints = (List)entry.getValue();
            $this$getOrPut$iv$iv$iv = weightedPoints;
            boolean $i$f$map2 = false;
            value$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void p0;
                WeightedPoint weightedPoint = (WeightedPoint)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add(p0.getPointIndex());
            }
            object.add(CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)));
        }
        return (List)destination$iv$iv;
    }

    private final boolean isWeightLimitSet() {
        return !Double.isNaN(this.myWeightLimit);
    }

    @NotNull
    public final PolylineSimplifier setWeightLimit(double weightLimit) {
        this.myWeightLimit = weightLimit;
        this.myCountLimit = -1;
        return this;
    }

    @NotNull
    public final PolylineSimplifier setCountLimit(int countLimit) {
        this.myWeightLimit = Double.NaN;
        this.myCountLimit = countLimit;
        return this;
    }

    public /* synthetic */ PolylineSimplifier(List geometry, RankingStrategy strategy, DefaultConstructorMarker $constructor_marker) {
        this(geometry, strategy);
    }

    public static final /* synthetic */ List access$getGeometry$p(PolylineSimplifier $this) {
        return $this.geometry;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004J\u001a\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bJ.\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u0004J\u0014\u0010\f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001a\u0010\r\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$Companion;", "", "()V", "DOUGLAS_PEUCKER_PIXEL_THRESHOLD", "", "douglasPeucker", "Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier;", "points", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "threshold", "douglasPeuckerMultipath", "visvalingamWhyatt", "visvalingamWhyattMultipath", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PolylineSimplifier visvalingamWhyatt(@NotNull List<DoubleVector> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return new PolylineSimplifier(CollectionsKt.listOf(points2), new VisvalingamWhyattSimplification(), null);
        }

        @NotNull
        public final PolylineSimplifier visvalingamWhyattMultipath(@NotNull List<? extends List<DoubleVector>> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return new PolylineSimplifier(points2, new VisvalingamWhyattSimplification(), null);
        }

        @NotNull
        public final PolylineSimplifier douglasPeucker(@NotNull List<DoubleVector> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return new PolylineSimplifier(CollectionsKt.listOf(points2), new DouglasPeuckerSimplification(), null);
        }

        @NotNull
        public final PolylineSimplifier douglasPeuckerMultipath(@NotNull List<? extends List<DoubleVector>> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return new PolylineSimplifier(points2, new DouglasPeuckerSimplification(), null);
        }

        @NotNull
        public final List<DoubleVector> douglasPeucker(@NotNull List<DoubleVector> points2, double threshold) {
            List list2;
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            List<List<DoubleVector>> simplifiedPath = this.douglasPeucker(points2).setWeightLimit(threshold).getPoints();
            if (simplifiedPath.size() != 1) {
                System.out.println((Object)("PolylineSimplifier: expected a single path, but got " + simplifiedPath.size()));
            }
            if ((list2 = (List)CollectionsKt.firstOrNull(simplifiedPath)) == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        @NotNull
        public final List<List<DoubleVector>> douglasPeuckerMultipath(@NotNull List<? extends List<DoubleVector>> points2, double threshold) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return this.douglasPeuckerMultipath(points2).setWeightLimit(threshold).getPoints();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H&\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$RankingStrategy;", "", "computeWeights", "", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
    public static interface RankingStrategy {
        @NotNull
        public List<Double> computeWeights(@NotNull List<DoubleVector> var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/commons/geometry/PolylineSimplifier$WeightedPoint;", "", "subPathIndex", "", "pointIndex", "weight", "", "(IID)V", "getPointIndex", "()I", "getSubPathIndex", "getWeight", "()D", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "plot-base"})
    public static final class WeightedPoint {
        private final int subPathIndex;
        private final int pointIndex;
        private final double weight;

        public WeightedPoint(int subPathIndex, int pointIndex, double weight) {
            this.subPathIndex = subPathIndex;
            this.pointIndex = pointIndex;
            this.weight = weight;
        }

        public final int getSubPathIndex() {
            return this.subPathIndex;
        }

        public final int getPointIndex() {
            return this.pointIndex;
        }

        public final double getWeight() {
            return this.weight;
        }

        public final int component1() {
            return this.subPathIndex;
        }

        public final int component2() {
            return this.pointIndex;
        }

        public final double component3() {
            return this.weight;
        }

        @NotNull
        public final WeightedPoint copy(int subPathIndex, int pointIndex, double weight) {
            return new WeightedPoint(subPathIndex, pointIndex, weight);
        }

        public static /* synthetic */ WeightedPoint copy$default(WeightedPoint weightedPoint, int n, int n2, double d, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = weightedPoint.subPathIndex;
            }
            if ((n3 & 2) != 0) {
                n2 = weightedPoint.pointIndex;
            }
            if ((n3 & 4) != 0) {
                d = weightedPoint.weight;
            }
            return weightedPoint.copy(n, n2, d);
        }

        @NotNull
        public String toString() {
            return "WeightedPoint(subPathIndex=" + this.subPathIndex + ", pointIndex=" + this.pointIndex + ", weight=" + this.weight + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.subPathIndex);
            result2 = result2 * 31 + Integer.hashCode(this.pointIndex);
            result2 = result2 * 31 + Double.hashCode(this.weight);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WeightedPoint)) {
                return false;
            }
            WeightedPoint weightedPoint = (WeightedPoint)other;
            if (this.subPathIndex != weightedPoint.subPathIndex) {
                return false;
            }
            if (this.pointIndex != weightedPoint.pointIndex) {
                return false;
            }
            return Double.compare(this.weight, weightedPoint.weight) == 0;
        }
    }
}

