/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.internal.file.collections.PathVisitor;
import org.gradle.api.specs.Spec;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class ReproducibleDirectoryWalker
implements DirectoryWalker {
    private final FileSystem fileSystem;
    private static final Comparator<Path> FILES_FIRST = Comparator.comparing(x -> x.toFile().isDirectory()).thenComparing(Path::toString);

    public ReproducibleDirectoryWalker(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public void walkDir(Path rootDir, RelativePath rootPath, FileVisitor visitor, Spec<? super FileTreeElement> spec, AtomicBoolean stopFlag, boolean postfix) {
        try {
            PathVisitor pathVisitor = new PathVisitor(spec, postfix, visitor, stopFlag, rootPath, this.fileSystem);
            ReproducibleDirectoryWalker.visit(rootDir, pathVisitor);
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not list contents of directory '%s'.", rootDir), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileVisitResult visit(Path path, PathVisitor pathVisitor) throws IOException {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException next) {
                return pathVisitor.visitFileFailed(path, next);
            }
        }
        if (!attrs.isDirectory()) return pathVisitor.visitFile(path, attrs);
        FileVisitResult fvr = pathVisitor.preVisitDirectory(path, attrs);
        if (fvr == FileVisitResult.SKIP_SUBTREE) return fvr;
        if (fvr == FileVisitResult.TERMINATE) {
            return fvr;
        }
        IOException exception = null;
        try (Stream<Path> fileStream = Files.list(path);){
            Path child;
            FileVisitResult childResult;
            Iterable files = () -> fileStream.sorted(FILES_FIRST).iterator();
            Iterator iterator = files.iterator();
            do {
                if (!iterator.hasNext()) return pathVisitor.postVisitDirectory(path, exception);
            } while ((childResult = ReproducibleDirectoryWalker.visit(child = (Path)iterator.next(), pathVisitor)) != FileVisitResult.TERMINATE);
            FileVisitResult fileVisitResult = childResult;
            return fileVisitResult;
        }
        catch (IOException e) {
            exception = e;
        }
        return pathVisitor.postVisitDirectory(path, exception);
    }
}

