/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Effect;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.RandomChoice;

public class Disaster
extends FreeColSpecObjectType {
    public static final String TAG = "disaster";
    public static final String BANKRUPTCY = "model.disaster.bankruptcy";
    private boolean natural = false;
    private Effects numberOfEffects = Effects.ONE;
    private List<RandomChoice<Effect>> effects = null;
    private static final String EFFECT_TAG = "effect";
    private static final String EFFECTS_TAG = "effects";
    private static final String NATURAL_TAG = "natural";

    public Disaster(String id, Specification specification) {
        super(id, specification);
    }

    public final boolean isNatural() {
        return this.natural;
    }

    public final Effects getNumberOfEffects() {
        return this.numberOfEffects;
    }

    public final List<RandomChoice<Effect>> getEffects() {
        return this.effects == null ? Collections.emptyList() : this.effects;
    }

    protected void setEffects(List<RandomChoice<Effect>> effects) {
        if (this.effects == null) {
            this.effects = new ArrayList<RandomChoice<Effect>>();
        } else {
            this.effects.clear();
        }
        this.effects.addAll(effects);
    }

    private void addEffect(Effect effect) {
        if (this.effects == null) {
            this.effects = new ArrayList<RandomChoice<Effect>>();
        }
        this.effects.add(new RandomChoice<Effect>(effect, effect.getProbability()));
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Disaster o = this.copyInCast(other, Disaster.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.natural = o.isNatural();
        this.numberOfEffects = o.getNumberOfEffects();
        this.setEffects(o.getEffects());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NATURAL_TAG, this.natural);
        xw.writeAttribute(EFFECTS_TAG, this.numberOfEffects);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (RandomChoice<Effect> choice : this.getEffects()) {
            choice.getObject().toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Disaster parent = xr.getAlreadyInitializedType(spec, "extends", Disaster.class, this);
        this.natural = xr.getAttribute(NATURAL_TAG, parent.natural);
        this.numberOfEffects = xr.hasAttribute(EFFECTS_TAG) ? xr.getAttribute(EFFECTS_TAG, Effects.class, Effects.ONE) : parent.numberOfEffects;
    }

    @Override
    protected void clearContainers(FreeColXMLReader xr) throws XMLStreamException {
        super.clearContainers(xr);
        this.effects = null;
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        Disaster parent = xr.getAlreadyInitializedType(spec, "extends", Disaster.class, this);
        if (parent != this && !parent.getEffects().isEmpty()) {
            if (this.effects == null) {
                this.effects = new ArrayList<RandomChoice<Effect>>();
            }
            for (RandomChoice<Effect> choice : parent.getEffects()) {
                Effect effect = new Effect(choice.getObject());
                effect.getFeatureContainer().replaceSource(parent, this);
                this.addEffect(effect);
            }
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (EFFECT_TAG.equals(tag)) {
            Effect effect = new Effect(xr, spec);
            effect.getFeatureContainer().replaceSource(null, this);
            this.addEffect(effect);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getId());
        for (RandomChoice<Effect> choice : this.getEffects()) {
            sb.append(' ').append(choice.getObject());
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum Effects {
        ONE,
        SEVERAL,
        ALL;

    }
}

