/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.auth;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.auth.MqttReAuthHandler;
import com.hivemq.client.internal.rx.CompletableFlow;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import org.jetbrains.annotations.NotNull;

public class MqttReAuthCompletable
extends Completable {
    @NotNull
    private final MqttClientConfig clientConfig;

    public MqttReAuthCompletable(@NotNull MqttClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    protected void subscribeActual(@NotNull CompletableObserver s) {
        MqttClientConnectionConfig connectionConfig = this.clientConfig.getRawConnectionConfig();
        if (connectionConfig == null) {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.notConnected(), (CompletableObserver)s);
            return;
        }
        if (connectionConfig.getRawEnhancedAuthMechanism() == null) {
            EmptyDisposable.error((Throwable)new UnsupportedOperationException("Reauth is not available if enhanced auth was not used during connect"), (CompletableObserver)s);
            return;
        }
        Channel channel = connectionConfig.getChannel();
        ChannelHandler authHandler = channel.pipeline().get("auth");
        if (authHandler == null) {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.notConnected(), (CompletableObserver)s);
            return;
        }
        if (!(authHandler instanceof MqttReAuthHandler)) {
            EmptyDisposable.error((Throwable)new UnsupportedOperationException("Auth is still pending"), (CompletableObserver)s);
            return;
        }
        MqttReAuthHandler reAuthHandler = (MqttReAuthHandler)authHandler;
        CompletableFlow flow = new CompletableFlow(s);
        s.onSubscribe((Disposable)flow);
        reAuthHandler.reauth(flow);
    }
}

