/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import javax.transaction.xa.Xid;

public class SubordinateJTAXAResourceOrphanFilter
implements XAResourceOrphanFilter {
    public static final int RECOVER_ALL_NODES = 0;

    @Override
    public XAResourceOrphanFilter.Vote checkXid(Xid xid) {
        List<String> _xaRecoveryNodes = jtaPropertyManager.getJTAEnvironmentBean().getXaRecoveryNodes();
        if (_xaRecoveryNodes == null || _xaRecoveryNodes.isEmpty()) {
            jtaLogger.i18NLogger.info_recovery_noxanodes();
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        String nodeName = XATxConverter.getSubordinateNodeName(new XidImple(xid).getXID());
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug((Object)("subordinate node name of " + String.valueOf(xid) + " is " + nodeName));
        }
        if (!_xaRecoveryNodes.contains(nodeName)) {
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        if (nodeName != null) {
            if (this.transactionLog(xid, nodeName)) {
                return XAResourceOrphanFilter.Vote.ABSTAIN;
            }
            return XAResourceOrphanFilter.Vote.ROLLBACK;
        }
        return XAResourceOrphanFilter.Vote.ABSTAIN;
    }

    private boolean transactionLog(Xid recoveredResourceXid, String recoveredResourceNodeName) {
        block13: {
            XidImple theXid = new XidImple(recoveredResourceXid);
            Uid u = theXid.getTransactionUid();
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)("Checking whether Xid " + String.valueOf(theXid) + " exists in ObjectStore."));
            }
            if (!u.equals(Uid.nullUid())) {
                RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
                String transactionType = SubordinateAtomicAction.getType();
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug((Object)("Looking for " + String.valueOf(u) + " and " + transactionType));
                }
                InputObjectState states = new InputObjectState();
                try {
                    if (recoveryStore.allObjUids(transactionType, states) && states.notempty()) {
                        Stack values = new Stack();
                        boolean finished = false;
                        do {
                            Uid uid = null;
                            try {
                                uid = UidHelper.unpackFrom(states);
                            }
                            catch (IOException ex) {
                                jtaLogger.i18NLogger.warn_unpacking_xid_state(theXid, recoveryStore, transactionType, ex);
                                finished = true;
                            }
                            if (uid.notEquals(Uid.nullUid())) {
                                SubordinateAtomicAction tx = new SubordinateAtomicAction(uid, true);
                                XidImple transactionXid = (XidImple)tx.getXid();
                                if (transactionXid == null || !transactionXid.isSameTransaction(recoveredResourceXid)) continue;
                                if (jtaLogger.logger.isDebugEnabled()) {
                                    jtaLogger.logger.debug((Object)("Found record for " + String.valueOf(theXid)));
                                }
                                return true;
                            }
                            finished = true;
                        } while (!finished);
                        if (jtaLogger.logger.isDebugEnabled()) {
                            jtaLogger.logger.debug((Object)("No record found for " + String.valueOf(theXid)));
                        }
                        break block13;
                    }
                    jtaLogger.i18NLogger.info_recovery_notaxid(XAHelper.xidToString(recoveredResourceXid));
                }
                catch (ObjectStoreException e) {
                    jtaLogger.i18NLogger.warn_reading_from_object_store(recoveryStore, theXid, e);
                }
                catch (IOException e) {
                    jtaLogger.i18NLogger.warn_reading_from_object_store(recoveryStore, theXid, e);
                }
            }
        }
        return false;
    }
}

