/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.sort;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.sort.SortOrder;

public class MinAndMax<T extends Comparable<? super T>>
implements Writeable {
    private final T minValue;
    private final T maxValue;

    public MinAndMax(T minValue, T maxValue) {
        this.minValue = (Comparable)Objects.requireNonNull(minValue);
        this.maxValue = (Comparable)Objects.requireNonNull(maxValue);
    }

    public MinAndMax(StreamInput in) throws IOException {
        this.minValue = Lucene.readSortValue(in);
        this.maxValue = Lucene.readSortValue(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Lucene.writeSortValue(out, this.minValue);
        Lucene.writeSortValue(out, this.maxValue);
    }

    public T getMin() {
        return this.minValue;
    }

    public T getMax() {
        return this.maxValue;
    }

    public static Comparator<MinAndMax<?>> getComparator(SortOrder order) {
        Comparator<MinAndMax> cmp;
        Comparator<MinAndMax> comparator = cmp = order == SortOrder.ASC ? Comparator.comparing(MinAndMax::getMin) : Comparator.comparing(MinAndMax::getMax);
        if (order == SortOrder.DESC) {
            cmp = cmp.reversed();
        }
        return Comparator.nullsLast(cmp);
    }

    public int compareMin(Object object) {
        return this.compare(this.getMin(), object);
    }

    public int compareMax(Object object) {
        return this.compare(this.getMax(), object);
    }

    private int compare(T one, Object two) {
        if (one instanceof Long) {
            return Long.compare((Long)one, (Long)two);
        }
        if (one instanceof Integer) {
            return Integer.compare((Integer)one, (Integer)two);
        }
        if (one instanceof Float) {
            return Float.compare(((Float)one).floatValue(), ((Float)two).floatValue());
        }
        if (one instanceof Double) {
            return Double.compare((Double)one, (Double)two);
        }
        if (one instanceof BigInteger) {
            return ((BigInteger)one).compareTo((BigInteger)two);
        }
        if (one instanceof BytesRef) {
            return ((BytesRef)one).compareTo((BytesRef)two);
        }
        throw new UnsupportedOperationException("compare type not supported : " + String.valueOf(one.getClass()));
    }
}

