/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.wlm;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@ExperimentalApi
public class WlmStatsRequest
extends BaseNodesRequest<WlmStatsRequest> {
    private final Set<String> workloadGroupIds;
    private final Boolean breach;

    public WlmStatsRequest(StreamInput in) throws IOException {
        super(in);
        this.workloadGroupIds = new HashSet<String>(Set.of(in.readStringArray()));
        this.breach = in.readOptionalBoolean();
    }

    public WlmStatsRequest(String[] nodesIds, Set<String> workloadGroupIds, Boolean breach) {
        super(nodesIds);
        this.workloadGroupIds = workloadGroupIds;
        this.breach = breach;
    }

    public WlmStatsRequest() {
        super((String[])null);
        this.workloadGroupIds = new HashSet<String>();
        this.breach = false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.workloadGroupIds.toArray(new String[0]));
        out.writeOptionalBoolean(this.breach);
    }

    public Set<String> getWorkloadGroupIds() {
        return this.workloadGroupIds;
    }

    public Boolean isBreach() {
        return this.breach;
    }
}

