/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools.jcore;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.oops.CheckedExceptionElement;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ExceptionTableElement;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LineNumberTableElement;
import sun.jvm.hotspot.oops.LocalVariableTableElement;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.ClassConstants;
import sun.jvm.hotspot.tools.jcore.ByteCodeRewriter;
import sun.jvm.hotspot.utilities.KlassArray;
import sun.jvm.hotspot.utilities.MethodArray;
import sun.jvm.hotspot.utilities.U1Array;
import sun.jvm.hotspot.utilities.U2Array;

public class ClassWriter
implements ClassConstants {
    public static final boolean DEBUG = false;
    protected InstanceKlass klass;
    protected DataOutputStream dos;
    protected ConstantPool cpool;
    protected Map<String, Short> classToIndex = new HashMap<String, Short>();
    protected Map<String, Short> utf8ToIndex = new HashMap<String, Short>();
    protected short _sourceFileIndex;
    protected short _innerClassesIndex;
    protected short _syntheticIndex;
    protected short _deprecatedIndex;
    protected short _constantValueIndex;
    protected short _codeIndex;
    protected short _exceptionsIndex;
    protected short _lineNumberTableIndex;
    protected short _localVariableTableIndex;
    protected short _signatureIndex;

    protected void debugMessage(String message) {
        System.out.println(message);
    }

    protected static int extractHighShortFromInt(int val) {
        return val >> 16 & 0xFFFF;
    }

    protected static int extractLowShortFromInt(int val) {
        return val & 0xFFFF;
    }

    public ClassWriter(InstanceKlass kls, OutputStream os) {
        this.klass = kls;
        this.dos = new DataOutputStream(os);
        this.cpool = this.klass.getConstants();
    }

    public void write() throws IOException {
        this.dos.writeInt(-889275714);
        this.writeVersion();
        this.writeConstantPool();
        this.writeClassAccessFlags();
        this.writeThisClass();
        this.writeSuperClass();
        this.writeInterfaces();
        this.writeFields();
        this.writeMethods();
        this.writeClassAttributes();
        this.dos.flush();
    }

    protected void writeVersion() throws IOException {
        this.dos.writeShort((short)this.klass.minorVersion());
        this.dos.writeShort((short)this.klass.majorVersion());
    }

    protected void writeIndex(int index) throws IOException {
        if (index == 0) {
            throw new InternalError();
        }
        this.dos.writeShort(index);
    }

    protected void writeConstantPool() throws IOException {
        U1Array tags = this.cpool.getTags();
        long len = tags.length();
        this.dos.writeShort((short)len);
        int ci = 0;
        ci = 1;
        while ((long)ci < len) {
            byte cpConstType = tags.at(ci);
            if (cpConstType == 1) {
                Symbol sym = this.cpool.getSymbolAt(ci);
                this.utf8ToIndex.put(sym.asString(), new Short((short)ci));
            } else if (cpConstType == 5 || cpConstType == 6) {
                ++ci;
            }
            ++ci;
        }
        Short sourceFileIndex = this.utf8ToIndex.get("SourceFile");
        this._sourceFileIndex = sourceFileIndex != null ? sourceFileIndex : (short)0;
        Short innerClassesIndex = this.utf8ToIndex.get("InnerClasses");
        this._innerClassesIndex = innerClassesIndex != null ? innerClassesIndex : (short)0;
        Short constantValueIndex = this.utf8ToIndex.get("ConstantValue");
        this._constantValueIndex = constantValueIndex != null ? constantValueIndex : (short)0;
        Short syntheticIndex = this.utf8ToIndex.get("Synthetic");
        this._syntheticIndex = syntheticIndex != null ? syntheticIndex : (short)0;
        Short deprecatedIndex = this.utf8ToIndex.get("Deprecated");
        this._deprecatedIndex = deprecatedIndex != null ? deprecatedIndex : (short)0;
        Short codeIndex = this.utf8ToIndex.get("Code");
        this._codeIndex = codeIndex != null ? codeIndex : (short)0;
        Short exceptionsIndex = this.utf8ToIndex.get("Exceptions");
        this._exceptionsIndex = exceptionsIndex != null ? exceptionsIndex : (short)0;
        Short lineNumberTableIndex = this.utf8ToIndex.get("LineNumberTable");
        this._lineNumberTableIndex = lineNumberTableIndex != null ? lineNumberTableIndex : (short)0;
        Short localVariableTableIndex = this.utf8ToIndex.get("LocalVariableTable");
        this._localVariableTableIndex = localVariableTableIndex != null ? localVariableTableIndex : (short)0;
        Short signatureIdx = this.utf8ToIndex.get("Signature");
        this._signatureIndex = signatureIdx != null ? signatureIdx : (short)0;
        ci = 1;
        while ((long)ci < len) {
            byte cpConstType = tags.at(ci);
            switch (cpConstType) {
                case 1: {
                    this.dos.writeByte(cpConstType);
                    Symbol sym = this.cpool.getSymbolAt(ci);
                    this.dos.writeShort((short)sym.getLength());
                    this.dos.write(sym.asByteArray());
                    break;
                }
                case 2: {
                    throw new IllegalArgumentException("Unicode constant!");
                }
                case 3: {
                    this.dos.writeByte(cpConstType);
                    this.dos.writeInt(this.cpool.getIntAt(ci));
                    break;
                }
                case 4: {
                    this.dos.writeByte(cpConstType);
                    this.dos.writeFloat(this.cpool.getFloatAt(ci));
                    break;
                }
                case 5: {
                    this.dos.writeByte(cpConstType);
                    long l = this.cpool.getLongAt(ci);
                    ++ci;
                    this.dos.writeLong(l);
                    break;
                }
                case 6: {
                    this.dos.writeByte(cpConstType);
                    this.dos.writeDouble(this.cpool.getDoubleAt(ci));
                    ++ci;
                    break;
                }
                case 7: 
                case 100: 
                case 103: {
                    this.dos.writeByte(7);
                    String klassName = this.cpool.getKlassNameAt(ci).asString();
                    Short s = this.utf8ToIndex.get(klassName);
                    this.classToIndex.put(klassName, new Short((short)ci));
                    this.dos.writeShort(s.shortValue());
                    break;
                }
                case 8: {
                    this.dos.writeByte(cpConstType);
                    String str = this.cpool.getUnresolvedStringAt(ci).asString();
                    Short s = this.utf8ToIndex.get(str);
                    this.dos.writeShort(s.shortValue());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.dos.writeByte(cpConstType);
                    int value = this.cpool.getIntAt(ci);
                    short klassIndex = (short)ClassWriter.extractLowShortFromInt(value);
                    short nameAndTypeIndex = (short)ClassWriter.extractHighShortFromInt(value);
                    this.dos.writeShort(klassIndex);
                    this.dos.writeShort(nameAndTypeIndex);
                    break;
                }
                case 12: {
                    this.dos.writeByte(cpConstType);
                    int value = this.cpool.getIntAt(ci);
                    short nameIndex = (short)ClassWriter.extractLowShortFromInt(value);
                    short signatureIndex = (short)ClassWriter.extractHighShortFromInt(value);
                    this.dos.writeShort(nameIndex);
                    this.dos.writeShort(signatureIndex);
                    break;
                }
                case 15: {
                    this.dos.writeByte(cpConstType);
                    int value = this.cpool.getIntAt(ci);
                    byte refKind = (byte)ClassWriter.extractLowShortFromInt(value);
                    short memberIndex = (short)ClassWriter.extractHighShortFromInt(value);
                    this.dos.writeByte(refKind);
                    this.dos.writeShort(memberIndex);
                    break;
                }
                case 16: {
                    this.dos.writeByte(cpConstType);
                    int value = this.cpool.getIntAt(ci);
                    short refIndex = (short)value;
                    this.dos.writeShort(refIndex);
                    break;
                }
                case 18: {
                    this.dos.writeByte(cpConstType);
                    int value = this.cpool.getIntAt(ci);
                    short bsmIndex = (short)ClassWriter.extractLowShortFromInt(value);
                    short nameAndTypeIndex = (short)ClassWriter.extractHighShortFromInt(value);
                    this.dos.writeShort(bsmIndex);
                    this.dos.writeShort(nameAndTypeIndex);
                    break;
                }
                default: {
                    throw new InternalError("Unknown tag: " + cpConstType);
                }
            }
            ++ci;
        }
    }

    protected void writeClassAccessFlags() throws IOException {
        int flags = (int)(this.klass.getAccessFlags() & 0x7631L);
        this.dos.writeShort((short)flags);
    }

    protected void writeThisClass() throws IOException {
        String klassName = this.klass.getName().asString();
        Short index = this.classToIndex.get(klassName);
        this.dos.writeShort(index.shortValue());
    }

    protected void writeSuperClass() throws IOException {
        Klass superKlass = this.klass.getSuper();
        if (superKlass != null) {
            String superName = superKlass.getName().asString();
            Short index = this.classToIndex.get(superName);
            this.dos.writeShort(index.shortValue());
        } else {
            this.dos.writeShort(0);
        }
    }

    protected void writeInterfaces() throws IOException {
        KlassArray interfaces = this.klass.getLocalInterfaces();
        int len = interfaces.length();
        this.dos.writeShort((short)len);
        for (int i = 0; i < len; ++i) {
            Klass k = interfaces.getAt(i);
            Short index = this.classToIndex.get(k.getName().asString());
            this.dos.writeShort(index.shortValue());
        }
    }

    protected void writeFields() throws IOException {
        int javaFieldsCount = this.klass.getJavaFieldsCount();
        this.dos.writeShort((short)javaFieldsCount);
        for (int index = 0; index < javaFieldsCount; ++index) {
            short genSigIndex;
            short initvalIndex;
            short accessFlags = this.klass.getFieldAccessFlags(index);
            this.dos.writeShort(accessFlags & 0x50DF);
            short nameIndex = this.klass.getFieldNameIndex(index);
            this.dos.writeShort(nameIndex);
            short signatureIndex = this.klass.getFieldSignatureIndex(index);
            this.dos.writeShort(signatureIndex);
            int fieldAttributeCount = 0;
            boolean hasSyn = this.hasSyntheticAttribute(accessFlags);
            if (hasSyn) {
                fieldAttributeCount = (short)(fieldAttributeCount + 1);
            }
            if ((initvalIndex = this.klass.getFieldInitialValueIndex(index)) != 0) {
                fieldAttributeCount = (short)(fieldAttributeCount + 1);
            }
            if ((genSigIndex = this.klass.getFieldGenericSignatureIndex(index)) != 0) {
                fieldAttributeCount = (short)(fieldAttributeCount + 1);
            }
            this.dos.writeShort(fieldAttributeCount);
            if (hasSyn) {
                this.writeSynthetic();
            }
            if (initvalIndex != 0) {
                this.writeIndex(this._constantValueIndex);
                this.dos.writeInt(2);
                this.dos.writeShort(initvalIndex);
            }
            if (genSigIndex == 0) continue;
            this.writeIndex(this._signatureIndex);
            this.dos.writeInt(2);
            this.dos.writeShort(genSigIndex);
        }
    }

    protected boolean isSynthetic(short accessFlags) {
        return (accessFlags & 0x1000) != 0;
    }

    protected boolean hasSyntheticAttribute(short accessFlags) {
        return this.isSynthetic(accessFlags) && this._syntheticIndex != 0;
    }

    protected void writeSynthetic() throws IOException {
        this.writeIndex(this._syntheticIndex);
        this.dos.writeInt(0);
    }

    protected void writeMethods() throws IOException {
        MethodArray methods = this.klass.getMethods();
        int len = methods.length();
        this.dos.writeShort((short)len);
        for (int m = 0; m < len; ++m) {
            this.writeMethod(methods.at(m));
        }
    }

    protected void writeMethod(Method m) throws IOException {
        boolean isGeneric;
        boolean isCodeAvailable;
        boolean hasCheckedExceptions;
        long accessFlags = m.getAccessFlags();
        this.dos.writeShort((short)(accessFlags & 0x1DFFL));
        this.dos.writeShort((short)m.getNameIndex());
        this.dos.writeShort((short)m.getSignatureIndex());
        boolean isNative = (accessFlags & 0x100L) != 0L;
        boolean isAbstract = (accessFlags & 0x400L) != 0L;
        int methodAttributeCount = 0;
        boolean hasSyn = this.hasSyntheticAttribute((short)accessFlags);
        if (hasSyn) {
            methodAttributeCount = (short)(methodAttributeCount + 1);
        }
        if (hasCheckedExceptions = m.hasCheckedExceptions()) {
            methodAttributeCount = (short)(methodAttributeCount + 1);
        }
        boolean bl = isCodeAvailable = !isNative && !isAbstract;
        if (isCodeAvailable) {
            methodAttributeCount = (short)(methodAttributeCount + 1);
        }
        boolean bl2 = isGeneric = m.getGenericSignature() != null;
        if (isGeneric) {
            methodAttributeCount = (short)(methodAttributeCount + 1);
        }
        this.dos.writeShort(methodAttributeCount);
        if (hasSyn) {
            this.writeSynthetic();
        }
        if (isCodeAvailable) {
            int l;
            byte[] code = m.getByteCode();
            int codeAttrCount = 0;
            int codeSize = 8 + code.length + 2 + 2;
            boolean hasExceptionTable = m.hasExceptionTable();
            ExceptionTableElement[] exceptionTable = null;
            int exceptionTableLen = 0;
            if (hasExceptionTable) {
                exceptionTable = m.getExceptionTable();
                exceptionTableLen = exceptionTable.length;
                codeSize += exceptionTableLen * 8;
            }
            boolean hasLineNumberTable = m.hasLineNumberTable();
            LineNumberTableElement[] lineNumberTable = null;
            int lineNumberAttrLen = 0;
            if (hasLineNumberTable) {
                lineNumberTable = m.getLineNumberTable();
                lineNumberAttrLen = 2 + lineNumberTable.length * 4;
                codeSize += 6 + lineNumberAttrLen;
                codeAttrCount = (short)(codeAttrCount + 1);
            }
            boolean hasLocalVariableTable = m.hasLocalVariableTable();
            LocalVariableTableElement[] localVariableTable = null;
            int localVarAttrLen = 0;
            if (hasLocalVariableTable) {
                localVariableTable = m.getLocalVariableTable();
                localVarAttrLen = 2 + localVariableTable.length * 10;
                codeSize += 6 + localVarAttrLen;
                codeAttrCount = (short)(codeAttrCount + 1);
            }
            this.rewriteByteCode(m, code);
            this.writeIndex(this._codeIndex);
            this.dos.writeInt(codeSize);
            this.dos.writeShort((short)m.getMaxStack());
            this.dos.writeShort((short)m.getMaxLocals());
            this.dos.writeInt(code.length);
            this.dos.write(code);
            this.dos.writeShort((short)exceptionTableLen);
            if (exceptionTableLen != 0) {
                for (int e = 0; e < exceptionTableLen; ++e) {
                    this.dos.writeShort((short)exceptionTable[e].getStartPC());
                    this.dos.writeShort((short)exceptionTable[e].getEndPC());
                    this.dos.writeShort((short)exceptionTable[e].getHandlerPC());
                    this.dos.writeShort((short)exceptionTable[e].getCatchTypeIndex());
                }
            }
            this.dos.writeShort(codeAttrCount);
            if (hasLineNumberTable) {
                this.writeIndex(this._lineNumberTableIndex);
                this.dos.writeInt(lineNumberAttrLen);
                this.dos.writeShort((short)lineNumberTable.length);
                for (l = 0; l < lineNumberTable.length; ++l) {
                    this.dos.writeShort((short)lineNumberTable[l].getStartBCI());
                    this.dos.writeShort((short)lineNumberTable[l].getLineNumber());
                }
            }
            if (hasLocalVariableTable) {
                this.writeIndex(this._localVariableTableIndex);
                this.dos.writeInt(localVarAttrLen);
                this.dos.writeShort((short)localVariableTable.length);
                for (l = 0; l < localVariableTable.length; ++l) {
                    this.dos.writeShort((short)localVariableTable[l].getStartBCI());
                    this.dos.writeShort((short)localVariableTable[l].getLength());
                    this.dos.writeShort((short)localVariableTable[l].getNameCPIndex());
                    this.dos.writeShort((short)localVariableTable[l].getDescriptorCPIndex());
                    this.dos.writeShort((short)localVariableTable[l].getSlot());
                }
            }
        }
        if (hasCheckedExceptions) {
            CheckedExceptionElement[] exceptions = m.getCheckedExceptions();
            this.writeIndex(this._exceptionsIndex);
            int attrSize = 2 + exceptions.length * 2;
            this.dos.writeInt(attrSize);
            this.dos.writeShort(exceptions.length);
            for (int e = 0; e < exceptions.length; ++e) {
                short cpIndex = (short)exceptions[e].getClassCPIndex();
                this.dos.writeShort(cpIndex);
            }
        }
        if (isGeneric) {
            this.writeGenericSignature(m.getGenericSignature().asString());
        }
    }

    protected void rewriteByteCode(Method m, byte[] code) {
        ByteCodeRewriter r = new ByteCodeRewriter(m, this.cpool, code);
        r.rewrite();
    }

    protected void writeGenericSignature(String signature) throws IOException {
        this.writeIndex(this._signatureIndex);
        this.dos.writeInt(2);
        Short index = this.utf8ToIndex.get(signature);
        this.dos.writeShort(index.shortValue());
    }

    protected void writeClassAttributes() throws IOException {
        U2Array innerClasses;
        int numInnerClasses;
        Symbol genericSignature;
        Symbol sourceFileName;
        long flags = this.klass.getAccessFlags();
        boolean hasSyn = this.hasSyntheticAttribute((short)flags);
        int classAttributeCount = 0;
        if (hasSyn) {
            classAttributeCount = (short)(classAttributeCount + 1);
        }
        if ((sourceFileName = this.klass.getSourceFileName()) != null) {
            classAttributeCount = (short)(classAttributeCount + 1);
        }
        if ((genericSignature = this.klass.getGenericSignature()) != null) {
            classAttributeCount = (short)(classAttributeCount + 1);
        }
        if ((numInnerClasses = (innerClasses = this.klass.getInnerClasses()).length() / 4) != 0) {
            classAttributeCount = (short)(classAttributeCount + 1);
        }
        this.dos.writeShort(classAttributeCount);
        if (hasSyn) {
            this.writeSynthetic();
        }
        if (sourceFileName != null) {
            this.writeIndex(this._sourceFileIndex);
            this.dos.writeInt(2);
            Short index = this.utf8ToIndex.get(sourceFileName.asString());
            this.dos.writeShort(index.shortValue());
        }
        if (genericSignature != null) {
            this.writeGenericSignature(genericSignature.asString());
        }
        if (numInnerClasses != 0) {
            this.writeIndex(this._innerClassesIndex);
            int innerAttrLen = 2 + numInnerClasses * 8;
            this.dos.writeInt(innerAttrLen);
            this.dos.writeShort(numInnerClasses);
            for (int index = 0; index < numInnerClasses * 4; ++index) {
                this.dos.writeShort(innerClasses.at(index));
            }
        }
    }
}

