/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt;

import io.sf.carte.echosvg.gvt.AbstractGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.RootGraphicsNode;
import io.sf.carte.echosvg.util.HaltingThread;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CompositeGraphicsNode
extends AbstractGraphicsNode
implements List<GraphicsNode> {
    public static final Rectangle2D VIEWPORT = new Rectangle();
    public static final Rectangle2D NULL_RECT = new Rectangle();
    protected GraphicsNode[] children;
    protected volatile int count;
    protected volatile int modCount;
    protected Rectangle2D backgroundEnableRgn = null;
    private volatile Rectangle2D geometryBounds;
    private volatile Rectangle2D primitiveBounds;
    private volatile Rectangle2D sensitiveBounds;
    private Shape outline;

    public List<GraphicsNode> getChildren() {
        return this;
    }

    public void setBackgroundEnable(Rectangle2D rectangle2D) {
        this.backgroundEnableRgn = rectangle2D;
    }

    public Rectangle2D getBackgroundEnable() {
        return this.backgroundEnableRgn;
    }

    @Override
    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    @Override
    public void primitivePaint(Graphics2D graphics2D) {
        if (this.count == 0) {
            return;
        }
        Thread thread = Thread.currentThread();
        for (int i = 0; i < this.count; ++i) {
            if (HaltingThread.hasBeenHalted((Thread)thread)) {
                return;
            }
            GraphicsNode graphicsNode = this.children[i];
            if (graphicsNode == null) continue;
            graphicsNode.paint(graphics2D);
        }
    }

    @Override
    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.geometryBounds = null;
        this.primitiveBounds = null;
        this.sensitiveBounds = null;
        this.outline = null;
    }

    @Override
    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds != null) {
            if (this.primitiveBounds == NULL_RECT) {
                return null;
            }
            return this.primitiveBounds;
        }
        Thread thread = Thread.currentThread();
        int n = 0;
        Rectangle2D rectangle2D = null;
        while (rectangle2D == null && n < this.count) {
            rectangle2D = this.children[n++].getTransformedBounds(IDENTITY);
            if ((n & 0xF) != 0 || !HaltingThread.hasBeenHalted((Thread)thread)) continue;
        }
        if (HaltingThread.hasBeenHalted((Thread)thread)) {
            this.invalidateGeometryCache();
            return null;
        }
        if (rectangle2D == null) {
            this.primitiveBounds = NULL_RECT;
            return null;
        }
        this.primitiveBounds = rectangle2D;
        while (n < this.count) {
            Rectangle2D rectangle2D2;
            if ((rectangle2D2 = this.children[n++].getTransformedBounds(IDENTITY)) != null) {
                if (this.primitiveBounds == null) {
                    return null;
                }
                this.primitiveBounds.add(rectangle2D2);
            }
            if ((n & 0xF) != 0 || !HaltingThread.hasBeenHalted((Thread)thread)) continue;
            break;
        }
        if (HaltingThread.hasBeenHalted((Thread)thread)) {
            this.invalidateGeometryCache();
        }
        return this.primitiveBounds;
    }

    public static Rectangle2D getTransformedBBox(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        if (affineTransform == null || rectangle2D == null) {
            return rectangle2D;
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getHeight();
        double d5 = affineTransform.getScaleX();
        double d6 = affineTransform.getScaleY();
        if (d5 < 0.0) {
            d = -(d + d2);
            d5 = -d5;
        }
        if (d6 < 0.0) {
            d3 = -(d3 + d4);
            d6 = -d6;
        }
        return new Rectangle2D.Float((float)(d * d5 + affineTransform.getTranslateX()), (float)(d3 * d6 + affineTransform.getTranslateY()), (float)(d2 * d5), (float)(d4 * d6));
    }

    @Override
    public Rectangle2D getTransformedPrimitiveBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        if (affineTransform2 == null || affineTransform2.getShearX() == 0.0 && affineTransform2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getPrimitiveBounds(), affineTransform2);
        }
        int n = 0;
        Rectangle2D rectangle2D = null;
        while (rectangle2D == null && n < this.count) {
            rectangle2D = this.children[n++].getTransformedBounds(affineTransform2);
        }
        while (n < this.count) {
            Rectangle2D rectangle2D2;
            if ((rectangle2D2 = this.children[n++].getTransformedBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            int n = 0;
            while (this.geometryBounds == null && n < this.count) {
                this.geometryBounds = this.children[n++].getTransformedGeometryBounds(IDENTITY);
            }
            while (n < this.count) {
                Rectangle2D rectangle2D;
                if ((rectangle2D = this.children[n++].getTransformedGeometryBounds(IDENTITY)) == null) continue;
                if (this.geometryBounds == null) {
                    return this.getGeometryBounds();
                }
                this.geometryBounds.add(rectangle2D);
            }
        }
        return this.geometryBounds;
    }

    @Override
    public Rectangle2D getTransformedGeometryBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        if (affineTransform2 == null || affineTransform2.getShearX() == 0.0 && affineTransform2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getGeometryBounds(), affineTransform2);
        }
        Rectangle2D rectangle2D = null;
        int n = 0;
        while (rectangle2D == null && n < this.count) {
            rectangle2D = this.children[n++].getTransformedGeometryBounds(affineTransform2);
        }
        Rectangle2D rectangle2D2 = null;
        while (n < this.count) {
            if ((rectangle2D2 = this.children[n++].getTransformedGeometryBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public Rectangle2D getSensitiveBounds() {
        if (this.sensitiveBounds != null) {
            return this.sensitiveBounds;
        }
        int n = 0;
        while (this.sensitiveBounds == null && n < this.count) {
            this.sensitiveBounds = this.children[n++].getTransformedSensitiveBounds(IDENTITY);
        }
        while (n < this.count) {
            Rectangle2D rectangle2D;
            if ((rectangle2D = this.children[n++].getTransformedSensitiveBounds(IDENTITY)) == null) continue;
            if (this.sensitiveBounds == null) {
                return this.getSensitiveBounds();
            }
            this.sensitiveBounds.add(rectangle2D);
        }
        return this.sensitiveBounds;
    }

    @Override
    public Rectangle2D getTransformedSensitiveBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        if (affineTransform2 == null || affineTransform2.getShearX() == 0.0 && affineTransform2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getSensitiveBounds(), affineTransform2);
        }
        Rectangle2D rectangle2D = null;
        int n = 0;
        while (rectangle2D == null && n < this.count) {
            rectangle2D = this.children[n++].getTransformedSensitiveBounds(affineTransform2);
        }
        while (n < this.count) {
            Rectangle2D rectangle2D2;
            if ((rectangle2D2 = this.children[n++].getTransformedSensitiveBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public boolean contains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getSensitiveBounds();
        if (this.count > 0 && rectangle2D != null && rectangle2D.contains(point2D)) {
            Point2D point2D2 = null;
            Point2D point2D3 = null;
            for (int i = 0; i < this.count; ++i) {
                AffineTransform affineTransform = this.children[i].getInverseTransform();
                point2D3 = affineTransform != null ? (point2D2 = affineTransform.transform(point2D, point2D2)) : point2D;
                if (!this.children[i].contains(point2D3)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public GraphicsNode nodeHitAt(Point2D point2D) {
        Rectangle2D rectangle2D = this.getSensitiveBounds();
        if (this.count > 0 && rectangle2D != null && rectangle2D.contains(point2D)) {
            Point2D point2D2 = null;
            Point2D point2D3 = null;
            for (int i = this.count - 1; i >= 0; --i) {
                AffineTransform affineTransform = this.children[i].getInverseTransform();
                point2D3 = affineTransform != null ? (point2D2 = affineTransform.transform(point2D, point2D2)) : point2D;
                GraphicsNode graphicsNode = this.children[i].nodeHitAt(point2D3);
                if (graphicsNode == null) continue;
                return graphicsNode;
            }
        }
        return null;
    }

    @Override
    public Shape getOutline() {
        if (this.outline != null) {
            return this.outline;
        }
        this.outline = new GeneralPath();
        for (int i = 0; i < this.count; ++i) {
            Shape shape = this.children[i].getOutline();
            if (shape == null) continue;
            AffineTransform affineTransform = this.children[i].getTransform();
            if (affineTransform != null) {
                ((GeneralPath)this.outline).append(affineTransform.createTransformedShape(shape), false);
                continue;
            }
            ((GeneralPath)this.outline).append(shape, false);
        }
        return this.outline;
    }

    @Override
    protected void setRoot(RootGraphicsNode rootGraphicsNode) {
        super.setRoot(rootGraphicsNode);
        for (int i = 0; i < this.count; ++i) {
            GraphicsNode graphicsNode = this.children[i];
            ((AbstractGraphicsNode)graphicsNode).setRoot(rootGraphicsNode);
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public Iterator<GraphicsNode> iterator() {
        return new Itr();
    }

    public GraphicsNode[] toArray() {
        GraphicsNode[] graphicsNodeArray = new GraphicsNode[this.count];
        System.arraycopy(this.children, 0, graphicsNodeArray, 0, this.count);
        return graphicsNodeArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.count) {
            return Arrays.copyOf(this.children, this.count, TArray.getClass());
        }
        System.arraycopy(this.children, 0, TArray, 0, this.count);
        if (TArray.length > this.count) {
            TArray[this.count] = null;
        }
        return TArray;
    }

    @Override
    public GraphicsNode get(int n) {
        this.checkRange(n);
        return this.children[n];
    }

    @Override
    public GraphicsNode set(int n, GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof GraphicsNode)) {
            throw new IllegalArgumentException(graphicsNode + " is not a GraphicsNode");
        }
        this.checkRange(n);
        GraphicsNode graphicsNode2 = graphicsNode;
        this.fireGraphicsNodeChangeStarted(graphicsNode2);
        if (graphicsNode2.getParent() != null) {
            graphicsNode2.getParent().getChildren().remove(graphicsNode2);
        }
        GraphicsNode graphicsNode3 = this.children[n];
        this.children[n] = graphicsNode2;
        ((AbstractGraphicsNode)graphicsNode2).setParent(this);
        ((AbstractGraphicsNode)graphicsNode3).setParent(null);
        ((AbstractGraphicsNode)graphicsNode2).setRoot(this.getRoot());
        ((AbstractGraphicsNode)graphicsNode3).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return graphicsNode3;
    }

    @Override
    public boolean add(GraphicsNode graphicsNode) {
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        if (graphicsNode.getParent() != null) {
            graphicsNode.getParent().getChildren().remove(graphicsNode);
        }
        this.ensureCapacity(this.count + 1);
        this.children[this.count++] = graphicsNode;
        ((AbstractGraphicsNode)graphicsNode).setParent(this);
        ((AbstractGraphicsNode)graphicsNode).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return true;
    }

    @Override
    public void add(int n, GraphicsNode graphicsNode) {
        if (n > this.count || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.count);
        }
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        if (graphicsNode.getParent() != null) {
            graphicsNode.getParent().getChildren().remove(graphicsNode);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.children, n, this.children, n + 1, this.count - n);
        this.children[n] = graphicsNode;
        ++this.count;
        ((AbstractGraphicsNode)graphicsNode).setParent(this);
        ((AbstractGraphicsNode)graphicsNode).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public boolean addAll(Collection<? extends GraphicsNode> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends GraphicsNode> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        GraphicsNode graphicsNode = (GraphicsNode)object;
        if (graphicsNode.getParent() != this) {
            return false;
        }
        int n = 0;
        while (graphicsNode != this.children[n]) {
            ++n;
        }
        this.remove(n);
        return true;
    }

    @Override
    public GraphicsNode remove(int n) {
        this.checkRange(n);
        GraphicsNode graphicsNode = this.children[n];
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        ++this.modCount;
        int n2 = this.count - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.children, n + 1, this.children, n, n2);
        }
        this.children[--this.count] = null;
        if (this.count == 0) {
            this.children = null;
        }
        ((AbstractGraphicsNode)graphicsNode).setParent(null);
        ((AbstractGraphicsNode)graphicsNode).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return graphicsNode;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null || !(object instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)object).getParent() == this) {
            int n = this.count;
            GraphicsNode[] graphicsNodeArray = this.children;
            for (int i = 0; i < n; ++i) {
                if (object != graphicsNodeArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null || !(object instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)object).getParent() == this) {
            for (int i = this.count - 1; i >= 0; --i) {
                if (object != this.children[i]) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<GraphicsNode> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<GraphicsNode> listIterator(int n) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListItr(n);
    }

    @Override
    public List<GraphicsNode> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    private void checkRange(int n) {
        if (n >= this.count || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.count);
        }
    }

    public void ensureCapacity(int n) {
        if (this.children == null) {
            this.children = new GraphicsNode[4];
        }
        ++this.modCount;
        int n2 = this.children.length;
        if (n > n2) {
            GraphicsNode[] graphicsNodeArray = this.children;
            int n3 = n2 + n2 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.children = new GraphicsNode[n3];
            System.arraycopy(graphicsNodeArray, 0, this.children, 0, this.count);
        }
    }

    private class Itr
    implements Iterator<GraphicsNode> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = CompositeGraphicsNode.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != CompositeGraphicsNode.this.count;
        }

        @Override
        public GraphicsNode next() {
            try {
                GraphicsNode graphicsNode = CompositeGraphicsNode.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return graphicsNode;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CompositeGraphicsNode.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<GraphicsNode> {
        ListItr(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public GraphicsNode previous() {
            try {
                GraphicsNode graphicsNode = CompositeGraphicsNode.this.get(--this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor;
                return graphicsNode;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(GraphicsNode graphicsNode) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.set(this.lastRet, graphicsNode);
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(GraphicsNode graphicsNode) {
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.add(this.cursor++, graphicsNode);
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

