/**
 * @import {ElementContent, Element, Properties} from 'hast'
 * @import {ListItem, Parents} from 'mdast'
 * @import {State} from '../state.js'
 */
/**
 * Turn an mdast `listItem` node into hast.
 *
 * @param {State} state
 *   Info passed around.
 * @param {ListItem} node
 *   mdast node.
 * @param {Parents | undefined} parent
 *   Parent of `node`.
 * @returns {Element}
 *   hast node.
 */
export function listItem(state: State, node: ListItem, parent: Parents | undefined): Element;
import type { State } from '../state.js';
import type { ListItem } from 'mdast';
import type { Parents } from 'mdast';
import type { Element } from 'hast';
//# sourceMappingURL=list-item.d.ts.map