/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.util.JdomKt;
import java.awt.Color;
import java.beans.PropertyChangeSupport;
import org.intellij.images.options.DefaultImageEditorSettings;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.impl.JDOMExternalizerEx;
import org.jdom.Element;

final class TransparencyChessboardOptionsImpl
implements TransparencyChessboardOptions,
JDOMExternalizable {
    private int cellSize = 5;
    private Color whiteColor = DEFAULT_WHITE_COLOR;
    private Color blackColor = DEFAULT_BLACK_COLOR;
    private final PropertyChangeSupport propertyChangeSupport;

    TransparencyChessboardOptionsImpl(PropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport;
    }

    @Override
    public boolean isShowDefault() {
        return DefaultImageEditorSettings.INSTANCE.getShowChessboard();
    }

    @Override
    public int getCellSize() {
        return DefaultImageEditorSettings.INSTANCE.getChessboardCellSize();
    }

    @Override
    public Color getWhiteColor() {
        return this.whiteColor;
    }

    @Override
    public Color getBlackColor() {
        return this.blackColor;
    }

    void setShowDefault(boolean showDefault) {
    }

    void setCellSize(int cellSize) {
        int oldValue = this.cellSize;
        if (oldValue != cellSize) {
            this.cellSize = cellSize;
            this.propertyChangeSupport.firePropertyChange("Editor.TransparencyChessboard.cellSize", oldValue, this.cellSize);
        }
    }

    void setWhiteColor(Color whiteColor) {
        Color oldValue = this.whiteColor;
        if (whiteColor == null) {
            this.whiteColor = DEFAULT_WHITE_COLOR;
        }
        if (!oldValue.equals(whiteColor)) {
            this.whiteColor = whiteColor;
            this.propertyChangeSupport.firePropertyChange("Editor.TransparencyChessboard.whiteColor", oldValue, this.whiteColor);
        }
    }

    void setBlackColor(Color blackColor) {
        Color oldValue = this.blackColor;
        if (blackColor == null) {
            blackColor = DEFAULT_BLACK_COLOR;
        }
        if (!oldValue.equals(blackColor)) {
            this.blackColor = blackColor;
            this.propertyChangeSupport.firePropertyChange("Editor.TransparencyChessboard.blackColor", oldValue, this.blackColor);
        }
    }

    @Override
    public void inject(TransparencyChessboardOptions options) {
        this.setShowDefault(options.isShowDefault());
        this.setCellSize(options.getCellSize());
        this.setWhiteColor(options.getWhiteColor());
        this.setBlackColor(options.getBlackColor());
    }

    @Override
    public boolean setOption(String name, Object value) {
        if ("Editor.TransparencyChessboard.showDefault".equals(name)) {
            this.setShowDefault((Boolean)value);
        } else if ("Editor.TransparencyChessboard.cellSize".equals(name)) {
            this.setCellSize((Integer)value);
        } else if ("Editor.TransparencyChessboard.whiteColor".equals(name)) {
            this.setWhiteColor((Color)value);
        } else if ("Editor.TransparencyChessboard.blackColor".equals(name)) {
            this.setBlackColor((Color)value);
        } else {
            return false;
        }
        return true;
    }

    public void readExternal(Element element) {
        this.setShowDefault(JDOMExternalizer.readBoolean((Element)element, (String)"Editor.TransparencyChessboard.showDefault"));
        this.setCellSize(JDOMExternalizer.readInteger((Element)element, (String)"Editor.TransparencyChessboard.cellSize", (int)5));
        this.setWhiteColor(JDOMExternalizerEx.readColor(element, "Editor.TransparencyChessboard.whiteColor", DEFAULT_WHITE_COLOR));
        this.setBlackColor(JDOMExternalizerEx.readColor(element, "Editor.TransparencyChessboard.blackColor", DEFAULT_BLACK_COLOR));
    }

    public void writeExternal(Element element) {
        JdomKt.addOptionTag((Element)element, (String)"Editor.TransparencyChessboard.showDefault", (String)Boolean.toString(this.isShowDefault()), (String)"setting");
        JdomKt.addOptionTag((Element)element, (String)"Editor.TransparencyChessboard.cellSize", (String)Integer.toString(this.cellSize), (String)"setting");
        JDOMExternalizerEx.write(element, "Editor.TransparencyChessboard.whiteColor", this.whiteColor);
        JDOMExternalizerEx.write(element, "Editor.TransparencyChessboard.blackColor", this.blackColor);
    }
}

