/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.html.stream;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.html.Entities;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.Unsafe;
import kotlinx.html.org.w3c.dom.events.Event;
import kotlinx.html.stream.StreamKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0001*\u00060\u0002j\u0002`\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J,\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00150\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0016J\r\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ!\u0010(\u001a\u00020\u00152\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00150\u001e\u00a2\u0006\u0002\b+H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\b\u00100\u001a\u00020\u0015H\u0002J\b\u00101\u001a\u00020\u0015H\u0002R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00062"}, d2={"Lkotlinx/html/stream/HTMLStreamBuilder;", "O", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Lkotlinx/html/TagConsumer;", "out", "prettyPrint", "", "xhtmlCompatible", "<init>", "(Ljava/lang/Appendable;ZZ)V", "getOut", "()Ljava/lang/Appendable;", "Ljava/lang/Appendable;", "getPrettyPrint", "()Z", "getXhtmlCompatible", "level", "", "ln", "onTagStart", "", "tag", "Lkotlinx/html/Tag;", "onTagAttributeChange", "attribute", "", "value", "onTagEvent", "event", "Lkotlin/Function1;", "Lkotlinx/html/org/w3c/dom/events/Event;", "onTagEnd", "onTagContent", "content", "", "onTagContentEntity", "entity", "Lkotlinx/html/Entities;", "finalize", "onTagContentUnsafe", "block", "Lkotlinx/html/Unsafe;", "Lkotlin/ExtensionFunctionType;", "onTagComment", "UnsafeImpl", "getUnsafeImpl", "()Lkotlinx/html/Unsafe;", "appendln", "indent", "kotlinx-html"})
@SourceDebugExtension(value={"SMAP\nstream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stream.kt\nkotlinx/html/stream/HTMLStreamBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1872#2,3:236\n*S KotlinDebug\n*F\n+ 1 stream.kt\nkotlinx/html/stream/HTMLStreamBuilder\n*L\n31#1:236,3\n*E\n"})
public final class HTMLStreamBuilder<O extends Appendable>
implements TagConsumer<O> {
    @NotNull
    private final O out;
    private final boolean prettyPrint;
    private final boolean xhtmlCompatible;
    private int level;
    private boolean ln;
    @NotNull
    private final Unsafe UnsafeImpl;

    public HTMLStreamBuilder(@NotNull O out, boolean prettyPrint, boolean xhtmlCompatible) {
        Intrinsics.checkNotNullParameter(out, (String)"out");
        this.out = out;
        this.prettyPrint = prettyPrint;
        this.xhtmlCompatible = xhtmlCompatible;
        this.ln = true;
        this.UnsafeImpl = new Unsafe(this){
            final /* synthetic */ HTMLStreamBuilder<O> this$0;
            {
                this.this$0 = $receiver;
            }

            public void unaryPlus(String $this$unaryPlus) {
                Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
                this.this$0.getOut().append($this$unaryPlus);
            }

            public void unaryPlus(Entities $this$unaryPlus) {
                Unsafe.DefaultImpls.unaryPlus(this, $this$unaryPlus);
            }

            public void raw(String s2) {
                Unsafe.DefaultImpls.raw((Unsafe)this, s2);
            }

            public void raw(Entities entity) {
                Unsafe.DefaultImpls.raw((Unsafe)this, entity);
            }

            public void raw(Number n) {
                Unsafe.DefaultImpls.raw((Unsafe)this, n);
            }
        };
    }

    @NotNull
    public final O getOut() {
        return this.out;
    }

    public final boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public final boolean getXhtmlCompatible() {
        return this.xhtmlCompatible;
    }

    @Override
    public void onTagStart(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (this.prettyPrint && !tag.getInlineTag()) {
            this.indent();
        }
        int n = this.level;
        this.level = n + 1;
        this.out.append("<");
        this.out.append(tag.getTagName());
        if (tag.getNamespace() != null) {
            this.out.append(" xmlns=\"");
            this.out.append(tag.getNamespace());
            this.out.append("\"");
        }
        if (!tag.getAttributes().isEmpty()) {
            Iterable $this$forEachIndexed$iv = tag.getAttributesEntries();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map.Entry e = (Map.Entry)item$iv;
                boolean bl = false;
                if (!StreamKt.access$isValidXmlAttributeName((String)e.getKey())) {
                    throw new IllegalArgumentException("Tag " + tag.getTagName() + " has invalid attribute name " + (String)e.getKey());
                }
                this.out.append(' ');
                this.out.append((CharSequence)e.getKey());
                this.out.append("=\"");
                StreamKt.escapeAppend(this.out, (CharSequence)e.getValue());
                this.out.append('\"');
            }
        }
        if (this.xhtmlCompatible && tag.getEmptyTag()) {
            this.out.append("/");
        }
        this.out.append(">");
        this.ln = false;
    }

    @Override
    public void onTagAttributeChange(@NotNull Tag tag, @NotNull String attribute, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        throw new UnsupportedOperationException("tag attribute can't be changed as it was already written to the stream. Use with DelayedConsumer to be able to modify attributes");
    }

    @Override
    public void onTagEvent(@NotNull Tag tag, @NotNull String event, @NotNull Function1<? super Event, Unit> value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        throw new UnsupportedOperationException("you can't assign lambda event handler when building text");
    }

    @Override
    public void onTagEnd(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        int n = this.level;
        this.level = n + -1;
        if (this.ln) {
            this.indent();
        }
        if (!tag.getEmptyTag()) {
            this.out.append("</");
            this.out.append(tag.getTagName());
            this.out.append(">");
        }
        if (this.prettyPrint && !tag.getInlineTag()) {
            this.appendln();
        }
    }

    @Override
    public void onTagContent(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StreamKt.escapeAppend(this.out, content);
        this.ln = false;
    }

    @Override
    public void onTagContentEntity(@NotNull Entities entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        this.out.append(entity.getText());
        this.ln = false;
    }

    @Override
    @NotNull
    public O finalize() {
        return this.out;
    }

    @Override
    public void onTagContentUnsafe(@NotNull Function1<? super Unsafe, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        block.invoke((Object)this.UnsafeImpl);
    }

    @Override
    public void onTagComment(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.prettyPrint) {
            this.indent();
        }
        this.out.append("<!--");
        StreamKt.access$escapeComment(this.out, content);
        this.out.append("-->");
        this.ln = false;
    }

    @NotNull
    public final Unsafe getUnsafeImpl() {
        return this.UnsafeImpl;
    }

    private final void appendln() {
        if (this.prettyPrint && !this.ln) {
            this.out.append("\n");
            this.ln = true;
        }
    }

    private final void indent() {
        if (this.prettyPrint) {
            int remaining;
            if (!this.ln) {
                this.out.append("\n");
            }
            for (remaining = this.level; remaining >= 4; remaining -= 4) {
                this.out.append("        ");
            }
            while (remaining >= 2) {
                this.out.append("    ");
                remaining -= 2;
            }
            if (remaining > 0) {
                this.out.append("  ");
            }
            this.ln = false;
        }
    }
}

