/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import generic.lsh.vector.LSHVector;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.SignatureRecord;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class IdHistogram
implements Comparable<IdHistogram> {
    public long id;
    public int count;
    public LSHVector vec = null;

    @Override
    public int compareTo(IdHistogram o) {
        return Long.compare(this.id, o.id);
    }

    public static TreeSet<IdHistogram> buildVectorIdHistogram(Iterator<FunctionDescription> iter) {
        TreeSet<IdHistogram> table = new TreeSet<IdHistogram>();
        IdHistogram testItem = new IdHistogram();
        while (iter.hasNext()) {
            testItem.id = iter.next().getVectorId();
            if (testItem.id == 0L) continue;
            IdHistogram cur = table.floor(testItem);
            if (cur == null || cur.id != testItem.id) {
                cur = new IdHistogram();
                cur.id = testItem.id;
                cur.count = 1;
                table.add(cur);
                continue;
            }
            ++cur.count;
        }
        return table;
    }

    public static Set<IdHistogram> collectVectors(DescriptionManager manage, Iterator<FunctionDescription> iter) {
        TreeSet<IdHistogram> res = new TreeSet<IdHistogram>();
        IdHistogram workingRec = new IdHistogram();
        while (iter.hasNext()) {
            FunctionDescription desc = iter.next();
            SignatureRecord sigrec = desc.getSignatureRecord();
            if (sigrec == null) continue;
            long key = sigrec.getLSHVector().calcUniqueHash();
            manage.setSignatureId(sigrec, key);
            workingRec.id = key;
            IdHistogram prevRec = res.floor(workingRec);
            if (prevRec == null || prevRec.id != key) {
                prevRec = new IdHistogram();
                prevRec.id = key;
                prevRec.vec = sigrec.getLSHVector();
                prevRec.count = 1;
                res.add(prevRec);
                continue;
            }
            ++prevRec.count;
        }
        return res;
    }
}

