/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.list;

import docking.widgets.AutoLookup;
import docking.widgets.GComponent;
import docking.widgets.list.GListAutoLookup;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.text.Position;

public class GList<T>
extends JList<T>
implements GComponent {
    private AutoLookup autoLookup = this.createAutoLookup();

    public GList() {
        this.init();
    }

    public GList(T[] listData) {
        super(listData);
        this.init();
    }

    public GList(Vector<T> listData) {
        super(listData);
        this.init();
    }

    public GList(ListModel<T> dataModel) {
        super(dataModel);
        this.init();
    }

    private void init() {
        this.setHTMLRenderingEnabled(false);
        if (this.getCellRenderer() instanceof JComponent) {
            GComponent.setHTMLRenderingFlag((JComponent)((Object)this.getCellRenderer()), false);
        }
        this.addListSelectionListener(e -> this.ensureIndexIsVisible(this.getSelectedIndex()));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                GList.this.autoLookup.keyTyped(e);
            }
        });
    }

    public void setAutoLookupTimeout(long timeout) {
        this.autoLookup.setTimeout(timeout);
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    protected AutoLookup createAutoLookup() {
        return new GListAutoLookup(this);
    }
}

