/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import ghidra.framework.preferences.Preferences;
import ghidra.net.PKIUtils;
import ghidra.util.Msg;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class DefaultTrustManagerFactory {
    public static final String GHIDRA_CACERTS_PATH_PROPERTY = "ghidra.cacerts";
    private static final X509Certificate[] NO_CERTS = new X509Certificate[0];
    private static final WrappedTrustManager wrappedTrustManager = new WrappedTrustManager();

    private DefaultTrustManagerFactory() {
    }

    private static void init() {
        String cacertsPath = System.getProperty(GHIDRA_CACERTS_PATH_PROPERTY);
        if (!(cacertsPath != null && cacertsPath.length() != 0 || (cacertsPath = Preferences.getProperty(GHIDRA_CACERTS_PATH_PROPERTY)) != null && cacertsPath.length() != 0)) {
            Msg.info(DefaultTrustManagerFactory.class, (Object)"Trust manager disabled, cacerts have not been set");
            wrappedTrustManager.setTrustManager(new OpenTrustManager());
            return;
        }
        try {
            TrustManager[] trustManagers;
            Msg.info(DefaultTrustManagerFactory.class, (Object)("Trust manager initializing with cacerts: " + cacertsPath));
            KeyStore keyStore = PKIUtils.loadCertificateStore(cacertsPath);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            X509TrustManager x509TrustMgr = null;
            for (TrustManager trustMgr : trustManagers = tmf.getTrustManagers()) {
                if (!(trustMgr instanceof X509TrustManager)) continue;
                x509TrustMgr = (X509TrustManager)trustMgr;
                wrappedTrustManager.setTrustManager(x509TrustMgr);
                PKIUtils.logCerts(x509TrustMgr.getAcceptedIssuers());
                break;
            }
            if (x509TrustMgr == null) {
                throw new CertificateException("Failed to load any X509 certificates");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            wrappedTrustManager.setTrustManagerError(e);
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.error(DefaultTrustManagerFactory.class, (Object)("Failed to process cacerts (" + cacertsPath + "): " + msg), (Throwable)e);
        }
    }

    public static synchronized TrustManager[] getTrustManagers() {
        if (DefaultTrustManagerFactory.wrappedTrustManager.trustManager == null) {
            DefaultTrustManagerFactory.init();
        }
        return new TrustManager[]{wrappedTrustManager};
    }

    static synchronized void invalidateTrustManagers() {
        wrappedTrustManager.invalidate();
    }

    public static X500Principal[] getTrustedIssuers() throws CertificateException {
        return wrappedTrustManager.getTrustedIssuers();
    }

    public static void validateClient(X509Certificate[] certChain, String authType) throws CertificateException {
        wrappedTrustManager.checkClientTrusted(certChain, authType);
    }

    private static class WrappedTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;
        private Exception caError;

        WrappedTrustManager() {
            this.invalidate();
        }

        void invalidate() {
            this.trustManager = null;
            this.caError = null;
        }

        synchronized void setTrustManager(X509TrustManager trustManager) {
            this.trustManager = trustManager;
            this.caError = null;
        }

        synchronized void setTrustManagerError(Exception caError) {
            this.trustManager = null;
            this.caError = caError;
        }

        @Override
        public synchronized void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrustManager();
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public synchronized void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrustManager();
            this.trustManager.checkServerTrusted(chain, authType);
        }

        @Override
        public synchronized X509Certificate[] getAcceptedIssuers() {
            if (this.trustManager == null) {
                return NO_CERTS;
            }
            return this.trustManager.getAcceptedIssuers();
        }

        synchronized X500Principal[] getTrustedIssuers() throws CertificateException {
            WrappedTrustManager trustMgr = wrappedTrustManager;
            trustMgr.checkTrustManager();
            X509Certificate[] acceptedIssuers = trustMgr.getAcceptedIssuers();
            if (acceptedIssuers == null || acceptedIssuers.length == 0) {
                return null;
            }
            HashSet<X500Principal> set = new HashSet<X500Principal>();
            for (X509Certificate trustedCert : acceptedIssuers) {
                set.add(trustedCert.getSubjectX500Principal());
            }
            X500Principal[] principals = new X500Principal[set.size()];
            return set.toArray(principals);
        }

        private void checkTrustManager() throws CertificateException {
            if (this.trustManager != null) {
                return;
            }
            if (this.caError != null) {
                throw new CertificateException("Failed to load CA certs", this.caError);
            }
            throw new CertificateException("Trust manager not properly initialized");
        }
    }

    private static class OpenTrustManager
    implements X509TrustManager {
        private OpenTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return NO_CERTS;
        }
    }
}

