/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import generic.Span;
import generic.ULongSpan;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeArithmetic;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.memory.TraceMemoryState;
import java.util.List;
import java.util.Map;

public class TraceMemoryStatePcodeExecutorStatePiece
extends AbstractLongOffsetPcodeExecutorStatePiece<byte[], TraceMemoryState, AddressSpace> {
    protected final ULongSpan.MutableULongSpanMap<TraceMemoryState> unique;
    protected final PcodeTraceDataAccess data;

    protected TraceMemoryStatePcodeExecutorStatePiece(PcodeTraceDataAccess data, ULongSpan.MutableULongSpanMap<TraceMemoryState> unique) {
        super(data.getLanguage(), (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)data.getLanguage()), (PcodeArithmetic)TraceMemoryStatePcodeArithmetic.INSTANCE, PcodeStateCallbacks.NONE);
        this.data = data;
        this.unique = unique;
    }

    public TraceMemoryStatePcodeExecutorStatePiece(PcodeTraceDataAccess data) {
        this(data, (ULongSpan.MutableULongSpanMap<TraceMemoryState>)new ULongSpan.DefaultULongSpanMap());
    }

    protected TraceMemoryState checkSize(int size, TraceMemoryState val) {
        return val;
    }

    public TraceMemoryStatePcodeExecutorStatePiece fork(PcodeStateCallbacks cb) {
        ULongSpan.DefaultULongSpanMap copyUnique = new ULongSpan.DefaultULongSpanMap();
        copyUnique.putAll(this.unique);
        return new TraceMemoryStatePcodeExecutorStatePiece(this.data, (ULongSpan.MutableULongSpanMap<TraceMemoryState>)copyUnique);
    }

    protected AddressRange range(AddressSpace space, long offset, int size) {
        try {
            return new AddressRangeImpl(space.getAddress(offset), (long)size);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void setUnique(long offset, int size, TraceMemoryState val, PcodeStateCallbacks cb) {
        this.unique.put((Span)ULongSpan.extent((long)offset, (int)size), (Object)val);
    }

    protected TraceMemoryState getUnique(long offset, int size, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        ULongSpan.DefaultULongSpanSet remains = new ULongSpan.DefaultULongSpanSet();
        ULongSpan span = ULongSpan.extent((long)offset, (int)size);
        remains.add((Span)span);
        for (Map.Entry ent : this.unique.intersectingEntries((Span)span)) {
            if (ent.getValue() != TraceMemoryState.KNOWN) {
                return TraceMemoryState.UNKNOWN;
            }
            remains.remove((Span)((ULongSpan)ent.getKey()));
        }
        return remains.isEmpty() ? TraceMemoryState.KNOWN : TraceMemoryState.UNKNOWN;
    }

    protected AddressSpace getForSpace(AddressSpace space, boolean toWrite) {
        return space;
    }

    protected void setInSpace(AddressSpace space, long offset, int size, TraceMemoryState val, PcodeStateCallbacks cb) {
        this.data.setState(this.range(space, offset, size), val);
    }

    protected TraceMemoryState getFromSpace(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        return this.data.getViewportState(this.range(space, offset, size));
    }

    protected TraceMemoryState getFromNullSpace(int size, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        return TraceMemoryState.UNKNOWN;
    }

    protected Map<Register, TraceMemoryState> getRegisterValuesFromSpace(AddressSpace s, List<Register> registers) {
        return Map.of();
    }

    public Map<Register, TraceMemoryState> getRegisterValues() {
        return Map.of();
    }

    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make TraceMemoryState into a concrete buffer", purpose);
    }

    public void clear() {
        this.unique.clear();
    }
}

