/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.omf51;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.omf51.Omf51Library;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordFactory;
import ghidra.file.formats.omf51.Omf51ArchiveFileSystemFactory;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

@FileSystemInfo(type="omf51", description="OMF51 Library", factory=Omf51ArchiveFileSystemFactory.class)
public class Omf51ArchiveFileSystem
extends AbstractFileSystem<Omf51Library.MemberHeader> {
    private ByteProvider provider;

    public Omf51ArchiveFileSystem(FSRLRoot fsFSRL, ByteProvider provider) {
        super(fsFSRL, FileSystemService.getInstance());
        this.provider = provider;
    }

    public void mount(TaskMonitor monitor) throws IOException, OmfException, CancelledException {
        monitor.setMessage("Opening OMF51 library...");
        Omf51RecordFactory factory = new Omf51RecordFactory(this.provider);
        List members = new Omf51Library(factory).getMembers();
        monitor.initialize((long)members.size(), "Opening OMF51 library...");
        for (Omf51Library.MemberHeader member : members) {
            monitor.increment();
            this.fsIndex.storeFile(member.name(), (long)this.fsIndex.getFileCount(), false, member.size(), (Object)member);
        }
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        this.fsIndex.clear();
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) {
        Omf51Library.MemberHeader member = (Omf51Library.MemberHeader)this.fsIndex.getMetadata(file);
        return member != null ? new ByteProviderWrapper(this.provider, member.offset(), member.size(), file.getFSRL()) : null;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileAttributes result = new FileAttributes();
        Omf51Library.MemberHeader entry = (Omf51Library.MemberHeader)this.fsIndex.getMetadata(file);
        if (entry != null) {
            result.add(FileAttributeType.NAME_ATTR, (Object)entry.name());
            result.add(FileAttributeType.SIZE_ATTR, (Object)entry.size());
        }
        return result;
    }
}

