/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class KdDebuggerData
implements StructConverter {
    public static final String NAME = "_KD_DEBUGGER_DATA";
    private long List_Flink;
    private long List_Blink;
    private int OwnerTag;
    private int Size;
    private long KernBase;
    private long BreakpointWithStatus;
    private long SavedContext;
    private short ThCallbackStack;
    private short NextCallback;
    private short FramePointer;
    private short Flags;
    private long KiCallUserMode;
    private long KeUserCallbackDispatcher;
    private long PsLoadedModuleList;
    private long PsActiveProcessHead;
    private long PspCidTable;
    private long ExpSystemResourcesList;
    private long ExpPagedPoolDescriptor;
    private long ExpNumberOfPagedPools;
    private long KeTimeIncrement;
    private long KeBugCheckCallbackListHead;
    private long KiBugcheckData;
    private long IopErrorLogListHead;
    private long ObpRootDirectoryObject;
    private long ObpTypeObjectType;
    private long MmSystemCacheStart;
    private long MmSystemCacheEnd;
    private long MmSystemCacheWs;
    private long MmPfnDatabase;
    private long MmSystemPtesStart;
    private long MmSystemPtesEnd;
    private long MmSubsectionBase;
    private long MmNumberOfPagingFiles;
    private long MmLowestPhysicalPage;
    private long MmHighestPhysicalPage;
    private long MmNumberOfPhysicalPages;
    private long MmMaximumNonPagedPoolInBytes;
    private long MmNonPagedSystemStart;
    private long MmNonPagedPoolStart;
    private long MmNonPagedPoolEnd;
    private long MmPagedPoolStart;
    private long MmPagedPoolEnd;
    private long MmPagedPoolInformation;
    private long MmPageSize;
    private long MmSizeOfPagedPoolInBytes;
    private long MmTotalCommitLimit;
    private long MmTotalCommittedPages;
    private long MmSharedCommit;
    private long MmDriverCommit;
    private long MmProcessCommit;
    private long MmPagedPoolCommit;
    private long MmExtendedCommit;
    private long MmZeroedPageListHead;
    private long MmFreePageListHead;
    private long MmStandbyPageListHead;
    private long MmModifiedPageListHead;
    private long MmModifiedNoWritePageListHead;
    private long MmAvailablePages;
    private long MmResidentAvailablePages;
    private long PoolTrackTable;
    private long NonPagedPoolDescriptor;
    private long MmHighestUserAddress;
    private long MmSystemRangeStart;
    private long MmUserProbeAddress;
    private long KdPrintCircularBuffer;
    private long KdPrintCircularBufferEnd;
    private long KdPrintWritePointer;
    private long KdPrintRolloverCount;
    private long MmLoadedUserImageList;
    private long NtBuildLab;
    private long KiNormalSystemCall;
    private long KiProcessorBlock;
    private long MmUnloadedDrivers;
    private long MmLastUnloadedDriver;
    private long MmTriageActionTaken;
    private long MmSpecialPoolTag;
    private long KernelVerifier;
    private long MmVerifierData;
    private long MmAllocatedNonPagedPool;
    private long MmPeakCommitment;
    private long MmTotalCommitLimitMaximum;
    private long CmNtCSDVersion;
    private long MmPhysicalMemoryBlock;
    private long MmSessionBase;
    private long MmSessionSize;
    private long MmSystemParentTablePage;
    private long MmVirtualTranslationBase;
    private short OffsetKThreadNextProcessor;
    private short OffsetKThreadTeb;
    private short OffsetKThreadKernelStack;
    private short OffsetKThreadInitialStack;
    private short OffsetKThreadApcProcess;
    private short OffsetKThreadState;
    private short OffsetKThreadBStore;
    private short OffsetKThreadBStoreLimit;
    private short SizeEProcess;
    private short OffsetEprocessPeb;
    private short OffsetEprocessParentCID;
    private short OffsetEprocessDirectoryTableBase;
    private short SizePrcb;
    private short OffsetPrcbDpcRoutine;
    private short OffsetPrcbCurrentThread;
    private short OffsetPrcbMhz;
    private short OffsetPrcbCpuType;
    private short OffsetPrcbVendorString;
    private short OffsetPrcbProcStateContext;
    private short OffsetPrcbNumber;
    private short SizeEThread;
    private byte L1tfHighPhysicalBitIndex;
    private byte L1tfSwizzleBitIndex;
    private int Padding0;
    private long KdPrintCircularBufferPtr;
    private long KdPrintBufferSize;
    private long KeLoaderBlock;
    private short SizePcr;
    private short OffsetPcrSelfPcr;
    private short OffsetPcrCurrentPrcb;
    private short OffsetPcrContainedPrcb;
    private short OffsetPcrInitialBStore;
    private short OffsetPcrBStoreLimit;
    private short OffsetPcrInitialStack;
    private short OffsetPcrStackLimit;
    private short OffsetPrcbPcrPage;
    private short OffsetPrcbProcStateSpecialReg;
    private short GdtR0Code;
    private short GdtR0Data;
    private short GdtR0Pcr;
    private short GdtR3Code;
    private short GdtR3Data;
    private short GdtR3Teb;
    private short GdtLdt;
    private short GdtTss;
    private short Gdt64R3CmCode;
    private short Gdt64R3CmTeb;
    private long IopNumTriageDumpDataBlocks;
    private long IopTriageDumpDataBlocks;
    private long VfCrashDataBlock;
    private long MmBadPagesDetected;
    private long MmZeroedPageSingleBitErrorsDetected;
    private long EtwpDebuggerData;
    private short OffsetPrcbContext;
    private short OffsetPrcbMaxBreakpoints;
    private short OffsetPrcbMaxWatchpoints;
    private int OffsetKThreadStackLimit;
    private int OffsetKThreadStackBase;
    private int OffsetKThreadQueueListEntry;
    private int OffsetEThreadIrpList;
    private short OffsetPrcbIdleThread;
    private short OffsetPrcbNormalDpcState;
    private short OffsetPrcbDpcStack;
    private short OffsetPrcbIsrStack;
    private short SizeKDPC_STACK_FRAME;
    private short OffsetKPriQueueThreadListHead;
    private short OffsetKThreadWaitReason;
    private short Padding1;
    private long PteBase;
    private long RetpolineStubFunctionTable;
    private int RetpolineStubFunctionTableSize;
    private int RetpolineStubOffset;
    private int RetpolineStubSize;
    private short OffsetEProcessMmHotPatchContext;
    private DumpFileReader reader;
    private long index;
    private int psz;
    private boolean is32Bit;

    KdDebuggerData(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.is32Bit = this.psz == 4;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setList_Flink(this.reader.readNextPointer());
        this.setList_Blink(this.reader.readNextPointer());
        this.setOwnerTag(this.reader.readNextInt());
        this.setSize(this.reader.readNextInt());
        this.setKernBase(this.reader.readNextPointer());
        this.setBreakpointWithStatus(this.reader.readNextPointer());
        this.setSavedContext(this.reader.readNextPointer());
        this.setThCallbackStack(this.reader.readNextShort());
        this.setNextCallback(this.reader.readNextShort());
        this.setFramePointer(this.reader.readNextShort());
        this.setFlags(this.reader.readNextShort());
        this.setKiCallUserMode(this.reader.readNextPointer());
        this.setKeUserCallbackDispatcher(this.reader.readNextPointer());
        this.setPsLoadedModuleList(this.reader.readNextPointer());
        this.setPsActiveProcessHead(this.reader.readNextPointer());
        this.setPspCidTable(this.reader.readNextPointer());
        this.setExpSystemResourcesList(this.reader.readNextPointer());
        this.setExpPagedPoolDescriptor(this.reader.readNextPointer());
        this.setExpNumberOfPagedPools(this.reader.readNextPointer());
        this.setKeTimeIncrement(this.reader.readNextPointer());
        this.setKeBugCheckCallbackListHead(this.reader.readNextPointer());
        this.setKiBugcheckData(this.reader.readNextPointer());
        this.setIopErrorLogListHead(this.reader.readNextPointer());
        this.setObpRootDirectoryObject(this.reader.readNextPointer());
        this.setObpTypeObjectType(this.reader.readNextPointer());
        this.setMmSystemCacheStart(this.reader.readNextPointer());
        this.setMmSystemCacheEnd(this.reader.readNextPointer());
        this.setMmSystemCacheWs(this.reader.readNextPointer());
        this.setMmPfnDatabase(this.reader.readNextPointer());
        this.setMmSystemPtesStart(this.reader.readNextPointer());
        this.setMmSystemPtesEnd(this.reader.readNextPointer());
        this.setMmSubsectionBase(this.reader.readNextPointer());
        this.setMmNumberOfPagingFiles(this.reader.readNextPointer());
        this.setMmLowestPhysicalPage(this.reader.readNextPointer());
        this.setMmHighestPhysicalPage(this.reader.readNextPointer());
        this.setMmNumberOfPhysicalPages(this.reader.readNextPointer());
        this.setMmMaximumNonPagedPoolInBytes(this.reader.readNextPointer());
        this.setMmNonPagedSystemStart(this.reader.readNextPointer());
        this.setMmNonPagedPoolStart(this.reader.readNextPointer());
        this.setMmNonPagedPoolEnd(this.reader.readNextPointer());
        this.setMmPagedPoolStart(this.reader.readNextPointer());
        this.setMmPagedPoolEnd(this.reader.readNextPointer());
        this.setMmPagedPoolInformation(this.reader.readNextPointer());
        this.setMmPageSize(this.reader.readNextPointer());
        this.setMmSizeOfPagedPoolInBytes(this.reader.readNextPointer());
        this.setMmTotalCommitLimit(this.reader.readNextPointer());
        this.setMmTotalCommittedPages(this.reader.readNextPointer());
        this.setMmSharedCommit(this.reader.readNextPointer());
        this.setMmDriverCommit(this.reader.readNextPointer());
        this.setMmProcessCommit(this.reader.readNextPointer());
        this.setMmPagedPoolCommit(this.reader.readNextPointer());
        this.setMmExtendedCommit(this.reader.readNextPointer());
        this.setMmZeroedPageListHead(this.reader.readNextPointer());
        this.setMmFreePageListHead(this.reader.readNextPointer());
        this.setMmStandbyPageListHead(this.reader.readNextPointer());
        this.setMmModifiedPageListHead(this.reader.readNextPointer());
        this.setMmModifiedNoWritePageListHead(this.reader.readNextPointer());
        this.setMmAvailablePages(this.reader.readNextPointer());
        this.setMmResidentAvailablePages(this.reader.readNextPointer());
        this.setPoolTrackTable(this.reader.readNextPointer());
        this.setNonPagedPoolDescriptor(this.reader.readNextPointer());
        this.setMmHighestUserAddress(this.reader.readNextPointer());
        this.setMmSystemRangeStart(this.reader.readNextPointer());
        this.setMmUserProbeAddress(this.reader.readNextPointer());
        this.setKdPrintCircularBuffer(this.reader.readNextPointer());
        this.setKdPrintCircularBufferEnd(this.reader.readNextPointer());
        this.setKdPrintWritePointer(this.reader.readNextPointer());
        this.setKdPrintRolloverCount(this.reader.readNextPointer());
        this.setMmLoadedUserImageList(this.reader.readNextPointer());
        if (this.is32Bit) {
            return;
        }
        this.setNtBuildLab(this.reader.readNextPointer());
        this.setKiNormalSystemCall(this.reader.readNextPointer());
        this.setKiProcessorBlock(this.reader.readNextPointer());
        this.setMmUnloadedDrivers(this.reader.readNextPointer());
        this.setMmLastUnloadedDriver(this.reader.readNextPointer());
        this.setMmTriageActionTaken(this.reader.readNextPointer());
        this.setMmSpecialPoolTag(this.reader.readNextPointer());
        this.setKernelVerifier(this.reader.readNextPointer());
        this.setMmVerifierData(this.reader.readNextPointer());
        this.setMmAllocatedNonPagedPool(this.reader.readNextPointer());
        this.setMmPeakCommitment(this.reader.readNextPointer());
        this.setMmTotalCommitLimitMaximum(this.reader.readNextPointer());
        this.setCmNtCSDVersion(this.reader.readNextPointer());
        this.setMmPhysicalMemoryBlock(this.reader.readNextPointer());
        this.setMmSessionBase(this.reader.readNextPointer());
        this.setMmSessionSize(this.reader.readNextPointer());
        this.setMmSystemParentTablePage(this.reader.readNextPointer());
        this.setMmVirtualTranslationBase(this.reader.readNextPointer());
        this.setOffsetKThreadNextProcessor(this.reader.readNextShort());
        this.setOffsetKThreadTeb(this.reader.readNextShort());
        this.setOffsetKThreadKernelStack(this.reader.readNextShort());
        this.setOffsetKThreadInitialStack(this.reader.readNextShort());
        this.setOffsetKThreadApcProcess(this.reader.readNextShort());
        this.setOffsetKThreadState(this.reader.readNextShort());
        this.setOffsetKThreadBStore(this.reader.readNextShort());
        this.setOffsetKThreadBStoreLimit(this.reader.readNextShort());
        this.setSizeEProcess(this.reader.readNextShort());
        this.setOffsetEprocessPeb(this.reader.readNextShort());
        this.setOffsetEprocessParentCID(this.reader.readNextShort());
        this.setOffsetEprocessDirectoryTableBase(this.reader.readNextShort());
        this.setSizePrcb(this.reader.readNextShort());
        this.setOffsetPrcbDpcRoutine(this.reader.readNextShort());
        this.setOffsetPrcbCurrentThread(this.reader.readNextShort());
        this.setOffsetPrcbMhz(this.reader.readNextShort());
        this.setOffsetPrcbCpuType(this.reader.readNextShort());
        this.setOffsetPrcbVendorString(this.reader.readNextShort());
        this.setOffsetPrcbProcStateContext(this.reader.readNextShort());
        this.setOffsetPrcbNumber(this.reader.readNextShort());
        this.setSizeEThread(this.reader.readNextShort());
        this.setL1tfHighPhysicalBitIndex(this.reader.readNextByte());
        this.setL1tfSwizzleBitIndex(this.reader.readNextByte());
        this.setPadding0(this.reader.readNextInt());
        this.setKdPrintCircularBufferPtr(this.reader.readNextPointer());
        this.setKdPrintBufferSize(this.reader.readNextPointer());
        this.setKeLoaderBlock(this.reader.readNextPointer());
        this.setSizePcr(this.reader.readNextShort());
        this.setOffsetPcrSelfPcr(this.reader.readNextShort());
        this.setOffsetPcrCurrentPrcb(this.reader.readNextShort());
        this.setOffsetPcrContainedPrcb(this.reader.readNextShort());
        this.setOffsetPcrInitialBStore(this.reader.readNextShort());
        this.setOffsetPcrBStoreLimit(this.reader.readNextShort());
        this.setOffsetPcrInitialStack(this.reader.readNextShort());
        this.setOffsetPcrStackLimit(this.reader.readNextShort());
        this.setOffsetPrcbPcrPage(this.reader.readNextShort());
        this.setOffsetPrcbProcStateSpecialReg(this.reader.readNextShort());
        this.setGdtR0Code(this.reader.readNextShort());
        this.setGdtR0Data(this.reader.readNextShort());
        this.setGdtR0Pcr(this.reader.readNextShort());
        this.setGdtR3Code(this.reader.readNextShort());
        this.setGdtR3Data(this.reader.readNextShort());
        this.setGdtR3Teb(this.reader.readNextShort());
        this.setGdtLdt(this.reader.readNextShort());
        this.setGdtTss(this.reader.readNextShort());
        this.setGdt64R3CmCode(this.reader.readNextShort());
        this.setGdt64R3CmTeb(this.reader.readNextShort());
        this.setIopNumTriageDumpDataBlocks(this.reader.readNextPointer());
        this.setIopTriageDumpDataBlocks(this.reader.readNextPointer());
        this.setVfCrashDataBlock(this.reader.readNextPointer());
        this.setMmBadPagesDetected(this.reader.readNextPointer());
        this.setMmZeroedPageSingleBitErrorsDetected(this.reader.readNextPointer());
        this.setEtwpDebuggerData(this.reader.readNextPointer());
        this.setOffsetPrcbContext(this.reader.readNextShort());
        this.setOffsetPrcbMaxBreakpoints(this.reader.readNextShort());
        this.setOffsetPrcbMaxWatchpoints(this.reader.readNextShort());
        this.setOffsetKThreadStackLimit(this.reader.readNextInt());
        this.setOffsetKThreadStackBase(this.reader.readNextInt());
        this.setOffsetKThreadQueueListEntry(this.reader.readNextInt());
        this.setOffsetEThreadIrpList(this.reader.readNextInt());
        this.setOffsetPrcbIdleThread(this.reader.readNextShort());
        this.setOffsetPrcbNormalDpcState(this.reader.readNextShort());
        this.setOffsetPrcbDpcStack(this.reader.readNextShort());
        this.setOffsetPrcbIsrStack(this.reader.readNextShort());
        this.setSizeKDPC_STACK_FRAME(this.reader.readNextShort());
        this.setOffsetKPriQueueThreadListHead(this.reader.readNextShort());
        this.setOffsetKThreadWaitReason(this.reader.readNextShort());
        this.setPadding1(this.reader.readNextShort());
        this.setPteBase(this.reader.readNextPointer());
        this.setRetpolineStubFunctionTable(this.reader.readNextPointer());
        this.setRetpolineStubFunctionTableSize(this.reader.readNextInt());
        this.setRetpolineStubOffset(this.reader.readNextInt());
        this.setRetpolineStubSize(this.reader.readNextInt());
        this.setOffsetEProcessMmHotPatchContext(this.reader.readNextShort());
    }

    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "List.Flink", null);
        struct.add(QWORD, 8, "List.Blink", null);
        struct.add(STRING, 4, "OwnerTag", null);
        struct.add(DWORD, 4, "Size", null);
        struct.add(QWORD, 8, "KernBase", null);
        struct.add(QWORD, 8, "BreakpointWithStatus", null);
        struct.add(QWORD, 8, "SavedContext", null);
        struct.add(WORD, 2, "ThCallbackStack", null);
        struct.add(WORD, 2, "NextCallback", null);
        struct.add(WORD, 2, "FramePointer", null);
        struct.add(WORD, 2, "Flags", null);
        struct.add(POINTER, this.psz, "KiCallUserMode", null);
        struct.add(POINTER, this.psz, "KeUserCallbackDispatcher", null);
        struct.add(POINTER, this.psz, "PsLoadedModuleList", null);
        struct.add(POINTER, this.psz, "PsActiveProcessHead", null);
        struct.add(POINTER, this.psz, "PspCidTable", null);
        struct.add(POINTER, this.psz, "ExpSystemResourcesList", null);
        struct.add(POINTER, this.psz, "ExpPagedPoolDescriptor", null);
        struct.add(POINTER, this.psz, "ExpNumberOfPagedPools", null);
        struct.add(POINTER, this.psz, "KeTimeIncrement", null);
        struct.add(POINTER, this.psz, "KeBugCheckCallbackListHead", null);
        struct.add(POINTER, this.psz, "KiBugcheckData", null);
        struct.add(POINTER, this.psz, "IopErrorLogListHead", null);
        struct.add(POINTER, this.psz, "ObpRootDirectoryObject", null);
        struct.add(POINTER, this.psz, "ObpTypeObjectType", null);
        struct.add(POINTER, this.psz, "MmSystemCacheStart", null);
        struct.add(POINTER, this.psz, "MmSystemCacheEnd", null);
        struct.add(POINTER, this.psz, "MmSystemCacheWs", null);
        struct.add(POINTER, this.psz, "MmPfnDatabase", null);
        struct.add(POINTER, this.psz, "MmSystemPtesStart", null);
        struct.add(POINTER, this.psz, "MmSystemPtesEnd", null);
        struct.add(POINTER, this.psz, "MmSubsectionBase", null);
        struct.add(POINTER, this.psz, "MmNumberOfPagingFiles", null);
        struct.add(POINTER, this.psz, "MmLowestPhysicalPage", null);
        struct.add(POINTER, this.psz, "MmHighestPhysicalPage", null);
        struct.add(POINTER, this.psz, "MmNumberOfPhysicalPages", null);
        struct.add(POINTER, this.psz, "MmMaximumNonPagedPoolInBytes", null);
        struct.add(POINTER, this.psz, "MmNonPagedSystemStart", null);
        struct.add(POINTER, this.psz, "MmNonPagedPoolStart", null);
        struct.add(POINTER, this.psz, "MmNonPagedPoolEnd", null);
        struct.add(POINTER, this.psz, "MmPagedPoolStart", null);
        struct.add(POINTER, this.psz, "MmPagedPoolEnd", null);
        struct.add(POINTER, this.psz, "MmPagedPoolInformation", null);
        struct.add(QWORD, this.psz, "MmPageSize", null);
        struct.add(POINTER, this.psz, "MmSizeOfPagedPoolInBytes", null);
        struct.add(POINTER, this.psz, "MmTotalCommitLimit", null);
        struct.add(POINTER, this.psz, "MmTotalCommittedPages", null);
        struct.add(POINTER, this.psz, "MmSharedCommit", null);
        struct.add(POINTER, this.psz, "MmDriverCommit", null);
        struct.add(POINTER, this.psz, "MmProcessCommit", null);
        struct.add(POINTER, this.psz, "MmPagedPoolCommit", null);
        struct.add(POINTER, this.psz, "MmExtendedCommit", null);
        struct.add(POINTER, this.psz, "MmZeroedPageListHead", null);
        struct.add(POINTER, this.psz, "MmFreePageListHead", null);
        struct.add(POINTER, this.psz, "MmStandbyPageListHead", null);
        struct.add(POINTER, this.psz, "MmModifiedPageListHead", null);
        struct.add(POINTER, this.psz, "MmModifiedNoWritePageListHead", null);
        struct.add(POINTER, this.psz, "MmAvailablePages", null);
        struct.add(POINTER, this.psz, "MmResidentAvailablePages", null);
        struct.add(POINTER, this.psz, "PoolTrackTable", null);
        struct.add(POINTER, this.psz, "NonPagedPoolDescriptor", null);
        struct.add(POINTER, this.psz, "MmHighestUserAddress", null);
        struct.add(POINTER, this.psz, "MmSystemRangeStart", null);
        struct.add(POINTER, this.psz, "MmUserProbeAddress", null);
        struct.add(POINTER, this.psz, "KdPrintCircularBuffer", null);
        struct.add(POINTER, this.psz, "KdPrintCircularBufferEnd", null);
        struct.add(POINTER, this.psz, "KdPrintWritePointer", null);
        struct.add(POINTER, this.psz, "KdPrintRolloverCount", null);
        struct.add(POINTER, this.psz, "MmLoadedUserImageList", null);
        if (this.is32Bit) {
            return struct;
        }
        struct.add(POINTER, this.psz, "NtBuildLab", null);
        struct.add(POINTER, this.psz, "KiNormalSystemCall", null);
        struct.add(POINTER, this.psz, "KiProcessorBlock", null);
        struct.add(POINTER, this.psz, "MmUnloadedDrivers", null);
        struct.add(POINTER, this.psz, "MmLastUnloadedDriver", null);
        struct.add(POINTER, this.psz, "MmTriageActionTaken", null);
        struct.add(POINTER, this.psz, "MmSpecialPoolTag", null);
        struct.add(POINTER, this.psz, "KernelVerifier", null);
        struct.add(POINTER, this.psz, "MmVerifierData", null);
        struct.add(POINTER, this.psz, "MmAllocatedNonPagedPool", null);
        struct.add(POINTER, this.psz, "MmPeakCommitment", null);
        struct.add(POINTER, this.psz, "MmTotalCommitLimitMaximum", null);
        struct.add(POINTER, this.psz, "CmNtCSDVersion", null);
        struct.add(POINTER, this.psz, "MmPhysicalMemoryBlock", null);
        struct.add(POINTER, this.psz, "MmSessionBase", null);
        struct.add(POINTER, this.psz, "MmSessionSize", null);
        struct.add(POINTER, this.psz, "MmSystemParentTablePage", null);
        struct.add(POINTER, this.psz, "MmVirtualTranslationBase", null);
        struct.add(WORD, 2, "OffsetKThreadNextProcessor", null);
        struct.add(WORD, 2, "OffsetKThreadTeb", null);
        struct.add(WORD, 2, "OffsetKThreadKernelStack", null);
        struct.add(WORD, 2, "OffsetKThreadInitialStack", null);
        struct.add(WORD, 2, "OffsetKThreadApcProcess", null);
        struct.add(WORD, 2, "OffsetKThreadState", null);
        struct.add(WORD, 2, "OffsetKThreadBStore", null);
        struct.add(WORD, 2, "OffsetKThreadBStoreLimit", null);
        struct.add(WORD, 2, "SizeEProcess", null);
        struct.add(WORD, 2, "OffsetEprocessPeb", null);
        struct.add(WORD, 2, "OffsetEprocessParentCID", null);
        struct.add(WORD, 2, "OffsetEprocessDirectoryTableBase", null);
        struct.add(WORD, 2, "SizePrcb", null);
        struct.add(WORD, 2, "OffsetPrcbDpcRoutine", null);
        struct.add(WORD, 2, "OffsetPrcbCurrentThread", null);
        struct.add(WORD, 2, "OffsetPrcbMhz", null);
        struct.add(WORD, 2, "OffsetPrcbCpuType", null);
        struct.add(WORD, 2, "OffsetPrcbVendorString", null);
        struct.add(WORD, 2, "OffsetPrcbProcStateContext", null);
        struct.add(WORD, 2, "OffsetPrcbNumber", null);
        struct.add(WORD, 2, "SizeEThread", null);
        struct.add(BYTE, "L1tfHighPhysicalBitIndex", null);
        struct.add(BYTE, "L1tfSwizzleBitIndex", null);
        struct.add(DWORD, 4, "Padding0", null);
        struct.add(POINTER, this.psz, "KdPrintCircularBufferPtr", null);
        struct.add(POINTER, this.psz, "KdPrintBufferSize", null);
        struct.add(POINTER, this.psz, "KeLoaderBlock", null);
        struct.add(WORD, 2, "SizePcr", null);
        struct.add(WORD, 2, "OffsetPcrSelfPcr", null);
        struct.add(WORD, 2, "OffsetPcrCurrentPrcb", null);
        struct.add(WORD, 2, "OffsetPcrContainedPrcb", null);
        struct.add(WORD, 2, "OffsetPcrInitialBStore", null);
        struct.add(WORD, 2, "OffsetPcrBStoreLimit", null);
        struct.add(WORD, 2, "OffsetPcrInitialStack", null);
        struct.add(WORD, 2, "OffsetPcrStackLimit", null);
        struct.add(WORD, 2, "OffsetPrcbPcrPage", null);
        struct.add(WORD, 2, "OffsetPrcbProcStateSpecialReg", null);
        struct.add(WORD, 2, "GdtR0Code", null);
        struct.add(WORD, 2, "GdtR0Data", null);
        struct.add(WORD, 2, "GdtR0Pcr", null);
        struct.add(WORD, 2, "GdtR3Code", null);
        struct.add(WORD, 2, "GdtR3Data", null);
        struct.add(WORD, 2, "GdtR3Teb", null);
        struct.add(WORD, 2, "GdtLdt", null);
        struct.add(WORD, 2, "GdtTss", null);
        struct.add(WORD, 2, "Gdt64R3CmCode", null);
        struct.add(WORD, 2, "Gdt64R3CmTeb", null);
        struct.add(POINTER, this.psz, "IopNumTriageDumpDataBlocks", null);
        struct.add(POINTER, this.psz, "IopTriageDumpDataBlocks", null);
        struct.add(POINTER, this.psz, "VfCrashDataBlock", null);
        struct.add(POINTER, this.psz, "MmBadPagesDetected", null);
        struct.add(POINTER, this.psz, "MmZeroedPageSingleBitErrorsDetected", null);
        struct.add(POINTER, this.psz, "EtwpDebuggerData", null);
        struct.add(WORD, 2, "OffsetPrcbContext", null);
        struct.add(WORD, 2, "OffsetPrcbMaxBreakpoints", null);
        struct.add(WORD, 2, "OffsetPrcbMaxWatchpoints", null);
        struct.add(DWORD, 4, "OffsetKThreadStackLimit", null);
        struct.add(DWORD, 4, "OffsetKThreadStackBase", null);
        struct.add(DWORD, 4, "OffsetKThreadQueueListEntry", null);
        struct.add(DWORD, 4, "OffsetEThreadIrpList", null);
        struct.add(WORD, 2, "OffsetPrcbIdleThread", null);
        struct.add(WORD, 2, "OffsetPrcbNormalDpcState", null);
        struct.add(WORD, 2, "OffsetPrcbDpcStack", null);
        struct.add(WORD, 2, "OffsetPrcbIsrStack", null);
        struct.add(WORD, 2, "SizeKDPC_STACK_FRAME", null);
        struct.add(WORD, 2, "OffsetKPriQueueThreadListHead", null);
        struct.add(WORD, 2, "OffsetKThreadWaitReason", null);
        struct.add(WORD, 2, "Padding1", null);
        struct.add(QWORD, this.psz, "PteBase", null);
        struct.add(QWORD, this.psz, "RetpolineStubFunctionTable", null);
        struct.add(DWORD, 4, "RetpolineStubFunctionTableSize", null);
        struct.add(DWORD, 4, "RetpolineStubOffset", null);
        struct.add(DWORD, 4, "RetpolineStubSize", null);
        struct.add(WORD, 2, "OffsetEProcessMmHotPatchContext", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public long getList_Flink() {
        return this.List_Flink;
    }

    public void setList_Flink(long list_Flink) {
        this.List_Flink = list_Flink;
    }

    public long getList_Blink() {
        return this.List_Blink;
    }

    public void setList_Blink(long list_Blink) {
        this.List_Blink = list_Blink;
    }

    public int getOwnerTag() {
        return this.OwnerTag;
    }

    public void setOwnerTag(int ownerTag) {
        this.OwnerTag = ownerTag;
    }

    public int getSize() {
        return this.Size;
    }

    public void setSize(int size) {
        this.Size = size;
    }

    public long getKernBase() {
        return this.KernBase;
    }

    public void setKernBase(long kernBase) {
        this.KernBase = kernBase;
    }

    public long getBreakpointWithStatus() {
        return this.BreakpointWithStatus;
    }

    public void setBreakpointWithStatus(long breakpointWithStatus) {
        this.BreakpointWithStatus = breakpointWithStatus;
    }

    public long getSavedContext() {
        return this.SavedContext;
    }

    public void setSavedContext(long savedContext) {
        this.SavedContext = savedContext;
    }

    public short getThCallbackStack() {
        return this.ThCallbackStack;
    }

    public void setThCallbackStack(short thCallbackStack) {
        this.ThCallbackStack = thCallbackStack;
    }

    public short getNextCallback() {
        return this.NextCallback;
    }

    public void setNextCallback(short nextCallback) {
        this.NextCallback = nextCallback;
    }

    public short getFramePointer() {
        return this.FramePointer;
    }

    public void setFramePointer(short framePointer) {
        this.FramePointer = framePointer;
    }

    public short getFlags() {
        return this.Flags;
    }

    public void setFlags(short flags) {
        this.Flags = flags;
    }

    public long getKiCallUserMode() {
        return this.KiCallUserMode;
    }

    public void setKiCallUserMode(long kiCallUserMode) {
        this.KiCallUserMode = kiCallUserMode;
    }

    public long getKeUserCallbackDispatcher() {
        return this.KeUserCallbackDispatcher;
    }

    public void setKeUserCallbackDispatcher(long keUserCallbackDispatcher) {
        this.KeUserCallbackDispatcher = keUserCallbackDispatcher;
    }

    public long getPsLoadedModuleList() {
        return this.PsLoadedModuleList;
    }

    public void setPsLoadedModuleList(long psLoadedModuleList) {
        this.PsLoadedModuleList = psLoadedModuleList;
    }

    public long getPsActiveProcessHead() {
        return this.PsActiveProcessHead;
    }

    public void setPsActiveProcessHead(long psActiveProcessHead) {
        this.PsActiveProcessHead = psActiveProcessHead;
    }

    public long getPspCidTable() {
        return this.PspCidTable;
    }

    public void setPspCidTable(long pspCidTable) {
        this.PspCidTable = pspCidTable;
    }

    public long getExpSystemResourcesList() {
        return this.ExpSystemResourcesList;
    }

    public void setExpSystemResourcesList(long expSystemResourcesList) {
        this.ExpSystemResourcesList = expSystemResourcesList;
    }

    public long getExpPagedPoolDescriptor() {
        return this.ExpPagedPoolDescriptor;
    }

    public void setExpPagedPoolDescriptor(long expPagedPoolDescriptor) {
        this.ExpPagedPoolDescriptor = expPagedPoolDescriptor;
    }

    public long getExpNumberOfPagedPools() {
        return this.ExpNumberOfPagedPools;
    }

    public void setExpNumberOfPagedPools(long expNumberOfPagedPools) {
        this.ExpNumberOfPagedPools = expNumberOfPagedPools;
    }

    public long getKeTimeIncrement() {
        return this.KeTimeIncrement;
    }

    public void setKeTimeIncrement(long keTimeIncrement) {
        this.KeTimeIncrement = keTimeIncrement;
    }

    public long getKeBugCheckCallbackListHead() {
        return this.KeBugCheckCallbackListHead;
    }

    public void setKeBugCheckCallbackListHead(long keBugCheckCallbackListHead) {
        this.KeBugCheckCallbackListHead = keBugCheckCallbackListHead;
    }

    public long getKiBugcheckData() {
        return this.KiBugcheckData;
    }

    public void setKiBugcheckData(long kiBugcheckData) {
        this.KiBugcheckData = kiBugcheckData;
    }

    public long getIopErrorLogListHead() {
        return this.IopErrorLogListHead;
    }

    public void setIopErrorLogListHead(long iopErrorLogListHead) {
        this.IopErrorLogListHead = iopErrorLogListHead;
    }

    public long getObpRootDirectoryObject() {
        return this.ObpRootDirectoryObject;
    }

    public void setObpRootDirectoryObject(long obpRootDirectoryObject) {
        this.ObpRootDirectoryObject = obpRootDirectoryObject;
    }

    public long getObpTypeObjectType() {
        return this.ObpTypeObjectType;
    }

    public void setObpTypeObjectType(long obpTypeObjectType) {
        this.ObpTypeObjectType = obpTypeObjectType;
    }

    public long getMmSystemCacheStart() {
        return this.MmSystemCacheStart;
    }

    public void setMmSystemCacheStart(long mmSystemCacheStart) {
        this.MmSystemCacheStart = mmSystemCacheStart;
    }

    public long getMmSystemCacheEnd() {
        return this.MmSystemCacheEnd;
    }

    public void setMmSystemCacheEnd(long mmSystemCacheEnd) {
        this.MmSystemCacheEnd = mmSystemCacheEnd;
    }

    public long getMmSystemCacheWs() {
        return this.MmSystemCacheWs;
    }

    public void setMmSystemCacheWs(long mmSystemCacheWs) {
        this.MmSystemCacheWs = mmSystemCacheWs;
    }

    public long getMmPfnDatabase() {
        return this.MmPfnDatabase;
    }

    public void setMmPfnDatabase(long mmPfnDatabase) {
        this.MmPfnDatabase = mmPfnDatabase;
    }

    public long getMmSystemPtesStart() {
        return this.MmSystemPtesStart;
    }

    public void setMmSystemPtesStart(long mmSystemPtesStart) {
        this.MmSystemPtesStart = mmSystemPtesStart;
    }

    public long getMmSystemPtesEnd() {
        return this.MmSystemPtesEnd;
    }

    public void setMmSystemPtesEnd(long mmSystemPtesEnd) {
        this.MmSystemPtesEnd = mmSystemPtesEnd;
    }

    public long getMmSubsectionBase() {
        return this.MmSubsectionBase;
    }

    public void setMmSubsectionBase(long mmSubsectionBase) {
        this.MmSubsectionBase = mmSubsectionBase;
    }

    public long getMmNumberOfPagingFiles() {
        return this.MmNumberOfPagingFiles;
    }

    public void setMmNumberOfPagingFiles(long mmNumberOfPagingFiles) {
        this.MmNumberOfPagingFiles = mmNumberOfPagingFiles;
    }

    public long getMmLowestPhysicalPage() {
        return this.MmLowestPhysicalPage;
    }

    public void setMmLowestPhysicalPage(long mmLowestPhysicalPage) {
        this.MmLowestPhysicalPage = mmLowestPhysicalPage;
    }

    public long getMmHighestPhysicalPage() {
        return this.MmHighestPhysicalPage;
    }

    public void setMmHighestPhysicalPage(long mmHighestPhysicalPage) {
        this.MmHighestPhysicalPage = mmHighestPhysicalPage;
    }

    public long getMmNumberOfPhysicalPages() {
        return this.MmNumberOfPhysicalPages;
    }

    public void setMmNumberOfPhysicalPages(long mmNumberOfPhysicalPages) {
        this.MmNumberOfPhysicalPages = mmNumberOfPhysicalPages;
    }

    public long getMmMaximumNonPagedPoolInBytes() {
        return this.MmMaximumNonPagedPoolInBytes;
    }

    public void setMmMaximumNonPagedPoolInBytes(long mmMaximumNonPagedPoolInBytes) {
        this.MmMaximumNonPagedPoolInBytes = mmMaximumNonPagedPoolInBytes;
    }

    public long getMmNonPagedSystemStart() {
        return this.MmNonPagedSystemStart;
    }

    public void setMmNonPagedSystemStart(long mmNonPagedSystemStart) {
        this.MmNonPagedSystemStart = mmNonPagedSystemStart;
    }

    public long getMmNonPagedPoolStart() {
        return this.MmNonPagedPoolStart;
    }

    public void setMmNonPagedPoolStart(long mmNonPagedPoolStart) {
        this.MmNonPagedPoolStart = mmNonPagedPoolStart;
    }

    public long getMmNonPagedPoolEnd() {
        return this.MmNonPagedPoolEnd;
    }

    public void setMmNonPagedPoolEnd(long mmNonPagedPoolEnd) {
        this.MmNonPagedPoolEnd = mmNonPagedPoolEnd;
    }

    public long getMmPagedPoolStart() {
        return this.MmPagedPoolStart;
    }

    public void setMmPagedPoolStart(long mmPagedPoolStart) {
        this.MmPagedPoolStart = mmPagedPoolStart;
    }

    public long getMmPagedPoolEnd() {
        return this.MmPagedPoolEnd;
    }

    public void setMmPagedPoolEnd(long mmPagedPoolEnd) {
        this.MmPagedPoolEnd = mmPagedPoolEnd;
    }

    public long getMmPagedPoolInformation() {
        return this.MmPagedPoolInformation;
    }

    public void setMmPagedPoolInformation(long mmPagedPoolInformation) {
        this.MmPagedPoolInformation = mmPagedPoolInformation;
    }

    public long getMmPageSize() {
        return this.MmPageSize;
    }

    public void setMmPageSize(long mmPageSize) {
        this.MmPageSize = mmPageSize;
    }

    public long getMmSizeOfPagedPoolInBytes() {
        return this.MmSizeOfPagedPoolInBytes;
    }

    public void setMmSizeOfPagedPoolInBytes(long mmSizeOfPagedPoolInBytes) {
        this.MmSizeOfPagedPoolInBytes = mmSizeOfPagedPoolInBytes;
    }

    public long getMmTotalCommitLimit() {
        return this.MmTotalCommitLimit;
    }

    public void setMmTotalCommitLimit(long mmTotalCommitLimit) {
        this.MmTotalCommitLimit = mmTotalCommitLimit;
    }

    public long getMmTotalCommittedPages() {
        return this.MmTotalCommittedPages;
    }

    public void setMmTotalCommittedPages(long mmTotalCommittedPages) {
        this.MmTotalCommittedPages = mmTotalCommittedPages;
    }

    public long getMmSharedCommit() {
        return this.MmSharedCommit;
    }

    public void setMmSharedCommit(long mmSharedCommit) {
        this.MmSharedCommit = mmSharedCommit;
    }

    public long getMmDriverCommit() {
        return this.MmDriverCommit;
    }

    public void setMmDriverCommit(long mmDriverCommit) {
        this.MmDriverCommit = mmDriverCommit;
    }

    public long getMmProcessCommit() {
        return this.MmProcessCommit;
    }

    public void setMmProcessCommit(long mmProcessCommit) {
        this.MmProcessCommit = mmProcessCommit;
    }

    public long getMmPagedPoolCommit() {
        return this.MmPagedPoolCommit;
    }

    public void setMmPagedPoolCommit(long mmPagedPoolCommit) {
        this.MmPagedPoolCommit = mmPagedPoolCommit;
    }

    public long getMmExtendedCommit() {
        return this.MmExtendedCommit;
    }

    public void setMmExtendedCommit(long mmExtendedCommit) {
        this.MmExtendedCommit = mmExtendedCommit;
    }

    public long getMmZeroedPageListHead() {
        return this.MmZeroedPageListHead;
    }

    public void setMmZeroedPageListHead(long mmZeroedPageListHead) {
        this.MmZeroedPageListHead = mmZeroedPageListHead;
    }

    public long getMmFreePageListHead() {
        return this.MmFreePageListHead;
    }

    public void setMmFreePageListHead(long mmFreePageListHead) {
        this.MmFreePageListHead = mmFreePageListHead;
    }

    public long getMmStandbyPageListHead() {
        return this.MmStandbyPageListHead;
    }

    public void setMmStandbyPageListHead(long mmStandbyPageListHead) {
        this.MmStandbyPageListHead = mmStandbyPageListHead;
    }

    public long getMmModifiedPageListHead() {
        return this.MmModifiedPageListHead;
    }

    public void setMmModifiedPageListHead(long mmModifiedPageListHead) {
        this.MmModifiedPageListHead = mmModifiedPageListHead;
    }

    public long getMmModifiedNoWritePageListHead() {
        return this.MmModifiedNoWritePageListHead;
    }

    public void setMmModifiedNoWritePageListHead(long mmModifiedNoWritePageListHead) {
        this.MmModifiedNoWritePageListHead = mmModifiedNoWritePageListHead;
    }

    public long getMmAvailablePages() {
        return this.MmAvailablePages;
    }

    public void setMmAvailablePages(long mmAvailablePages) {
        this.MmAvailablePages = mmAvailablePages;
    }

    public long getMmResidentAvailablePages() {
        return this.MmResidentAvailablePages;
    }

    public void setMmResidentAvailablePages(long mmResidentAvailablePages) {
        this.MmResidentAvailablePages = mmResidentAvailablePages;
    }

    public long getPoolTrackTable() {
        return this.PoolTrackTable;
    }

    public void setPoolTrackTable(long poolTrackTable) {
        this.PoolTrackTable = poolTrackTable;
    }

    public long getNonPagedPoolDescriptor() {
        return this.NonPagedPoolDescriptor;
    }

    public void setNonPagedPoolDescriptor(long nonPagedPoolDescriptor) {
        this.NonPagedPoolDescriptor = nonPagedPoolDescriptor;
    }

    public long getMmHighestUserAddress() {
        return this.MmHighestUserAddress;
    }

    public void setMmHighestUserAddress(long mmHighestUserAddress) {
        this.MmHighestUserAddress = mmHighestUserAddress;
    }

    public long getMmSystemRangeStart() {
        return this.MmSystemRangeStart;
    }

    public void setMmSystemRangeStart(long mmSystemRangeStart) {
        this.MmSystemRangeStart = mmSystemRangeStart;
    }

    public long getMmUserProbeAddress() {
        return this.MmUserProbeAddress;
    }

    public void setMmUserProbeAddress(long mmUserProbeAddress) {
        this.MmUserProbeAddress = mmUserProbeAddress;
    }

    public long getKdPrintCircularBuffer() {
        return this.KdPrintCircularBuffer;
    }

    public void setKdPrintCircularBuffer(long kdPrintCircularBuffer) {
        this.KdPrintCircularBuffer = kdPrintCircularBuffer;
    }

    public long getKdPrintCircularBufferEnd() {
        return this.KdPrintCircularBufferEnd;
    }

    public void setKdPrintCircularBufferEnd(long kdPrintCircularBufferEnd) {
        this.KdPrintCircularBufferEnd = kdPrintCircularBufferEnd;
    }

    public long getKdPrintWritePointer() {
        return this.KdPrintWritePointer;
    }

    public void setKdPrintWritePointer(long kdPrintWritePointer) {
        this.KdPrintWritePointer = kdPrintWritePointer;
    }

    public long getKdPrintRolloverCount() {
        return this.KdPrintRolloverCount;
    }

    public void setKdPrintRolloverCount(long kdPrintRolloverCount) {
        this.KdPrintRolloverCount = kdPrintRolloverCount;
    }

    public long getMmLoadedUserImageList() {
        return this.MmLoadedUserImageList;
    }

    public void setMmLoadedUserImageList(long mmLoadedUserImageList) {
        this.MmLoadedUserImageList = mmLoadedUserImageList;
    }

    public long getNtBuildLab() {
        return this.NtBuildLab;
    }

    public void setNtBuildLab(long ntBuildLab) {
        this.NtBuildLab = ntBuildLab;
    }

    public long getKiNormalSystemCall() {
        return this.KiNormalSystemCall;
    }

    public void setKiNormalSystemCall(long kiNormalSystemCall) {
        this.KiNormalSystemCall = kiNormalSystemCall;
    }

    public long getKiProcessorBlock() {
        return this.KiProcessorBlock;
    }

    public void setKiProcessorBlock(long kiProcessorBlock) {
        this.KiProcessorBlock = kiProcessorBlock;
    }

    public long getMmUnloadedDrivers() {
        return this.MmUnloadedDrivers;
    }

    public void setMmUnloadedDrivers(long mmUnloadedDrivers) {
        this.MmUnloadedDrivers = mmUnloadedDrivers;
    }

    public long getMmLastUnloadedDriver() {
        return this.MmLastUnloadedDriver;
    }

    public void setMmLastUnloadedDriver(long mmLastUnloadedDriver) {
        this.MmLastUnloadedDriver = mmLastUnloadedDriver;
    }

    public long getMmTriageActionTaken() {
        return this.MmTriageActionTaken;
    }

    public void setMmTriageActionTaken(long mmTriageActionTaken) {
        this.MmTriageActionTaken = mmTriageActionTaken;
    }

    public long getMmSpecialPoolTag() {
        return this.MmSpecialPoolTag;
    }

    public void setMmSpecialPoolTag(long mmSpecialPoolTag) {
        this.MmSpecialPoolTag = mmSpecialPoolTag;
    }

    public long getKernelVerifier() {
        return this.KernelVerifier;
    }

    public void setKernelVerifier(long kernelVerifier) {
        this.KernelVerifier = kernelVerifier;
    }

    public long getMmVerifierData() {
        return this.MmVerifierData;
    }

    public void setMmVerifierData(long mmVerifierData) {
        this.MmVerifierData = mmVerifierData;
    }

    public long getMmAllocatedNonPagedPool() {
        return this.MmAllocatedNonPagedPool;
    }

    public void setMmAllocatedNonPagedPool(long mmAllocatedNonPagedPool) {
        this.MmAllocatedNonPagedPool = mmAllocatedNonPagedPool;
    }

    public long getMmPeakCommitment() {
        return this.MmPeakCommitment;
    }

    public void setMmPeakCommitment(long mmPeakCommitment) {
        this.MmPeakCommitment = mmPeakCommitment;
    }

    public long getMmTotalCommitLimitMaximum() {
        return this.MmTotalCommitLimitMaximum;
    }

    public void setMmTotalCommitLimitMaximum(long mmTotalCommitLimitMaximum) {
        this.MmTotalCommitLimitMaximum = mmTotalCommitLimitMaximum;
    }

    public long getCmNtCSDVersion() {
        return this.CmNtCSDVersion;
    }

    public void setCmNtCSDVersion(long cmNtCSDVersion) {
        this.CmNtCSDVersion = cmNtCSDVersion;
    }

    public long getMmPhysicalMemoryBlock() {
        return this.MmPhysicalMemoryBlock;
    }

    public void setMmPhysicalMemoryBlock(long mmPhysicalMemoryBlock) {
        this.MmPhysicalMemoryBlock = mmPhysicalMemoryBlock;
    }

    public long getMmSessionBase() {
        return this.MmSessionBase;
    }

    public void setMmSessionBase(long mmSessionBase) {
        this.MmSessionBase = mmSessionBase;
    }

    public long getMmSessionSize() {
        return this.MmSessionSize;
    }

    public void setMmSessionSize(long mmSessionSize) {
        this.MmSessionSize = mmSessionSize;
    }

    public long getMmSystemParentTablePage() {
        return this.MmSystemParentTablePage;
    }

    public void setMmSystemParentTablePage(long mmSystemParentTablePage) {
        this.MmSystemParentTablePage = mmSystemParentTablePage;
    }

    public long getMmVirtualTranslationBase() {
        return this.MmVirtualTranslationBase;
    }

    public void setMmVirtualTranslationBase(long mmVirtualTranslationBase) {
        this.MmVirtualTranslationBase = mmVirtualTranslationBase;
    }

    public short getOffsetKThreadNextProcessor() {
        return this.OffsetKThreadNextProcessor;
    }

    public void setOffsetKThreadNextProcessor(short offsetKThreadNextProcessor) {
        this.OffsetKThreadNextProcessor = offsetKThreadNextProcessor;
    }

    public short getOffsetKThreadTeb() {
        return this.OffsetKThreadTeb;
    }

    public void setOffsetKThreadTeb(short offsetKThreadTeb) {
        this.OffsetKThreadTeb = offsetKThreadTeb;
    }

    public short getOffsetKThreadKernelStack() {
        return this.OffsetKThreadKernelStack;
    }

    public void setOffsetKThreadKernelStack(short offsetKThreadKernelStack) {
        this.OffsetKThreadKernelStack = offsetKThreadKernelStack;
    }

    public short getOffsetKThreadInitialStack() {
        return this.OffsetKThreadInitialStack;
    }

    public void setOffsetKThreadInitialStack(short offsetKThreadInitialStack) {
        this.OffsetKThreadInitialStack = offsetKThreadInitialStack;
    }

    public short getOffsetKThreadApcProcess() {
        return this.OffsetKThreadApcProcess;
    }

    public void setOffsetKThreadApcProcess(short offsetKThreadApcProcess) {
        this.OffsetKThreadApcProcess = offsetKThreadApcProcess;
    }

    public short getOffsetKThreadState() {
        return this.OffsetKThreadState;
    }

    public void setOffsetKThreadState(short offsetKThreadState) {
        this.OffsetKThreadState = offsetKThreadState;
    }

    public short getOffsetKThreadBStore() {
        return this.OffsetKThreadBStore;
    }

    public void setOffsetKThreadBStore(short offsetKThreadBStore) {
        this.OffsetKThreadBStore = offsetKThreadBStore;
    }

    public short getOffsetKThreadBStoreLimit() {
        return this.OffsetKThreadBStoreLimit;
    }

    public void setOffsetKThreadBStoreLimit(short offsetKThreadBStoreLimit) {
        this.OffsetKThreadBStoreLimit = offsetKThreadBStoreLimit;
    }

    public short getSizeEProcess() {
        return this.SizeEProcess;
    }

    public void setSizeEProcess(short sizeEProcess) {
        this.SizeEProcess = sizeEProcess;
    }

    public short getOffsetEprocessPeb() {
        return this.OffsetEprocessPeb;
    }

    public void setOffsetEprocessPeb(short offsetEprocessPeb) {
        this.OffsetEprocessPeb = offsetEprocessPeb;
    }

    public short getOffsetEprocessParentCID() {
        return this.OffsetEprocessParentCID;
    }

    public void setOffsetEprocessParentCID(short offsetEprocessParentCID) {
        this.OffsetEprocessParentCID = offsetEprocessParentCID;
    }

    public short getOffsetEprocessDirectoryTableBase() {
        return this.OffsetEprocessDirectoryTableBase;
    }

    public void setOffsetEprocessDirectoryTableBase(short offsetEprocessDirectoryTableBase) {
        this.OffsetEprocessDirectoryTableBase = offsetEprocessDirectoryTableBase;
    }

    public short getSizePrcb() {
        return this.SizePrcb;
    }

    public void setSizePrcb(short sizePrcb) {
        this.SizePrcb = sizePrcb;
    }

    public short getOffsetPrcbDpcRoutine() {
        return this.OffsetPrcbDpcRoutine;
    }

    public void setOffsetPrcbDpcRoutine(short offsetPrcbDpcRoutine) {
        this.OffsetPrcbDpcRoutine = offsetPrcbDpcRoutine;
    }

    public short getOffsetPrcbCurrentThread() {
        return this.OffsetPrcbCurrentThread;
    }

    public void setOffsetPrcbCurrentThread(short offsetPrcbCurrentThread) {
        this.OffsetPrcbCurrentThread = offsetPrcbCurrentThread;
    }

    public short getOffsetPrcbMhz() {
        return this.OffsetPrcbMhz;
    }

    public void setOffsetPrcbMhz(short offsetPrcbMhz) {
        this.OffsetPrcbMhz = offsetPrcbMhz;
    }

    public short getOffsetPrcbCpuType() {
        return this.OffsetPrcbCpuType;
    }

    public void setOffsetPrcbCpuType(short offsetPrcbCpuType) {
        this.OffsetPrcbCpuType = offsetPrcbCpuType;
    }

    public short getOffsetPrcbVendorString() {
        return this.OffsetPrcbVendorString;
    }

    public void setOffsetPrcbVendorString(short offsetPrcbVendorString) {
        this.OffsetPrcbVendorString = offsetPrcbVendorString;
    }

    public short getOffsetPrcbProcStateContext() {
        return this.OffsetPrcbProcStateContext;
    }

    public void setOffsetPrcbProcStateContext(short offsetPrcbProcStateContext) {
        this.OffsetPrcbProcStateContext = offsetPrcbProcStateContext;
    }

    public short getOffsetPrcbNumber() {
        return this.OffsetPrcbNumber;
    }

    public void setOffsetPrcbNumber(short offsetPrcbNumber) {
        this.OffsetPrcbNumber = offsetPrcbNumber;
    }

    public short getSizeEThread() {
        return this.SizeEThread;
    }

    public void setSizeEThread(short sizeEThread) {
        this.SizeEThread = sizeEThread;
    }

    public byte getL1tfHighPhysicalBitIndex() {
        return this.L1tfHighPhysicalBitIndex;
    }

    public void setL1tfHighPhysicalBitIndex(byte l1tfHighPhysicalBitIndex) {
        this.L1tfHighPhysicalBitIndex = l1tfHighPhysicalBitIndex;
    }

    public byte getL1tfSwizzleBitIndex() {
        return this.L1tfSwizzleBitIndex;
    }

    public void setL1tfSwizzleBitIndex(byte l1tfSwizzleBitIndex) {
        this.L1tfSwizzleBitIndex = l1tfSwizzleBitIndex;
    }

    public int getPadding0() {
        return this.Padding0;
    }

    public void setPadding0(int padding0) {
        this.Padding0 = padding0;
    }

    public long getKdPrintCircularBufferPtr() {
        return this.KdPrintCircularBufferPtr;
    }

    public void setKdPrintCircularBufferPtr(long kdPrintCircularBufferPtr) {
        this.KdPrintCircularBufferPtr = kdPrintCircularBufferPtr;
    }

    public long getKdPrintBufferSize() {
        return this.KdPrintBufferSize;
    }

    public void setKdPrintBufferSize(long kdPrintBufferSize) {
        this.KdPrintBufferSize = kdPrintBufferSize;
    }

    public long getKeLoaderBlock() {
        return this.KeLoaderBlock;
    }

    public void setKeLoaderBlock(long keLoaderBlock) {
        this.KeLoaderBlock = keLoaderBlock;
    }

    public short getSizePcr() {
        return this.SizePcr;
    }

    public void setSizePcr(short sizePcr) {
        this.SizePcr = sizePcr;
    }

    public short getOffsetPcrSelfPcr() {
        return this.OffsetPcrSelfPcr;
    }

    public void setOffsetPcrSelfPcr(short offsetPcrSelfPcr) {
        this.OffsetPcrSelfPcr = offsetPcrSelfPcr;
    }

    public short getOffsetPcrCurrentPrcb() {
        return this.OffsetPcrCurrentPrcb;
    }

    public void setOffsetPcrCurrentPrcb(short offsetPcrCurrentPrcb) {
        this.OffsetPcrCurrentPrcb = offsetPcrCurrentPrcb;
    }

    public short getOffsetPcrContainedPrcb() {
        return this.OffsetPcrContainedPrcb;
    }

    public void setOffsetPcrContainedPrcb(short offsetPcrContainedPrcb) {
        this.OffsetPcrContainedPrcb = offsetPcrContainedPrcb;
    }

    public short getOffsetPcrInitialBStore() {
        return this.OffsetPcrInitialBStore;
    }

    public void setOffsetPcrInitialBStore(short offsetPcrInitialBStore) {
        this.OffsetPcrInitialBStore = offsetPcrInitialBStore;
    }

    public short getOffsetPcrBStoreLimit() {
        return this.OffsetPcrBStoreLimit;
    }

    public void setOffsetPcrBStoreLimit(short offsetPcrBStoreLimit) {
        this.OffsetPcrBStoreLimit = offsetPcrBStoreLimit;
    }

    public short getOffsetPcrInitialStack() {
        return this.OffsetPcrInitialStack;
    }

    public void setOffsetPcrInitialStack(short offsetPcrInitialStack) {
        this.OffsetPcrInitialStack = offsetPcrInitialStack;
    }

    public short getOffsetPcrStackLimit() {
        return this.OffsetPcrStackLimit;
    }

    public void setOffsetPcrStackLimit(short offsetPcrStackLimit) {
        this.OffsetPcrStackLimit = offsetPcrStackLimit;
    }

    public short getOffsetPrcbPcrPage() {
        return this.OffsetPrcbPcrPage;
    }

    public void setOffsetPrcbPcrPage(short offsetPrcbPcrPage) {
        this.OffsetPrcbPcrPage = offsetPrcbPcrPage;
    }

    public short getOffsetPrcbProcStateSpecialReg() {
        return this.OffsetPrcbProcStateSpecialReg;
    }

    public void setOffsetPrcbProcStateSpecialReg(short offsetPrcbProcStateSpecialReg) {
        this.OffsetPrcbProcStateSpecialReg = offsetPrcbProcStateSpecialReg;
    }

    public short getGdtR0Code() {
        return this.GdtR0Code;
    }

    public void setGdtR0Code(short gdtR0Code) {
        this.GdtR0Code = gdtR0Code;
    }

    public short getGdtR0Data() {
        return this.GdtR0Data;
    }

    public void setGdtR0Data(short gdtR0Data) {
        this.GdtR0Data = gdtR0Data;
    }

    public short getGdtR0Pcr() {
        return this.GdtR0Pcr;
    }

    public void setGdtR0Pcr(short gdtR0Pcr) {
        this.GdtR0Pcr = gdtR0Pcr;
    }

    public short getGdtR3Code() {
        return this.GdtR3Code;
    }

    public void setGdtR3Code(short gdtR3Code) {
        this.GdtR3Code = gdtR3Code;
    }

    public short getGdtR3Data() {
        return this.GdtR3Data;
    }

    public void setGdtR3Data(short gdtR3Data) {
        this.GdtR3Data = gdtR3Data;
    }

    public short getGdtR3Teb() {
        return this.GdtR3Teb;
    }

    public void setGdtR3Teb(short gdtR3Teb) {
        this.GdtR3Teb = gdtR3Teb;
    }

    public short getGdtLdt() {
        return this.GdtLdt;
    }

    public void setGdtLdt(short gdtLdt) {
        this.GdtLdt = gdtLdt;
    }

    public short getGdtTss() {
        return this.GdtTss;
    }

    public void setGdtTss(short gdtTss) {
        this.GdtTss = gdtTss;
    }

    public short getGdt64R3CmCode() {
        return this.Gdt64R3CmCode;
    }

    public void setGdt64R3CmCode(short gdt64r3CmCode) {
        this.Gdt64R3CmCode = gdt64r3CmCode;
    }

    public short getGdt64R3CmTeb() {
        return this.Gdt64R3CmTeb;
    }

    public void setGdt64R3CmTeb(short gdt64r3CmTeb) {
        this.Gdt64R3CmTeb = gdt64r3CmTeb;
    }

    public long getIopNumTriageDumpDataBlocks() {
        return this.IopNumTriageDumpDataBlocks;
    }

    public void setIopNumTriageDumpDataBlocks(long iopNumTriageDumpDataBlocks) {
        this.IopNumTriageDumpDataBlocks = iopNumTriageDumpDataBlocks;
    }

    public long getIopTriageDumpDataBlocks() {
        return this.IopTriageDumpDataBlocks;
    }

    public void setIopTriageDumpDataBlocks(long iopTriageDumpDataBlocks) {
        this.IopTriageDumpDataBlocks = iopTriageDumpDataBlocks;
    }

    public long getVfCrashDataBlock() {
        return this.VfCrashDataBlock;
    }

    public void setVfCrashDataBlock(long vfCrashDataBlock) {
        this.VfCrashDataBlock = vfCrashDataBlock;
    }

    public long getMmBadPagesDetected() {
        return this.MmBadPagesDetected;
    }

    public void setMmBadPagesDetected(long mmBadPagesDetected) {
        this.MmBadPagesDetected = mmBadPagesDetected;
    }

    public long getMmZeroedPageSingleBitErrorsDetected() {
        return this.MmZeroedPageSingleBitErrorsDetected;
    }

    public void setMmZeroedPageSingleBitErrorsDetected(long mmZeroedPageSingleBitErrorsDetected) {
        this.MmZeroedPageSingleBitErrorsDetected = mmZeroedPageSingleBitErrorsDetected;
    }

    public long getEtwpDebuggerData() {
        return this.EtwpDebuggerData;
    }

    public void setEtwpDebuggerData(long etwpDebuggerData) {
        this.EtwpDebuggerData = etwpDebuggerData;
    }

    public short getOffsetPrcbContext() {
        return this.OffsetPrcbContext;
    }

    public void setOffsetPrcbContext(short offsetPrcbContext) {
        this.OffsetPrcbContext = offsetPrcbContext;
    }

    public short getOffsetPrcbMaxBreakpoints() {
        return this.OffsetPrcbMaxBreakpoints;
    }

    public void setOffsetPrcbMaxBreakpoints(short offsetPrcbMaxBreakpoints) {
        this.OffsetPrcbMaxBreakpoints = offsetPrcbMaxBreakpoints;
    }

    public short getOffsetPrcbMaxWatchpoints() {
        return this.OffsetPrcbMaxWatchpoints;
    }

    public void setOffsetPrcbMaxWatchpoints(short offsetPrcbMaxWatchpoints) {
        this.OffsetPrcbMaxWatchpoints = offsetPrcbMaxWatchpoints;
    }

    public int getOffsetKThreadStackLimit() {
        return this.OffsetKThreadStackLimit;
    }

    public void setOffsetKThreadStackLimit(int offsetKThreadStackLimit) {
        this.OffsetKThreadStackLimit = offsetKThreadStackLimit;
    }

    public int getOffsetKThreadStackBase() {
        return this.OffsetKThreadStackBase;
    }

    public void setOffsetKThreadStackBase(int offsetKThreadStackBase) {
        this.OffsetKThreadStackBase = offsetKThreadStackBase;
    }

    public int getOffsetKThreadQueueListEntry() {
        return this.OffsetKThreadQueueListEntry;
    }

    public void setOffsetKThreadQueueListEntry(int offsetKThreadQueueListEntry) {
        this.OffsetKThreadQueueListEntry = offsetKThreadQueueListEntry;
    }

    public int getOffsetEThreadIrpList() {
        return this.OffsetEThreadIrpList;
    }

    public void setOffsetEThreadIrpList(int offsetEThreadIrpList) {
        this.OffsetEThreadIrpList = offsetEThreadIrpList;
    }

    public short getOffsetPrcbIdleThread() {
        return this.OffsetPrcbIdleThread;
    }

    public void setOffsetPrcbIdleThread(short offsetPrcbIdleThread) {
        this.OffsetPrcbIdleThread = offsetPrcbIdleThread;
    }

    public short getOffsetPrcbNormalDpcState() {
        return this.OffsetPrcbNormalDpcState;
    }

    public void setOffsetPrcbNormalDpcState(short offsetPrcbNormalDpcState) {
        this.OffsetPrcbNormalDpcState = offsetPrcbNormalDpcState;
    }

    public short getOffsetPrcbDpcStack() {
        return this.OffsetPrcbDpcStack;
    }

    public void setOffsetPrcbDpcStack(short offsetPrcbDpcStack) {
        this.OffsetPrcbDpcStack = offsetPrcbDpcStack;
    }

    public short getOffsetPrcbIsrStack() {
        return this.OffsetPrcbIsrStack;
    }

    public void setOffsetPrcbIsrStack(short offsetPrcbIsrStack) {
        this.OffsetPrcbIsrStack = offsetPrcbIsrStack;
    }

    public short getSizeKDPC_STACK_FRAME() {
        return this.SizeKDPC_STACK_FRAME;
    }

    public void setSizeKDPC_STACK_FRAME(short sizeKDPC_STACK_FRAME) {
        this.SizeKDPC_STACK_FRAME = sizeKDPC_STACK_FRAME;
    }

    public short getOffsetKPriQueueThreadListHead() {
        return this.OffsetKPriQueueThreadListHead;
    }

    public void setOffsetKPriQueueThreadListHead(short offsetKPriQueueThreadListHead) {
        this.OffsetKPriQueueThreadListHead = offsetKPriQueueThreadListHead;
    }

    public short getOffsetKThreadWaitReason() {
        return this.OffsetKThreadWaitReason;
    }

    public void setOffsetKThreadWaitReason(short offsetKThreadWaitReason) {
        this.OffsetKThreadWaitReason = offsetKThreadWaitReason;
    }

    public short getPadding1() {
        return this.Padding1;
    }

    public void setPadding1(short padding1) {
        this.Padding1 = padding1;
    }

    public long getPteBase() {
        return this.PteBase;
    }

    public void setPteBase(long pteBase) {
        this.PteBase = pteBase;
    }

    public long getRetpolineStubFunctionTable() {
        return this.RetpolineStubFunctionTable;
    }

    public void setRetpolineStubFunctionTable(long retpolineStubFunctionTable) {
        this.RetpolineStubFunctionTable = retpolineStubFunctionTable;
    }

    public int getRetpolineStubFunctionTableSize() {
        return this.RetpolineStubFunctionTableSize;
    }

    public void setRetpolineStubFunctionTableSize(int retpolineStubFunctionTableSize) {
        this.RetpolineStubFunctionTableSize = retpolineStubFunctionTableSize;
    }

    public int getRetpolineStubOffset() {
        return this.RetpolineStubOffset;
    }

    public void setRetpolineStubOffset(int retpolineStubOffset) {
        this.RetpolineStubOffset = retpolineStubOffset;
    }

    public int getRetpolineStubSize() {
        return this.RetpolineStubSize;
    }

    public void setRetpolineStubSize(int retpolineStubSize) {
        this.RetpolineStubSize = retpolineStubSize;
    }

    public short getOffsetEProcessMmHotPatchContext() {
        return this.OffsetEProcessMmHotPatchContext;
    }

    public void setOffsetEProcessMmHotPatchContext(short offsetEProcessMmHotPatchContext) {
        this.OffsetEProcessMmHotPatchContext = offsetEProcessMmHotPatchContext;
    }
}

