/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial;

import db.DBRecord;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.spatial.BoundingShape;
import ghidra.util.database.spatial.DBTreeRecord;
import java.util.List;

public abstract class DBTreeNodeRecord<NS extends BoundingShape<NS>>
extends DBTreeRecord<NS, NS> {
    public DBTreeNodeRecord(DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
    }

    public String toString() {
        return String.format("<Node(%d,%s) %s, parentKey=%d, children=%d, data=%d>", new Object[]{this.getKey(), this.getType(), ((BoundingShape)this.getShape()).description(), this.getParentKey(), this.getChildCount(), this.getDataCount()});
    }

    protected abstract NodeType getType();

    protected abstract void setType(NodeType var1);

    protected abstract int getChildCount();

    protected abstract void setChildCount(int var1);

    protected abstract void setDataCount(int var1);

    protected static enum NodeType {
        DIRECTORY(true, false){

            @Override
            public NodeType getParentType() {
                return DIRECTORY;
            }
        }
        ,
        LEAF_PARENT(true, true){

            @Override
            public NodeType getParentType() {
                return DIRECTORY;
            }
        }
        ,
        LEAF(false, false){

            @Override
            public NodeType getParentType() {
                return LEAF_PARENT;
            }
        };

        public static final List<NodeType> VALUES;
        private final boolean directory;
        private final boolean leafParent;

        private NodeType(boolean directory, boolean leafParent) {
            this.directory = directory;
            this.leafParent = leafParent;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public boolean isLeafParent() {
            return this.leafParent;
        }

        public boolean isLeaf() {
            return !this.directory;
        }

        public abstract NodeType getParentType();

        static {
            VALUES = List.of(NodeType.values());
        }
    }
}

