/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.ascii;

import ghidra.program.model.data.AbstractStringDataType;

public class Sequence {
    private long start;
    private long end;
    private boolean nullTerminated;
    private AbstractStringDataType stringDataType;

    public Sequence(long start, long end, AbstractStringDataType stringDataType, boolean nullTerminated) {
        this.start = start;
        this.end = end;
        this.stringDataType = stringDataType;
        this.nullTerminated = nullTerminated;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isNullTerminated() {
        return this.nullTerminated;
    }

    public AbstractStringDataType getStringDataType() {
        return this.stringDataType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Sequence other = (Sequence)obj;
        return this.start == other.start && this.end == other.end && this.nullTerminated == other.nullTerminated && this.stringDataType.getClass() == other.stringDataType.getClass();
    }

    public int hashCode() {
        return (int)(this.start + this.end);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        buf.append(this.start);
        buf.append(',');
        buf.append(this.end);
        buf.append(',');
        buf.append(this.stringDataType.getDisplayName());
        buf.append(',');
        buf.append(this.nullTerminated);
        buf.append(')');
        return buf.toString();
    }

    public int getLength() {
        return (int)(this.end - this.start + 1L);
    }
}

