/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.crypto;

import docking.DialogComponentProvider;
import docking.widgets.label.GLabel;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

class PasswordDialog
extends DialogComponentProvider {
    private JPanel workPanel;
    JPasswordField passwordField;
    RESULT_STATE resultState;
    boolean cancelledAll;

    PasswordDialog(String title, String prompt) {
        super(title, true, true, true, false);
        this.setRememberSize(false);
        this.setStatusJustification(0);
        this.setMinimumSize(300, 100);
        this.passwordField = new JPasswordField(16);
        this.passwordField.getAccessibleContext().setAccessibleName("Password Entry");
        this.passwordField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getModifiersEx() == 0 && e.getKeyChar() == '\n') {
                    e.consume();
                    PasswordDialog.this.okCallback();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PasswordDialog.this.updateCapLockWarning();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                PasswordDialog.this.updateCapLockWarning();
            }
        });
        this.workPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.workPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.workPanel.add((Component)new GLabel(prompt != null ? prompt : "Password:"));
        this.workPanel.add(this.passwordField);
        this.workPanel.getAccessibleContext().setAccessibleName("Password");
        this.addWorkPanel(this.workPanel);
        this.addOKButton();
        this.addCancelButton();
        JButton cancelAllButton = new JButton("Cancel All");
        cancelAllButton.getAccessibleContext().setAccessibleName("Cancel All");
        cancelAllButton.addActionListener(e -> {
            this.cancelledAll = true;
            this.cancelButton.doClick();
        });
        this.addButton(cancelAllButton);
        this.updateCapLockWarning();
        this.setFocusComponent(this.passwordField);
        this.setHelpLocation(new HelpLocation("FileSystemBrowserPlugin", "PasswordDialog"));
    }

    private void updateCapLockWarning() {
        try {
            boolean capsLockOn = Toolkit.getDefaultToolkit().getLockingKeyState(20);
            if (capsLockOn) {
                this.setStatusText("Warning! Caps-Lock is on", MessageType.WARNING);
            } else {
                this.clearStatusText();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void close() {
        this.closeDialog();
    }

    protected void okCallback() {
        this.resultState = RESULT_STATE.OK;
        this.close();
    }

    protected void cancelCallback() {
        this.resultState = RESULT_STATE.CANCELED;
        super.cancelCallback();
    }

    public void dispose() {
        super.dispose();
        if (this.passwordField != null) {
            this.passwordField.setText("");
            this.workPanel.remove(this.passwordField);
            this.passwordField = null;
        }
    }

    static enum RESULT_STATE {
        OK,
        CANCELED;

    }
}

