/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import generic.hash.HashUtilities;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ObfuscatedFileByteProvider;
import ghidra.app.util.bin.ObfuscatedOutputStream;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.HashingOutputStream;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AccessMode;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.collections4.map.ReferenceMap;
import utilities.util.FileUtilities;

public class FileCache {
    public static final int MAX_INMEM_FILESIZE = 0x200000;
    private static final long FREESPACE_RESERVE_BYTES = 0x3200000L;
    private static final Pattern NESTING_DIR_NAME_REGEX = Pattern.compile("[0-9a-fA-F][0-9a-fA-F]");
    private static final Pattern FILENAME_REGEX = Pattern.compile("[0-9a-fA-F]{32}");
    private static final int MD5_BYTE_LEN = 16;
    public static final int MD5_HEXSTR_LEN = 32;
    private static final long MAX_FILE_AGE_MS = 86400000L;
    private static final long MAINT_INTERVAL_MS = 172800000L;
    private final File cacheDir;
    private final FileStore cacheDirFileStore;
    private final File newDir;
    private FileCacheMaintenanceDaemon cleanDaemon;
    private ReferenceMap<String, FileCacheEntry> memCache = new ReferenceMap();

    @Deprecated(forRemoval=true, since="10.1")
    public static void performCacheMaintOnOldDirIfNeeded(File oldCacheDir) {
        if (oldCacheDir.isDirectory()) {
            FileCache.performCacheMaintIfNeeded(oldCacheDir, 2);
        }
    }

    public FileCache(File cacheDir) throws IOException {
        this.cacheDir = cacheDir;
        this.newDir = new File(cacheDir, "new");
        if (!cacheDir.exists() && !cacheDir.mkdirs() || !this.newDir.exists() && !this.newDir.mkdirs()) {
            throw new IOException("Unable to initialize cache dir " + String.valueOf(cacheDir));
        }
        this.cacheDirFileStore = this.getFileStore(cacheDir);
        this.cleanDaemon = FileCache.performCacheMaintIfNeeded(cacheDir, 1);
    }

    public synchronized void purge() {
        for (File f : this.cacheDir.listFiles()) {
            String name = f.getName();
            if (!f.isDirectory() || !NESTING_DIR_NAME_REGEX.matcher(name).matches()) continue;
            FileUtilities.deleteDir((File)f);
        }
        this.memCache.clear();
    }

    synchronized boolean hasEntry(String md5) {
        FileCacheEntry fce = (FileCacheEntry)this.memCache.get((Object)md5);
        if (fce == null) {
            fce = this.getFileByMD5(md5);
        }
        return fce != null;
    }

    private void ensureAvailableSpace(long sizeHint) throws IOException {
        long usableSpace;
        if (this.cacheDirFileStore != null && sizeHint > 0x200000L && (usableSpace = this.cacheDirFileStore.getUsableSpace()) >= 0L && usableSpace < sizeHint + 0x3200000L) {
            throw new IOException("Not enough storage available in " + String.valueOf(this.cacheDir) + " to store file sized: " + sizeHint);
        }
    }

    synchronized FileCacheEntry getFileCacheEntry(String md5) {
        if (md5 == null) {
            return null;
        }
        FileCacheEntry fce = (FileCacheEntry)this.memCache.get((Object)md5);
        if (fce == null && (fce = this.getFileByMD5(md5)) != null) {
            fce.file.setLastModified(System.currentTimeMillis());
        }
        return fce;
    }

    synchronized void releaseFileCacheEntry(String md5) {
        FileCacheEntry fce = (FileCacheEntry)this.memCache.get((Object)md5);
        if (fce != null) {
            this.memCache.remove((Object)md5);
            Msg.debug((Object)this, (Object)("Releasing memCache entry: " + fce.md5 + ", " + fce.bytes.length));
        }
    }

    private FileCacheEntry getFileByMD5(String md5) {
        File f = new File(this.cacheDir, this.getCacheRelPath(md5));
        return f.exists() ? new FileCacheEntry(f, md5) : null;
    }

    private File createTempFile() {
        return new File(this.newDir, UUID.randomUUID().toString());
    }

    FileCacheEntryBuilder createCacheEntryBuilder(long sizeHint) throws IOException {
        this.ensureAvailableSpace(sizeHint);
        return new FileCacheEntryBuilder(sizeHint);
    }

    /*
     * Exception decompiling
     */
    FileCacheEntry giveFile(File file, TaskMonitor monitor) throws IOException, CancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileCacheEntry addTmpFileToCache(File tmpFile, String md5) throws IOException {
        String relPath = this.getCacheRelPath(md5);
        File destCacheFile = new File(this.cacheDir, relPath);
        File destCacheFileDir = destCacheFile.getParentFile();
        if (!destCacheFileDir.exists() && !FileUtilities.mkdirs((File)destCacheFileDir)) {
            throw new IOException("Failed to create cache dir " + String.valueOf(destCacheFileDir));
        }
        try {
            tmpFile.renameTo(destCacheFile);
        }
        finally {
            tmpFile.delete();
            if (!destCacheFile.exists()) {
                throw new IOException("Failed to move " + String.valueOf(tmpFile) + " to " + String.valueOf(destCacheFile));
            }
        }
        destCacheFile.setLastModified(System.currentTimeMillis());
        return new FileCacheEntry(destCacheFile, md5);
    }

    private String getCacheRelPath(String md5) {
        return String.format("%s/%s", md5.substring(0, 2), md5);
    }

    public String toString() {
        return "FileCache [cacheDir=" + String.valueOf(this.cacheDir) + "]";
    }

    boolean isCleaning() {
        return this.cleanDaemon != null && this.cleanDaemon.isAlive();
    }

    private static FileCacheMaintenanceDaemon performCacheMaintIfNeeded(File cacheDir, int nestingLevel) {
        long lastMaintTS;
        File lastMaintFile = new File(cacheDir, ".lastmaint");
        long l = lastMaintTS = lastMaintFile.isFile() ? lastMaintFile.lastModified() : 0L;
        if (lastMaintTS + 172800000L > System.currentTimeMillis()) {
            return null;
        }
        FileCacheMaintenanceDaemon cleanDaemon = new FileCacheMaintenanceDaemon(cacheDir, lastMaintFile, nestingLevel);
        cleanDaemon.start();
        return cleanDaemon;
    }

    private FileStore getFileStore(File cacheDir) {
        try {
            return Files.getFileStore(cacheDir.toPath());
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Failed to get java FileStore for path " + String.valueOf(cacheDir) + ", will be unable to check free/available space."));
            return null;
        }
    }

    private static class FileCacheMaintenanceDaemon
    extends Thread {
        private File lastMaintFile;
        private File cacheDir;
        private long storageEstimateBytes;
        private int nestingLevel;

        FileCacheMaintenanceDaemon(File cacheDir, File lastMaintFile, int nestingLevel) {
            this.setDaemon(true);
            this.setName("FileCacheMaintenanceDaemon for " + cacheDir.getName());
            this.cacheDir = cacheDir;
            this.lastMaintFile = lastMaintFile;
            this.nestingLevel = nestingLevel;
        }

        @Override
        public void run() {
            Msg.info((Object)this, (Object)("Starting cache cleanup: " + String.valueOf(this.cacheDir)));
            this.cacheMaintForDir(this.cacheDir, 0);
            Msg.info((Object)this, (Object)("Finished cache cleanup, estimated storage used: " + this.storageEstimateBytes));
            try {
                FileUtilities.writeStringToFile((File)this.lastMaintFile, (String)("Last maint run at " + String.valueOf(new Date())));
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("Unable to write file cache maintenance file: " + String.valueOf(this.lastMaintFile)), (Throwable)e);
            }
        }

        private void cacheMaintForDir(File dir, int dirLevel) {
            if (dirLevel < this.nestingLevel) {
                for (File f : dir.listFiles()) {
                    String name = f.getName();
                    if (!f.isDirectory() || !NESTING_DIR_NAME_REGEX.matcher(name).matches()) continue;
                    this.cacheMaintForDir(f, dirLevel + 1);
                }
            } else if (dirLevel == this.nestingLevel) {
                this.cacheMaintForLeafDir(dir);
            }
        }

        private void cacheMaintForLeafDir(File dir) {
            long cutoffMS = System.currentTimeMillis() - 86400000L;
            for (File f : dir.listFiles()) {
                if (!f.isFile() || !this.isCacheFileName(f.getName())) continue;
                if (f.lastModified() < cutoffMS) {
                    if (f.delete()) {
                        Msg.debug((Object)this, (Object)("Expired cache file " + String.valueOf(f)));
                        continue;
                    }
                    Msg.error((Object)this, (Object)("Failed to delete cache file " + String.valueOf(f)));
                }
                this.storageEstimateBytes += f.length();
            }
        }

        private boolean isCacheFileName(String s) {
            return FILENAME_REGEX.matcher(s).matches();
        }
    }

    public static class FileCacheEntry {
        final String md5;
        final File file;
        final byte[] bytes;

        private FileCacheEntry(File file, String md5) {
            this.file = file;
            this.bytes = null;
            this.md5 = md5;
        }

        private FileCacheEntry(byte[] bytes, String md5) {
            this.file = null;
            this.bytes = bytes;
            this.md5 = md5;
        }

        public ByteProvider asByteProvider(FSRL fsrl) throws IOException {
            if (fsrl.getMD5() == null) {
                fsrl = fsrl.withMD5(this.md5);
            }
            if (this.file != null) {
                this.file.setLastModified(System.currentTimeMillis());
            }
            return this.bytes != null ? new RefPinningByteArrayProvider(this, fsrl) : new ObfuscatedFileByteProvider(this.file, fsrl, AccessMode.READ);
        }

        public String getMD5() {
            return this.md5;
        }

        public long length() {
            return this.bytes != null ? (long)this.bytes.length : this.file.length();
        }

        public int hashCode() {
            return Objects.hash(this.md5);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileCacheEntry other = (FileCacheEntry)obj;
            return Objects.equals(this.md5, other.md5);
        }
    }

    public class FileCacheEntryBuilder
    extends OutputStream {
        private OutputStream delegate;
        private HashingOutputStream hos;
        private FileCacheEntry fce;
        private long delegateLength;
        private File tmpFile;

        private FileCacheEntryBuilder(long sizeHint) throws IOException {
            long l = sizeHint = sizeHint <= 0L ? 512L : sizeHint;
            if (sizeHint < 0x200000L) {
                this.delegate = new ByteArrayOutputStream((int)sizeHint);
            } else {
                this.tmpFile = FileCache.this.createTempFile();
                this.delegate = new ObfuscatedOutputStream(new FileOutputStream(this.tmpFile));
            }
            this.initHashingOutputStream();
        }

        protected void finalize() throws Throwable {
            if (this.hos != null) {
                Msg.warn((Object)this, (Object)("FAIL TO CLOSE FileCacheEntryBuilder, currentSize=" + this.delegateLength + ", file=" + String.valueOf(this.tmpFile != null ? this.tmpFile : "not set")));
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.switchToTempFileIfNecessary(1);
            this.hos.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.switchToTempFileIfNecessary(b.length);
            this.hos.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.switchToTempFileIfNecessary(len);
            this.hos.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.hos.flush();
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }

        private void initHashingOutputStream() throws IOException {
            try {
                this.hos = new HashingOutputStream(this.delegate, HashUtilities.MD5_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Error getting MD5 algo", e);
            }
        }

        private void switchToTempFileIfNecessary(int bytesToAdd) throws IOException {
            this.delegateLength += (long)bytesToAdd;
            if (this.tmpFile == null && this.delegateLength > 0x200000L) {
                this.tmpFile = FileCache.this.createTempFile();
                byte[] bytes = ((ByteArrayOutputStream)this.delegate).toByteArray();
                this.delegate = new ObfuscatedOutputStream(new FileOutputStream(this.tmpFile));
                this.initHashingOutputStream();
                this.hos.write(bytes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileCacheEntry finish() throws IOException {
            if (this.hos != null) {
                this.hos.close();
                String md5 = NumericUtilities.convertBytesToString((byte[])this.hos.getDigest());
                if (this.tmpFile != null) {
                    this.fce = FileCache.this.addTmpFileToCache(this.tmpFile, md5);
                } else {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)this.delegate;
                    byte[] bytes = baos.toByteArray();
                    this.fce = new FileCacheEntry(bytes, md5);
                    FileCache fileCache = FileCache.this;
                    synchronized (fileCache) {
                        FileCache.this.memCache.put((Object)md5, (Object)this.fce);
                    }
                }
                this.hos = null;
                this.delegate = null;
            }
            return this.fce;
        }
    }

    private static class RefPinningByteArrayProvider
    extends ByteArrayProvider {
        private FileCacheEntry fce;

        public RefPinningByteArrayProvider(FileCacheEntry fce, FSRL fsrl) {
            super(fce.bytes, fsrl);
            this.fce = fce;
        }

        @Override
        public void close() {
            this.fce = null;
            super.hardClose();
        }
    }
}

