/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.ref;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.ref.ExtEquateReference;

public class SarifEquateWriter
extends AbstractExtWriter {
    private AddressSetView set;
    private EquateTable equateTable;

    public SarifEquateWriter(EquateTable equateTable, AddressSetView set, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.equateTable = equateTable;
        this.set = set;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genReferences(monitor);
        this.root.add("equates", (JsonElement)this.objects);
    }

    private void genReferences(TaskMonitor monitor) throws CancelledException, IOException {
        Iterator iter = this.equateTable.getEquates();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Equate equate = (Equate)iter.next();
            String name = equate.getName();
            long value = equate.getValue();
            EquateReference[] refs = equate.getReferences();
            for (int i = 0; i < refs.length; ++i) {
                if (monitor.isCancelled()) {
                    return;
                }
                Address addr = refs[i].getAddress();
                if (!this.set.contains(addr)) continue;
                ExtEquateReference eref = new ExtEquateReference(refs[i], name, value);
                SarifObject sarif = new SarifObject("Ref.Equate", "REFERENCES", this.getTree(eref), addr, addr);
                this.objects.add(this.getTree(sarif));
            }
        }
    }

    public JsonArray getResults() {
        return this.objects;
    }
}

