/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.plugin;

import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.script.AskDialog;
import ghidra.feature.fid.db.FidFile;
import ghidra.feature.fid.db.FidFileManager;
import ghidra.feature.fid.plugin.ActiveFidConfigureDialog;
import ghidra.feature.fid.plugin.PopulateFidDialog;
import ghidra.feature.fid.service.FidService;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateFileException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Function ID", description="This plugin is for creating and maintaining function identification libraries.")
public class FidPlugin
extends ProgramPlugin
implements ChangeListener {
    private static final String MENU_GROUP_1 = "group1";
    static final String FUNCTION_ID_NAME = "Function ID";
    public static final String FID_HELP = "FunctionID";
    private FidService service;
    private FidFileManager fidFileManager;

    public FidPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.tool.contextChanged(null);
    }

    protected void init() {
        super.init();
        this.fidFileManager = FidFileManager.getInstance();
        this.fidFileManager.addChangeListener(this);
        this.service = new FidService();
        this.createStandardActions();
    }

    protected void cleanup() {
        this.fidFileManager.removeChangeListener(this);
        super.cleanup();
    }

    private void createStandardActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Choose Active FidDbs", this.getName()).enabledWhen(ac -> this.enabledForAnyFidFiles())).onAction(ac -> this.chooseActiveFidDbs())).menuPath(new String[]{"&Tools", FUNCTION_ID_NAME, "Choose active FidDbs..."})).menuGroup(MENU_GROUP_1, "1")).description("Select which FidDbs are used during Fid Search")).helpLocation(new HelpLocation(FID_HELP, "chooseactivemenu"))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Create new empty FidDb", this.getName()).enabledWhen(ac -> true)).onAction(ac -> this.createFidDb())).menuPath(new String[]{"&Tools", FUNCTION_ID_NAME, "Create new empty FidDb..."})).menuGroup(MENU_GROUP_1, "2")).description("Create a new, empty FidDb file in your file system")).helpLocation(new HelpLocation(FID_HELP, "createemptyfid"))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Attach existing FidDb", this.getName()).enabledWhen(ac -> true)).onAction(ac -> this.attachFidDb())).menuPath(new String[]{"&Tools", FUNCTION_ID_NAME, "Attach existing FidDb..."})).menuGroup(MENU_GROUP_1, "3")).description("Attach an existing FidDb file from your file system")).helpLocation(new HelpLocation(FID_HELP, "attachfid"))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Detach attached FidDb", this.getName()).enabledWhen(ac -> this.enabledForUserFidFiles())).onAction(ac -> this.removeFidFile())).menuPath(new String[]{"&Tools", FUNCTION_ID_NAME, "Detach attached FidDb..."})).menuGroup(MENU_GROUP_1, "4")).description("Detach an already attached FidDb")).helpLocation(new HelpLocation(FID_HELP, "detachfid"))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Populate FidDb from programs", this.getName()).enabledWhen(ac -> this.enabledForUserFidFiles())).onAction(ac -> {
            this.fidFileManager.load();
            PopulateFidDialog populateFidDialog = new PopulateFidDialog(this.tool, this.service);
            this.tool.showDialog((DialogComponentProvider)populateFidDialog);
        })).menuPath(new String[]{"&Tools", FUNCTION_ID_NAME, "Populate FidDb from programs..."})).menuGroup(MENU_GROUP_1, "5")).description("Populate an existing FidDb with all programs under a domain folder")).helpLocation(new HelpLocation(FID_HELP, "populatedialog"))).buildAndInstall((Tool)this.tool);
    }

    private boolean enabledForAnyFidFiles() {
        if (!this.fidFileManager.hasLoadedFidFiles()) {
            return true;
        }
        return this.fidFileManager.hasFidFiles();
    }

    private boolean enabledForUserFidFiles() {
        if (!this.fidFileManager.hasLoadedFidFiles()) {
            return true;
        }
        return this.fidFileManager.hasUserFidFiles();
    }

    private synchronized void chooseActiveFidDbs() {
        this.fidFileManager.load();
        ActiveFidConfigureDialog dialog = new ActiveFidConfigureDialog(this.fidFileManager.getFidFiles());
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    private void createFidDb() {
        this.fidFileManager.load();
        File dbFile = this.askFile("Create new FidDb file", "Create");
        if (dbFile == null) {
            return;
        }
        if (!dbFile.getName().endsWith(".fidb")) {
            dbFile = new File(dbFile.getParentFile(), dbFile.getName() + ".fidb");
        }
        try {
            this.fidFileManager.createNewFidDatabase(dbFile);
        }
        catch (DuplicateFileException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error creating new FidDb file", (Object)("File already exists: " + dbFile.getAbsolutePath()));
        }
        catch (IOException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error creating new FidDb file", (Object)"Caught IOException creating FidDb file", (Throwable)e);
        }
    }

    private void attachFidDb() {
        this.fidFileManager.load();
        File dbFile = this.askFile("Attach existing FidDb file", "Attach");
        if (dbFile != null) {
            this.fidFileManager.addUserFidFile(dbFile);
        }
    }

    private void removeFidFile() {
        this.fidFileManager.load();
        FidFile fidFile = this.askChoice("Choose FidDb to detach", "Please choose the FidDb to detach", this.fidFileManager.getUserAddedFiles(), null);
        if (fidFile != null) {
            this.fidFileManager.removeUserFile(fidFile);
        }
    }

    private File askFile(String title, String approveButtonText) {
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
        chooser.setApproveButtonText(approveButtonText);
        chooser.setTitle(title);
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        File file = chooser.getSelectedFile();
        chooser.dispose();
        return file;
    }

    private <T> T askChoice(String title, String message, List<T> choices, T defaultValue) {
        AskDialog dialog = new AskDialog(null, title, message, 0, choices, defaultValue);
        if (dialog.isCanceled()) {
            return null;
        }
        Object s = dialog.getChoiceValue();
        return (T)s;
    }
}

