/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild.symbol;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericSymbols;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseToken;
import ghidra.asm.wild.tree.WildAssemblyParseToken;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class WildAssemblyTerminal
extends AssemblyTerminal {
    public static final Pattern PAT_WILD = Pattern.compile("`(?<spec>[^`]*)`");

    public WildAssemblyTerminal(String name) {
        super(name);
    }

    protected Pattern getPattern() {
        return PAT_WILD;
    }

    public Collection<? extends AssemblyParseToken> match(String buffer, int pos, AssemblyGrammar grammar, AssemblyNumericSymbols symbols) {
        Matcher matcher = this.getPattern().matcher(buffer).region(pos, buffer.length());
        if (!matcher.lookingAt()) {
            return List.of();
        }
        return List.of(new WildAssemblyParseToken(grammar, this, matcher.group(), matcher.group("spec")));
    }

    public Collection<String> getSuggestions(String got, AssemblyNumericSymbols symbols) {
        return List.of("`Q1`");
    }
}

