/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractReferenceMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class ReferenceSymbolApplier
extends MsSymbolApplier {
    private AbstractReferenceMsSymbol symbol;

    public ReferenceSymbolApplier(DefaultPdbApplicator applicator, AbstractReferenceMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    MsSymbolIterator getRefIterFromSymbol() throws CancelledException, PdbException {
        int refModuleNumber = this.symbol.getModuleIndex();
        MsSymbolIterator refIter = this.applicator.getPdb().getDebugInfo().getSymbolIterator(refModuleNumber);
        long refOffset = this.symbol.getOffsetActualSymbolInDollarDollarSymbols();
        refIter.initGetByOffset(refOffset);
        return refIter;
    }

    private AbstractReferenceMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractReferenceMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractReferenceMsSymbol refSymbol = (AbstractReferenceMsSymbol)abstractSymbol;
        return refSymbol;
    }
}

