/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.NameMsSymbol;

public abstract class AbstractConstantMsSymbol
extends AbstractMsSymbol
implements NameMsSymbol {
    protected RecordNumber typeRecordNumber;
    protected Numeric value;
    protected String name;

    public AbstractConstantMsSymbol(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.value = new Numeric(reader);
        this.name = reader.parseString(pdb, strType);
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    public Numeric getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(": Type: ");
        builder.append(this.pdb.getTypeRecord(this.typeRecordNumber).toString());
        builder.append(", Value: ");
        builder.append(this.value);
        builder.append(", ");
        builder.append(this.name);
    }
}

