/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.PseudoCodeUnit;
import ghidra.app.util.PseudoDataComponent;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;

public class PseudoData
extends PseudoCodeUnit
implements Data {
    protected DataType dataType;
    protected DataType baseDataType;
    protected static final int OP_INDEX = 0;
    protected int level = 0;
    protected ProgramDataTypeManager dataMgr;
    private static final int[] EMPTY_PATH = new int[0];

    public PseudoData(Program program, Address address, DataType dataType, MemBuffer memBuffer) throws AddressOverflowException {
        super(program, address, PseudoData.computeLength(dataType, address), memBuffer);
        if (dataType == null) {
            dataType = DataType.DEFAULT;
        }
        this.dataType = dataType;
        this.baseDataType = PseudoData.getBaseDataType(dataType);
        if (program instanceof ProgramDB) {
            this.dataMgr = ((ProgramDB)program).getDataTypeManager();
        }
    }

    public PseudoData(Address address, DataType dataType, MemBuffer memBuffer) throws AddressOverflowException {
        this(null, address, dataType, memBuffer);
    }

    protected static DataType getBaseDataType(DataType dataType) {
        DataType baseDataType = dataType;
        if (baseDataType instanceof TypeDef) {
            baseDataType = ((TypeDef)baseDataType).getBaseDataType();
        }
        return baseDataType;
    }

    protected static int computeLength(DataType dataType, Address address) {
        if (dataType == null) {
            return 1;
        }
        int length = dataType.getLength();
        if (length < 1) {
            length = PseudoData.getBaseDataType(dataType) instanceof Pointer ? address.getPointerSize() : 1;
        }
        return length;
    }

    @Override
    public void addValueReference(Address refAddr, RefType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeValueReference(Address refAddr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Data getComponent(int index) {
        PseudoDataComponent data;
        if (index < 0 || index >= this.getNumComponents()) {
            return null;
        }
        try {
            data = null;
            if (this.baseDataType instanceof Array) {
                Array array = (Array)this.baseDataType;
                int elementLength = array.getElementLength();
                data = new PseudoDataComponent(this.program, this.address.add(index * elementLength), this, array.getDataType(), index, index * elementLength, elementLength, this);
            } else if (this.baseDataType instanceof Composite) {
                Composite struct = (Composite)this.baseDataType;
                DataTypeComponent dtc = struct.getComponent(index);
                data = new PseudoDataComponent(this.program, this.address.add(dtc.getOffset()), this, dtc, (MemBuffer)this);
            } else if (this.baseDataType instanceof DynamicDataType) {
                DynamicDataType ddt = (DynamicDataType)this.baseDataType;
                DataTypeComponent dtc = ddt.getComponent(index, this);
                data = new PseudoDataComponent(this.program, this.address.add(dtc.getOffset()), this, dtc, (MemBuffer)this);
            }
        }
        catch (AddressOverflowException e) {
            throw new ConcurrentModificationException("Data type length changed");
        }
        return data;
    }

    @Override
    public Address getAddress(int opIndex) {
        Object obj;
        if (opIndex == 0 && (obj = this.getValue()) instanceof Address) {
            return (Address)obj;
        }
        return null;
    }

    public String getByteCodeString() {
        StringBuffer bytesStr = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            String hex;
            if (i != 0) {
                bytesStr.append(" ");
            }
            try {
                hex = Integer.toHexString(this.getByte(i));
            }
            catch (MemoryAccessException e) {
                hex = "??";
            }
            if (hex.length() == 1) {
                bytesStr.append("0");
            }
            if (hex.length() > 2) {
                bytesStr.append(hex.substring(hex.length() - 2));
                continue;
            }
            bytesStr.append(hex);
        }
        return bytesStr.toString();
    }

    public String toString() {
        String valueRepresentation = this.getDefaultValueRepresentation();
        String mnemonicString = this.getMnemonicString();
        if (valueRepresentation == null) {
            return mnemonicString;
        }
        return mnemonicString + " " + valueRepresentation;
    }

    @Override
    public String getDefaultValueRepresentation() {
        if (this.getLength() < this.dataType.getLength()) {
            return "TooBig: " + this.dataType.getDisplayName() + " need " + this.dataType.getLength() + " have " + this.getLength();
        }
        return this.dataType.getRepresentation(this, this, this.getLength());
    }

    @Override
    public String getMnemonicString() {
        return this.dataType.getMnemonic(this);
    }

    @Override
    public int getNumOperands() {
        return 1;
    }

    @Override
    public Scalar getScalar(int opIndex) {
        if (opIndex == 0) {
            Object obj = this.getValue();
            if (obj instanceof Scalar) {
                return (Scalar)obj;
            }
            if (obj instanceof Address) {
                Address addrObj = (Address)obj;
                long offset = addrObj.getAddressableWordOffset();
                return new Scalar(addrObj.getAddressSpace().getPointerSize() * 8, offset, false);
            }
        }
        return null;
    }

    @Override
    public DataType getBaseDataType() {
        return this.baseDataType;
    }

    public void clearSetting(String name) {
        throw new UnsupportedOperationException();
    }

    public Long getLong(String name) {
        return this.getDefaultSettings().getLong(name);
    }

    public boolean isChangeAllowed(SettingsDefinition settingsDefinition) {
        return false;
    }

    public String[] getNames() {
        return new String[0];
    }

    public String getString(String name) {
        return this.getDefaultSettings().getString(name);
    }

    public Object getValue(String name) {
        return this.getDefaultSettings().getValue(name);
    }

    public void setLong(String name, long value) {
        throw new UnsupportedOperationException();
    }

    public void setString(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Data getComponent(int[] componentPath) {
        if (componentPath == null || componentPath.length <= this.level) {
            return this;
        }
        Data component = this.getComponent(componentPath[this.level]);
        return component == null ? null : component.getComponent(componentPath);
    }

    @Override
    @Deprecated
    public Data getComponentAt(int offset) {
        return this.getComponentContaining(offset);
    }

    @Override
    public Data getComponentContaining(int offset) {
        if (offset < 0 || offset > this.length) {
            return null;
        }
        if (this.baseDataType instanceof Array) {
            Array array = (Array)this.baseDataType;
            int elementLength = array.getElementLength();
            int index = offset / elementLength;
            return this.getComponent(index);
        }
        if (this.baseDataType instanceof Structure) {
            Structure struct = (Structure)this.baseDataType;
            DataTypeComponent dtc = struct.getComponentContaining(offset);
            return dtc != null ? this.getComponent(dtc.getOrdinal()) : null;
        }
        if (this.baseDataType instanceof DynamicDataType) {
            DynamicDataType ddt = (DynamicDataType)this.baseDataType;
            DataTypeComponent dtc = ddt.getComponentAt(offset, this);
            return dtc != null ? this.getComponent(dtc.getOrdinal()) : null;
        }
        if (this.baseDataType instanceof Union) {
            // empty if block
        }
        return null;
    }

    @Override
    public List<Data> getComponentsContaining(int offset) {
        ArrayList<Data> list;
        block5: {
            block7: {
                block6: {
                    block4: {
                        list = new ArrayList<Data>();
                        if (offset < 0 || offset >= this.length) {
                            return null;
                        }
                        if (!(this.baseDataType instanceof Array)) break block4;
                        Array array = (Array)this.baseDataType;
                        int elementLength = array.getElementLength();
                        int index = offset / elementLength;
                        list.add(this.getComponent(index));
                        break block5;
                    }
                    if (!(this.baseDataType instanceof Structure)) break block6;
                    Structure struct = (Structure)this.baseDataType;
                    for (DataTypeComponent dtc : struct.getComponentsContaining(offset)) {
                        list.add(this.getComponent(dtc.getOrdinal()));
                    }
                    break block5;
                }
                if (!(this.baseDataType instanceof DynamicDataType)) break block7;
                DynamicDataType ddt = (DynamicDataType)this.baseDataType;
                DataTypeComponent dtc = ddt.getComponentAt(offset, this);
                while (dtc != null && offset >= dtc.getOffset() && offset <= dtc.getOffset() + dtc.getLength() - 1) {
                    int ordinal = dtc.getOrdinal();
                    list.add(this.getComponent(ordinal++));
                    dtc = ordinal < ddt.getNumComponents(this) ? ddt.getComponent(ordinal, this) : null;
                }
                break block5;
            }
            if (!(this.baseDataType instanceof Union) || offset != 0) break block5;
            for (int i = 0; i < this.getNumComponents(); ++i) {
                list.add(this.getComponent(i));
            }
        }
        return list;
    }

    @Override
    public int getComponentIndex() {
        return -1;
    }

    @Override
    public int getComponentLevel() {
        return this.level;
    }

    @Override
    public int[] getComponentPath() {
        return EMPTY_PATH;
    }

    @Override
    public String getComponentPathName() {
        return null;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getFieldName() {
        return null;
    }

    @Override
    public int getNumComponents() {
        if (this.length < this.dataType.getLength()) {
            return -1;
        }
        if (this.baseDataType instanceof Composite) {
            return ((Composite)this.baseDataType).getNumComponents();
        }
        if (this.baseDataType instanceof Array) {
            return ((Array)this.baseDataType).getNumElements();
        }
        if (this.baseDataType instanceof DynamicDataType) {
            return ((DynamicDataType)this.baseDataType).getNumComponents(this);
        }
        return 0;
    }

    @Override
    public Data getParent() {
        return null;
    }

    @Override
    public int getParentOffset() {
        return 0;
    }

    @Override
    public String getPathName() {
        SymbolTable st;
        Symbol symbol;
        if (this.program != null && (symbol = (st = this.program.getSymbolTable()).getPrimarySymbol(this.address)) != null) {
            return symbol.getName();
        }
        return "DAT" + this.address.toString();
    }

    @Override
    public Data getPrimitiveAt(int offset) {
        if (offset < 0 || offset >= this.length) {
            return null;
        }
        Data dc = this.getComponentAt(offset);
        if (dc == null || dc == this) {
            return this;
        }
        return dc.getPrimitiveAt(offset - dc.getParentOffset());
    }

    @Override
    public Data getRoot() {
        return this;
    }

    @Override
    public int getRootOffset() {
        return 0;
    }

    @Override
    public Object getValue() {
        return this.baseDataType.getValue(this, this, this.length);
    }

    @Override
    public Class<?> getValueClass() {
        DataType dt = this.getBaseDataType();
        if (dt != null) {
            return dt.getValueClass(this);
        }
        return null;
    }

    @Override
    public boolean hasStringValue() {
        return String.class.equals(this.getValueClass());
    }

    @Override
    public Reference[] getValueReferences() {
        if (this.refMgr == null) {
            return new Reference[0];
        }
        return this.refMgr.getReferencesFrom(this.address, 0);
    }

    @Override
    public boolean isArray() {
        return this.baseDataType instanceof Array;
    }

    @Override
    public boolean isDefined() {
        return !(this.dataType instanceof DefaultDataType);
    }

    @Override
    public boolean isPointer() {
        return this.baseDataType instanceof Pointer;
    }

    @Override
    public boolean isStructure() {
        return this.baseDataType instanceof Structure;
    }

    @Override
    public boolean isDynamic() {
        return this.baseDataType instanceof DynamicDataType;
    }

    @Override
    public boolean isUnion() {
        return this.baseDataType instanceof Union;
    }

    public void clearAllSettings() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        if (this.dataMgr == null) {
            return true;
        }
        return this.dataMgr.isEmptySetting(this);
    }

    @Override
    public String getDefaultLabelPrefix(DataTypeDisplayOptions options) {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PseudoData data = (PseudoData)obj;
        if (!this.address.equals(data.address)) {
            return false;
        }
        return this.dataType.isEquivalent(data.dataType);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    public Settings getDefaultSettings() {
        return this.dataType.getDefaultSettings();
    }
}

