/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import ghidra.app.plugin.core.debug.service.emulation.Mode;
import ghidra.debug.api.emulation.PcodeDebuggerAccess;
import ghidra.debug.api.emulation.PcodeDebuggerMemoryAccess;
import ghidra.debug.api.emulation.PcodeDebuggerRegistersAccess;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.trace.TraceEmulationIntegration;
import ghidra.pcode.exec.trace.data.PcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceRegistersAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.thread.TraceThread;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class DebuggerEmulationIntegration
extends Enum<DebuggerEmulationIntegration> {
    private static final /* synthetic */ DebuggerEmulationIntegration[] $VALUES;

    public static DebuggerEmulationIntegration[] values() {
        return (DebuggerEmulationIntegration[])$VALUES.clone();
    }

    public static DebuggerEmulationIntegration valueOf(String name) {
        return Enum.valueOf(DebuggerEmulationIntegration.class, name);
    }

    private static <T> TraceEmulationIntegration.Writer createDelayedWrite(PcodeDebuggerAccess acc, Mode mode) {
        TraceEmulationIntegration.TraceWriter writer = new TraceEmulationIntegration.TraceWriter((PcodeTraceAccess)acc);
        writer.putHandler((TraceEmulationIntegration.PieceHandler)new TargetBytesPieceHandler(mode));
        return writer;
    }

    public static TraceEmulationIntegration.Writer bytesDelayedWriteTrace(PcodeDebuggerAccess from) {
        return DebuggerEmulationIntegration.createDelayedWrite(from, Mode.RO);
    }

    public static TraceEmulationIntegration.Writer bytesImmediateWriteTarget(PcodeDebuggerAccess access) {
        return DebuggerEmulationIntegration.createDelayedWrite(access, Mode.RW);
    }

    public static PcodeStateCallbacks bytesImmediateWriteTarget(PcodeDebuggerAccess access, TraceThread thread, int frame) {
        final PcodeDebuggerRegistersAccess regAcc = access.getDataForLocalState(thread, frame);
        TraceEmulationIntegration.TraceWriter writer = new TraceEmulationIntegration.TraceWriter((PcodeTraceAccess)access){

            protected PcodeTraceRegistersAccess getRegAccess(PcodeThread<?> ignored) {
                return regAcc;
            }
        };
        writer.putHandler((TraceEmulationIntegration.PieceHandler)new TargetBytesPieceHandler(Mode.RW));
        return writer.wrapFor(null);
    }

    protected static <T> T waitTimeout(CompletableFuture<T> future) {
        try {
            return future.get(1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new AccessPcodeExecutionException("Timed out reading or writing target", (Exception)e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AccessPcodeExecutionException("Error reading or writing target", e);
        }
    }

    private static /* synthetic */ DebuggerEmulationIntegration[] $values() {
        return new DebuggerEmulationIntegration[0];
    }

    static {
        $VALUES = DebuggerEmulationIntegration.$values();
    }

    public static class TargetBytesPieceHandler
    extends TraceEmulationIntegration.BytesPieceHandler {
        protected final Mode mode;

        public TargetBytesPieceHandler(Mode mode) {
            this.mode = mode;
        }

        public AddressSetView readUninitialized(PcodeTraceDataAccess acc, PcodeThread<?> thread, PcodeExecutorStatePiece<byte[], byte[]> piece, AddressSetView set) {
            AddressSetView unknown = acc.intersectUnknown(set);
            if (unknown.isEmpty()) {
                return super.readUninitialized(acc, thread, piece, set);
            }
            if (acc instanceof PcodeDebuggerRegistersAccess) {
                PcodeDebuggerRegistersAccess regsAcc = (PcodeDebuggerRegistersAccess)acc;
                if (regsAcc.isLive()) {
                    DebuggerEmulationIntegration.waitTimeout(regsAcc.readFromTargetRegisters(unknown));
                }
                return super.readUninitialized(acc, thread, piece, set);
            }
            if (acc instanceof PcodeDebuggerMemoryAccess) {
                PcodeDebuggerMemoryAccess memAcc = (PcodeDebuggerMemoryAccess)acc;
                if (memAcc.isLive() && ((Boolean)DebuggerEmulationIntegration.waitTimeout(memAcc.readFromTargetMemory(unknown))).booleanValue() && (unknown = memAcc.intersectUnknown(set)).isEmpty()) {
                    return super.readUninitialized(acc, thread, piece, set);
                }
                AddressSetView remains = memAcc.readFromStaticImages(piece, unknown);
                AddressSet readFromStatic = unknown.subtract(remains);
                AddressSet toReadFromTraceToPiece = set.subtract((AddressSetView)readFromStatic);
                return super.readUninitialized((PcodeTraceDataAccess)memAcc, thread, piece, (AddressSetView)toReadFromTraceToPiece);
            }
            throw new AssertionError();
        }

        public boolean dataWritten(PcodeTraceDataAccess acc, AddressSet written, PcodeThread<?> thread, PcodeExecutorStatePiece<byte[], byte[]> piece, Address address, int length, byte[] value) {
            if (!this.mode.isWriteTarget()) {
                return false;
            }
            if (address.isUniqueAddress()) {
                return true;
            }
            if (acc instanceof PcodeDebuggerRegistersAccess) {
                PcodeDebuggerRegistersAccess regsAcc = (PcodeDebuggerRegistersAccess)acc;
                if (!regsAcc.isLive()) {
                    return true;
                }
                DebuggerEmulationIntegration.waitTimeout(regsAcc.writeTargetRegister(address, value));
            } else if (acc instanceof PcodeDebuggerMemoryAccess) {
                PcodeDebuggerMemoryAccess memAcc = (PcodeDebuggerMemoryAccess)acc;
                if (!memAcc.isLive()) {
                    return true;
                }
                DebuggerEmulationIntegration.waitTimeout(memAcc.writeTargetMemory(address, value));
            }
            return true;
        }
    }
}

