/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.util.PropertyFile;
import ghidra.util.exception.DuplicateFileException;
import java.io.File;
import java.io.IOException;
import javax.help.UnsupportedOperationException;

public class ItemPropertyFile
extends PropertyFile {
    private static final String FILE_ID_PROPERTY = "FILE_ID";
    protected String name;
    protected String parentPath;

    public ItemPropertyFile(File dir, String storageName, String parentPath, String name) throws IOException {
        super(dir, storageName);
        this.name = name;
        this.parentPath = parentPath;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        if (this.parentPath == null || this.name == null) {
            return null;
        }
        if (this.parentPath.length() == 1) {
            return this.parentPath + this.name;
        }
        return this.parentPath + "/" + this.name;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getFileID() {
        return this.getString(FILE_ID_PROPERTY, null);
    }

    public void setFileID(String fileId) {
        this.putString(FILE_ID_PROPERTY, fileId);
    }

    public void moveTo(File newStorageParent, String newStorageName, String newParentPath, String newName) throws DuplicateFileException, IOException {
        super.moveTo(newStorageParent, newStorageName);
        if (!newParentPath.equals(this.parentPath) || !newName.equals(this.name)) {
            this.parentPath = newParentPath;
            this.name = newName;
        }
    }

    @Override
    @Deprecated(forRemoval=false, since="11.4")
    public final void moveTo(File newStorageParent, String newStorageName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

