/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.op.JitUnimplementedOp;
import org.objectweb.asm.MethodVisitor;

public enum UnimplementedOpGen implements OpGen<JitUnimplementedOp>
{
    GEN;


    @Override
    public void generateRunCode(JitCodeGenerator gen, JitUnimplementedOp op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        long counter = gen.getAddressForOp(op.op()).getOffset();
        gen.generatePassageExit(block, () -> rv.visitLdcInsn((Object)counter), gen.getExitContext(op.op()), rv);
        String message = gen.getErrorMessage(op.op());
        if (op.op() instanceof JitPassage.DecodeErrorPcodeOp) {
            JitAllocationModel.RunFixedLocal.THIS.generateLoadCode(rv);
            rv.visitLdcInsn((Object)message);
            rv.visitLdcInsn((Object)counter);
            rv.visitMethodInsn(185, GenConsts.NAME_JIT_COMPILED_PASSAGE, "createDecodeError", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CREATE_DECODE_ERROR, true);
            rv.visitInsn(191);
        } else {
            rv.visitTypeInsn(187, GenConsts.NAME_LOW_LEVEL_ERROR);
            rv.visitInsn(89);
            rv.visitLdcInsn((Object)message);
            rv.visitMethodInsn(183, GenConsts.NAME_LOW_LEVEL_ERROR, "<init>", GenConsts.MDESC_LOW_LEVEL_ERROR__$INIT, false);
            rv.visitInsn(191);
        }
    }
}

