# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=andes-nx45 -timeline -iterations=1 < %s | FileCheck %s

// Can be dispatched in the same cycle if different functional units are used.
fadd.s ft0, fa0, fa1
fdiv.s ft0, fa0, fa1

// FMAC
fadd.s ft0, fa0, fa1
fmul.s ft0, fa0, fa1
fmadd.s ft0, fa0, fa1, fa2

// FDIV
fdiv.s ft0, fa0, fa1
fsqrt.s ft0, fa0

// FMV
fsgnj.s ft0, fa0, fa1
fmv.x.w a0, fa0

// FMISC
fmin.s ft0, fa0, fa1
fclass.s a0, fa0
feq.s a0, fa0, fa1
fcvt.s.w ft0, a0

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      13
# CHECK-NEXT: Total Cycles:      63
# CHECK-NEXT: Total uOps:        13

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.21
# CHECK-NEXT: IPC:               0.21
# CHECK-NEXT: Block RThroughput: 56.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      4     1.00                        fadd.s	ft0, fa0, fa1
# CHECK-NEXT:  1      19    19.00                       fdiv.s	ft0, fa0, fa1
# CHECK-NEXT:  1      4     1.00                        fadd.s	ft0, fa0, fa1
# CHECK-NEXT:  1      4     1.00                        fmul.s	ft0, fa0, fa1
# CHECK-NEXT:  1      4     1.00                        fmadd.s	ft0, fa0, fa1, fa2
# CHECK-NEXT:  1      19    19.00                       fdiv.s	ft0, fa0, fa1
# CHECK-NEXT:  1      18    18.00                       fsqrt.s	ft0, fa0
# CHECK-NEXT:  1      1     1.00                        fsgnj.s	ft0, fa0, fa1
# CHECK-NEXT:  1      1     1.00                        fmv.x.w	a0, fa0
# CHECK-NEXT:  1      2     1.00                        fmin.s	ft0, fa0, fa1
# CHECK-NEXT:  1      2     1.00                        fclass.s	a0, fa0
# CHECK-NEXT:  1      2     1.00                        feq.s	a0, fa0, fa1
# CHECK-NEXT:  1      2     1.00                        fcvt.s.w	ft0, a0

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - Andes45ALU
# CHECK-NEXT: [0.1] - Andes45ALU
# CHECK-NEXT: [1]   - Andes45CSR
# CHECK-NEXT: [2]   - Andes45FDIV
# CHECK-NEXT: [3]   - Andes45FMAC
# CHECK-NEXT: [4]   - Andes45FMISC
# CHECK-NEXT: [5]   - Andes45FMV
# CHECK-NEXT: [6]   - Andes45LSU
# CHECK-NEXT: [7]   - Andes45MDU

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -      -     56.00  4.00   4.00   2.00    -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     fadd.s	ft0, fa0, fa1
# CHECK-NEXT:  -      -      -     19.00   -      -      -      -      -     fdiv.s	ft0, fa0, fa1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     fadd.s	ft0, fa0, fa1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     fmul.s	ft0, fa0, fa1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     fmadd.s	ft0, fa0, fa1, fa2
# CHECK-NEXT:  -      -      -     19.00   -      -      -      -      -     fdiv.s	ft0, fa0, fa1
# CHECK-NEXT:  -      -      -     18.00   -      -      -      -      -     fsqrt.s	ft0, fa0
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fsgnj.s	ft0, fa0, fa1
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fmv.x.w	a0, fa0
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     fmin.s	ft0, fa0, fa1
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     fclass.s	a0, fa0
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     feq.s	a0, fa0, fa1
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     fcvt.s.w	ft0, a0

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          0123456789          012

# CHECK:      [0,0]     DeeeE.    .    .    .    .    .    .    .    .    .    .    . .   fadd.s	ft0, fa0, fa1
# CHECK-NEXT: [0,1]     DeeeeeeeeeeeeeeeeeeE.    .    .    .    .    .    .    .    . .   fdiv.s	ft0, fa0, fa1
# CHECK-NEXT: [0,2]     .    .    .    DeeeE.    .    .    .    .    .    .    .    . .   fadd.s	ft0, fa0, fa1
# CHECK-NEXT: [0,3]     .    .    .    .DeeeE    .    .    .    .    .    .    .    . .   fmul.s	ft0, fa0, fa1
# CHECK-NEXT: [0,4]     .    .    .    . DeeeE   .    .    .    .    .    .    .    . .   fmadd.s	ft0, fa0, fa1, fa2
# CHECK-NEXT: [0,5]     .    .    .    .   DeeeeeeeeeeeeeeeeeeE .    .    .    .    . .   fdiv.s	ft0, fa0, fa1
# CHECK-NEXT: [0,6]     .    .    .    .    .    .    .    .  DeeeeeeeeeeeeeeeeeE   . .   fsqrt.s	ft0, fa0
# CHECK-NEXT: [0,7]     .    .    .    .    .    .    .    .    .    .    .    DE   . .   fsgnj.s	ft0, fa0, fa1
# CHECK-NEXT: [0,8]     .    .    .    .    .    .    .    .    .    .    .    .DE  . .   fmv.x.w	a0, fa0
# CHECK-NEXT: [0,9]     .    .    .    .    .    .    .    .    .    .    .    .DeE . .   fmin.s	ft0, fa0, fa1
# CHECK-NEXT: [0,10]    .    .    .    .    .    .    .    .    .    .    .    . DeE. .   fclass.s	a0, fa0
# CHECK-NEXT: [0,11]    .    .    .    .    .    .    .    .    .    .    .    .  DeE .   feq.s	a0, fa0, fa1
# CHECK-NEXT: [0,12]    .    .    .    .    .    .    .    .    .    .    .    .    DeE   fcvt.s.w	ft0, a0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       fadd.s	ft0, fa0, fa1
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       fdiv.s	ft0, fa0, fa1
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       fadd.s	ft0, fa0, fa1
# CHECK-NEXT: 3.     1     0.0    0.0    0.0       fmul.s	ft0, fa0, fa1
# CHECK-NEXT: 4.     1     0.0    0.0    0.0       fmadd.s	ft0, fa0, fa1, fa2
# CHECK-NEXT: 5.     1     0.0    0.0    0.0       fdiv.s	ft0, fa0, fa1
# CHECK-NEXT: 6.     1     0.0    0.0    0.0       fsqrt.s	ft0, fa0
# CHECK-NEXT: 7.     1     0.0    0.0    0.0       fsgnj.s	ft0, fa0, fa1
# CHECK-NEXT: 8.     1     0.0    0.0    0.0       fmv.x.w	a0, fa0
# CHECK-NEXT: 9.     1     0.0    0.0    0.0       fmin.s	ft0, fa0, fa1
# CHECK-NEXT: 10.    1     0.0    0.0    0.0       fclass.s	a0, fa0
# CHECK-NEXT: 11.    1     0.0    0.0    0.0       feq.s	a0, fa0, fa1
# CHECK-NEXT: 12.    1     0.0    0.0    0.0       fcvt.s.w	ft0, a0
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
