; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S -o - %s | FileCheck %s

declare void @use.i8(i8)
declare void @use.v2i8(<2 x i8>)
define i1 @src_add_eq_p2(i8 %x, i8 %yy) {
; CHECK-LABEL: @src_add_eq_p2(
; CHECK-NEXT:    [[NY:%.*]] = sub i8 0, [[YY:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY]], [[NY]]
; CHECK-NEXT:    [[X1:%.*]] = add i8 [[Y]], [[X:%.*]]
; CHECK-NEXT:    call void @use.i8(i8 [[X1]])
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %ny = sub i8 0, %yy
  %y = and i8 %ny, %yy
  %x1 = add i8 %y, %x
  call void @use.i8(i8 %x1)
  %v = and i8 %x1, %y
  %r = icmp eq i8 %v, %y
  ret i1 %r
}

define i1 @src_add_eq_p2_fail_multiuse(i8 %x, i8 %yy) {
; CHECK-LABEL: @src_add_eq_p2_fail_multiuse(
; CHECK-NEXT:    [[NY:%.*]] = sub i8 0, [[YY:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY]], [[NY]]
; CHECK-NEXT:    [[X1:%.*]] = add i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    call void @use.i8(i8 [[X1]])
; CHECK-NEXT:    [[V:%.*]] = and i8 [[X1]], [[Y]]
; CHECK-NEXT:    call void @use.i8(i8 [[V]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %ny = sub i8 0, %yy
  %y = and i8 %ny, %yy
  %x1 = add i8 %x, %y
  call void @use.i8(i8 %x1)
  %v = and i8 %x1, %y
  call void @use.i8(i8 %v)
  %r = icmp eq i8 %v, %y
  ret i1 %r
}

define i1 @src_xor_ne_zero(i8 %x, i8 %yy) {
; CHECK-LABEL: @src_xor_ne_zero(
; CHECK-NEXT:    [[NY:%.*]] = sub i8 0, [[YY:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY]], [[NY]]
; CHECK-NEXT:    [[X1:%.*]] = xor i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    call void @use.i8(i8 [[X1]])
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[TMP1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %ny = sub i8 0, %yy
  %y = and i8 %ny, %yy
  %x1 = xor i8 %x, %y
  call void @use.i8(i8 %x1)
  %v = and i8 %x1, %y
  %r = icmp ne i8 %v, 0
  ret i1 %r
}

define i1 @src_xor_ne_zero_fail_different_p2(i8 %x, i8 %yy) {
; CHECK-LABEL: @src_xor_ne_zero_fail_different_p2(
; CHECK-NEXT:    [[NY:%.*]] = sub i8 0, [[YY:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY]], [[NY]]
; CHECK-NEXT:    [[Y2:%.*]] = shl i8 [[Y]], 1
; CHECK-NEXT:    [[X1:%.*]] = xor i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    call void @use.i8(i8 [[X1]])
; CHECK-NEXT:    [[V:%.*]] = and i8 [[X1]], [[Y2]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %ny = sub i8 0, %yy
  %y = and i8 %ny, %yy
  %y2 = shl i8 %y, 1
  %x1 = xor i8 %x, %y
  call void @use.i8(i8 %x1)
  %v = and i8 %x1, %y2
  %r = icmp ne i8 %v, 0
  ret i1 %r
}

define <2 x i1> @src_sub_ne_p2(<2 x i8> %x, <2 x i8> %yy) {
; CHECK-LABEL: @src_sub_ne_p2(
; CHECK-NEXT:    [[NY:%.*]] = sub <2 x i8> zeroinitializer, [[YY:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = and <2 x i8> [[YY]], [[NY]]
; CHECK-NEXT:    [[X1:%.*]] = sub <2 x i8> [[X:%.*]], [[Y]]
; CHECK-NEXT:    call void @use.v2i8(<2 x i8> [[X1]])
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i8> [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne <2 x i8> [[TMP1]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %ny = sub <2 x i8> zeroinitializer, %yy
  %y = and <2 x i8> %ny, %yy
  %x1 = sub <2 x i8> %x, %y
  call void @use.v2i8(<2 x i8> %x1)
  %v = and <2 x i8> %x1, %y
  %r = icmp ne <2 x i8> %v, %y
  ret <2 x i1> %r
}

define <2 x i1> @src_sub_eq_zero(<2 x i8> %x, <2 x i8> %yy) {
; CHECK-LABEL: @src_sub_eq_zero(
; CHECK-NEXT:    [[Y:%.*]] = shl <2 x i8> <i8 1, i8 2>, [[YY:%.*]]
; CHECK-NEXT:    [[X1:%.*]] = sub <2 x i8> [[X:%.*]], [[Y]]
; CHECK-NEXT:    call void @use.v2i8(<2 x i8> [[X1]])
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i8> [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq <2 x i8> [[TMP1]], [[Y]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %y = shl <2 x i8> <i8 1, i8 2>, %yy
  %x1 = sub <2 x i8> %x, %y
  call void @use.v2i8(<2 x i8> %x1)
  %v = and <2 x i8> %x1, %y
  %r = icmp eq <2 x i8> %v, zeroinitializer
  ret <2 x i1> %r
}

define <2 x i1> @src_sub_eq_zero_fail_commuted(<2 x i8> %x, <2 x i8> %yy) {
; CHECK-LABEL: @src_sub_eq_zero_fail_commuted(
; CHECK-NEXT:    [[Y:%.*]] = shl <2 x i8> <i8 1, i8 2>, [[YY:%.*]]
; CHECK-NEXT:    [[X1:%.*]] = sub <2 x i8> [[Y]], [[X:%.*]]
; CHECK-NEXT:    call void @use.v2i8(<2 x i8> [[X1]])
; CHECK-NEXT:    [[V:%.*]] = and <2 x i8> [[X1]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq <2 x i8> [[V]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %y = shl <2 x i8> <i8 1, i8 2>, %yy
  %x1 = sub <2 x i8> %y, %x
  call void @use.v2i8(<2 x i8> %x1)
  %v = and <2 x i8> %x1, %y
  %r = icmp eq <2 x i8> %v, zeroinitializer
  ret <2 x i1> %r
}

define <2 x i1> @src_sub_eq_zero_fail_non_p2(<2 x i8> %x, <2 x i8> %yy) {
; CHECK-LABEL: @src_sub_eq_zero_fail_non_p2(
; CHECK-NEXT:    [[Y:%.*]] = shl <2 x i8> <i8 1, i8 3>, [[YY:%.*]]
; CHECK-NEXT:    [[X1:%.*]] = sub <2 x i8> [[X:%.*]], [[Y]]
; CHECK-NEXT:    call void @use.v2i8(<2 x i8> [[X1]])
; CHECK-NEXT:    [[V:%.*]] = and <2 x i8> [[X1]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq <2 x i8> [[V]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %y = shl <2 x i8> <i8 1, i8 3>, %yy
  %x1 = sub <2 x i8> %x, %y
  call void @use.v2i8(<2 x i8> %x1)
  %v = and <2 x i8> %x1, %y
  %r = icmp eq <2 x i8> %v, zeroinitializer
  ret <2 x i1> %r
}
