/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.resolver;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.CriterionPredicateRegistry;
import net.shibboleth.shared.resolver.ResolverException;

public final class ResolverSupport {
    private ResolverSupport() {
    }

    @Nonnull
    public static <T, E extends Predicate<T>> Set<Predicate<T>> getPredicates(@Nullable CriteriaSet criteriaSet, @Nullable Class<E> predicateCriterionType, @Nullable CriterionPredicateRegistry<T> registry) throws ResolverException {
        if (criteriaSet == null) {
            return CollectionSupport.emptySet();
        }
        HashSet<Predicate<T>> predicates = new HashSet<Predicate<T>>(criteriaSet.size());
        for (Criterion criterion : criteriaSet) {
            Predicate<T> predicate;
            assert (criterion != null);
            if (predicateCriterionType != null && predicateCriterionType.isInstance(criterion)) {
                predicates.add((Predicate)predicateCriterionType.cast(criterion));
                continue;
            }
            if (registry == null || (predicate = registry.getPredicate(criterion)) == null) continue;
            predicates.add(predicate);
        }
        return predicates;
    }

    @Nonnull
    public static <T> Iterable<T> getFilteredIterable(@Nullable Iterable<T> candidates, @Nullable Set<Predicate<T>> predicates, boolean satisfyAny, boolean onEmptyPredicatesReturnEmpty) {
        if (candidates == null || !candidates.iterator().hasNext()) {
            return CollectionSupport.emptySet();
        }
        if (predicates == null || predicates.isEmpty()) {
            if (onEmptyPredicatesReturnEmpty) {
                return CollectionSupport.emptySet();
            }
            return candidates;
        }
        Predicate<T> predicate = satisfyAny ? PredicateSupport.or(predicates) : PredicateSupport.and(predicates);
        Iterable result = Iterables.filter(candidates, predicate::test);
        assert (result != null);
        return result;
    }
}

