/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.query;

import java.io.IOException;
import java.util.Objects;
import lombok.NonNull;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BitSetIterator;
import org.opensearch.neuralsearch.sparse.accessor.SparseVectorReader;
import org.opensearch.neuralsearch.sparse.data.SparseVector;

public class ExactMatchScorer
extends Scorer {
    @NonNull
    private final BitSetIterator candidate;
    private final byte[] queryDenseVector;
    @NonNull
    private final SparseVectorReader reader;
    @NonNull
    private final Similarity.SimScorer simScorer;

    public ExactMatchScorer(@NonNull BitSetIterator candidate, SparseVector queryVector, @NonNull SparseVectorReader reader, @NonNull Similarity.SimScorer simScorer) {
        Objects.requireNonNull(candidate, "candidate is marked non-null but is null");
        Objects.requireNonNull(reader, "reader is marked non-null but is null");
        Objects.requireNonNull(simScorer, "simScorer is marked non-null but is null");
        this.candidate = candidate;
        this.queryDenseVector = queryVector.toDenseVector();
        this.reader = reader;
        this.simScorer = simScorer;
    }

    public int docID() {
        return this.candidate.docID();
    }

    public DocIdSetIterator iterator() {
        return this.candidate;
    }

    public float getMaxScore(int upTo) throws IOException {
        return 0.0f;
    }

    public float score() throws IOException {
        int docId = this.docID();
        SparseVector docVector = this.reader.read(docId);
        if (docVector == null) {
            return 0.0f;
        }
        return this.simScorer.score((float)docVector.dotProduct(this.queryDenseVector), 0L);
    }
}

