/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mapper;

import java.util.LinkedHashSet;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.mapper.MapStructClientModelMapper;
import org.keycloak.representations.admin.v2.ClientRepresentation;
import org.keycloak.services.ServiceException;

public class MapStructClientModelMapperImpl
implements MapStructClientModelMapper {
    @Override
    public ClientRepresentation fromModel(KeycloakSession session, ClientModel model) {
        if (model == null) {
            return null;
        }
        ClientRepresentation clientRepresentation = new ClientRepresentation();
        clientRepresentation.setAuth(this.clientModelToAuth(model, session));
        clientRepresentation.setServiceAccount(this.clientModelToServiceAccount(model, session));
        clientRepresentation.setDisplayName(model.getName());
        clientRepresentation.setAppUrl(model.getBaseUrl());
        Set set = model.getRedirectUris();
        if (set != null) {
            clientRepresentation.setAppRedirectUrls(new LinkedHashSet<String>(set));
        }
        clientRepresentation.setRoles(this.getRoleStrings(model.getRolesStream()));
        clientRepresentation.setClientId(model.getClientId());
        clientRepresentation.setDescription(model.getDescription());
        clientRepresentation.setProtocol(model.getProtocol());
        clientRepresentation.setEnabled(model.isEnabled());
        Set set2 = model.getWebOrigins();
        if (set2 != null) {
            clientRepresentation.setWebOrigins(new LinkedHashSet<String>(set2));
        }
        return clientRepresentation;
    }

    @Override
    public ClientModel toModel(KeycloakSession session, RealmModel realm, ClientModel existingModel, ClientRepresentation rep) throws ServiceException {
        if (rep == null) {
            return existingModel;
        }
        existingModel.setName(rep.getDisplayName());
        existingModel.setBaseUrl(rep.getAppUrl());
        if (existingModel.getRedirectUris() != null) {
            set = rep.getAppRedirectUrls();
            if (set != null) {
                existingModel.getRedirectUris().clear();
                existingModel.getRedirectUris().addAll(set);
            } else {
                existingModel.setRedirectUris(null);
            }
        } else {
            set = rep.getAppRedirectUrls();
            if (set != null) {
                existingModel.setRedirectUris(new LinkedHashSet<String>(set));
            }
        }
        existingModel.setPublicClient(this.isPublicClientPrimitive(this.repAuthEnabled(rep)));
        existingModel.setClientAuthenticatorType(this.repAuthMethod(rep));
        existingModel.setSecret(this.repAuthSecret(rep));
        Boolean enabled1 = this.repServiceAccountEnabled(rep);
        if (enabled1 != null) {
            existingModel.setServiceAccountsEnabled(enabled1.booleanValue());
        }
        existingModel.setClientId(rep.getClientId());
        existingModel.setDescription(rep.getDescription());
        if (rep.getEnabled() != null) {
            existingModel.setEnabled(rep.getEnabled().booleanValue());
        }
        if (existingModel.getWebOrigins() != null) {
            Set<String> set1 = rep.getWebOrigins();
            if (set1 != null) {
                existingModel.getWebOrigins().clear();
                existingModel.getWebOrigins().addAll(set1);
            } else {
                existingModel.setWebOrigins(null);
            }
        } else {
            Set<String> set1 = rep.getWebOrigins();
            if (set1 != null) {
                existingModel.setWebOrigins(new LinkedHashSet<String>(set1));
            }
        }
        existingModel.setProtocol(rep.getProtocol());
        return existingModel;
    }

    @Override
    public ClientModel toModel(KeycloakSession session, RealmModel realm, ClientRepresentation rep) throws ServiceException {
        Set<String> set1;
        if (rep == null) {
            return null;
        }
        ClientModel clientModel = this.createClientModel(realm, rep);
        clientModel.setName(rep.getDisplayName());
        clientModel.setBaseUrl(rep.getAppUrl());
        Set<String> set = rep.getAppRedirectUrls();
        if (set != null) {
            clientModel.setRedirectUris(new LinkedHashSet<String>(set));
        }
        clientModel.setPublicClient(this.isPublicClientPrimitive(this.repAuthEnabled(rep)));
        clientModel.setClientAuthenticatorType(this.repAuthMethod(rep));
        clientModel.setSecret(this.repAuthSecret(rep));
        Boolean enabled1 = this.repServiceAccountEnabled(rep);
        if (enabled1 != null) {
            clientModel.setServiceAccountsEnabled(enabled1.booleanValue());
        }
        clientModel.setClientId(rep.getClientId());
        clientModel.setDescription(rep.getDescription());
        if (rep.getEnabled() != null) {
            clientModel.setEnabled(rep.getEnabled().booleanValue());
        }
        if ((set1 = rep.getWebOrigins()) != null) {
            clientModel.setWebOrigins(new LinkedHashSet<String>(set1));
        }
        clientModel.setProtocol(rep.getProtocol());
        return clientModel;
    }

    protected ClientRepresentation.Auth clientModelToAuth(ClientModel clientModel, KeycloakSession session) {
        if (clientModel == null) {
            return null;
        }
        ClientRepresentation.Auth auth = new ClientRepresentation.Auth();
        auth.setEnabled(this.isPublicClient(clientModel.isPublicClient()));
        auth.setMethod(clientModel.getClientAuthenticatorType());
        auth.setSecret(clientModel.getSecret());
        return auth;
    }

    protected ClientRepresentation.ServiceAccount clientModelToServiceAccount(ClientModel clientModel, KeycloakSession session) {
        if (clientModel == null) {
            return null;
        }
        ClientRepresentation.ServiceAccount serviceAccount = new ClientRepresentation.ServiceAccount();
        serviceAccount.setEnabled(clientModel.isServiceAccountsEnabled());
        serviceAccount.setRoles(this.getServiceAccountRoles(session, clientModel));
        return serviceAccount;
    }

    private Boolean repAuthEnabled(ClientRepresentation clientRepresentation) {
        ClientRepresentation.Auth auth = clientRepresentation.getAuth();
        if (auth == null) {
            return null;
        }
        return auth.getEnabled();
    }

    private String repAuthMethod(ClientRepresentation clientRepresentation) {
        ClientRepresentation.Auth auth = clientRepresentation.getAuth();
        if (auth == null) {
            return null;
        }
        return auth.getMethod();
    }

    private String repAuthSecret(ClientRepresentation clientRepresentation) {
        ClientRepresentation.Auth auth = clientRepresentation.getAuth();
        if (auth == null) {
            return null;
        }
        return auth.getSecret();
    }

    private Boolean repServiceAccountEnabled(ClientRepresentation clientRepresentation) {
        ClientRepresentation.ServiceAccount serviceAccount = clientRepresentation.getServiceAccount();
        if (serviceAccount == null) {
            return null;
        }
        return serviceAccount.getEnabled();
    }
}

