/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.rmi.server.UID;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;

class ConnectionOutputStream
extends MarshalOutputStream {
    private final Connection conn;
    private final boolean resultStream;
    private final UID ackID;
    private DGCAckHandler dgcAckHandler = null;

    ConnectionOutputStream(Connection connection, boolean bl) throws IOException {
        super(connection.getOutputStream());
        this.conn = connection;
        this.resultStream = bl;
        this.ackID = bl ? new UID() : null;
    }

    void writeID() throws IOException {
        assert (this.resultStream);
        this.ackID.write(this);
    }

    boolean isResultStream() {
        return this.resultStream;
    }

    void saveObject(Object object) {
        if (this.dgcAckHandler == null) {
            this.dgcAckHandler = new DGCAckHandler(this.ackID);
        }
        this.dgcAckHandler.add(object);
    }

    DGCAckHandler getDGCAckHandler() {
        return this.dgcAckHandler;
    }

    void done() {
        if (this.dgcAckHandler != null) {
            this.dgcAckHandler.startTimer();
        }
    }
}

