/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.KeepTypesMode;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KeepTypesTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, KeepTypesTokenFilter> {
    @Nullable
    private final KeepTypesMode mode;
    @Nonnull
    private final List<String> types;
    public static final JsonpDeserializer<KeepTypesTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeepTypesTokenFilter::setupKeepTypesTokenFilterDeserializer);

    private KeepTypesTokenFilter(Builder builder) {
        super(builder);
        this.mode = builder.mode;
        this.types = ApiTypeHelper.unmodifiable(builder.types);
    }

    public static KeepTypesTokenFilter of(Function<Builder, ObjectBuilder<KeepTypesTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.KeepTypes;
    }

    @Nullable
    public final KeepTypesMode mode() {
        return this.mode;
    }

    @Nonnull
    public final List<String> types() {
        return this.types;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keep_types");
        super.serializeInternal(generator, mapper);
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.types)) {
            generator.writeKey("types");
            generator.writeStartArray();
            for (String item0 : this.types) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKeepTypesTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        KeepTypesTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::mode, KeepTypesMode._DESERIALIZER, "mode");
        op.add(Builder::types, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "types");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.mode);
        result = 31 * result + Objects.hashCode(this.types);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeepTypesTokenFilter other = (KeepTypesTokenFilter)o;
        return Objects.equals(this.mode, other.mode) && Objects.equals(this.types, other.types);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KeepTypesTokenFilter> {
        @Nullable
        private KeepTypesMode mode;
        @Nullable
        private List<String> types;

        public Builder() {
        }

        private Builder(KeepTypesTokenFilter o) {
            super(o);
            this.mode = o.mode;
            this.types = Builder._listCopy(o.types);
        }

        private Builder(Builder o) {
            super(o);
            this.mode = o.mode;
            this.types = Builder._listCopy(o.types);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder mode(@Nullable KeepTypesMode value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder types(List<String> list) {
            this.types = Builder._listAddAll(this.types, list);
            return this;
        }

        @Nonnull
        public final Builder types(String value, String ... values) {
            this.types = Builder._listAdd(this.types, value, values);
            return this;
        }

        @Override
        @Nonnull
        public KeepTypesTokenFilter build() {
            this._checkSingleUse();
            return new KeepTypesTokenFilter(this);
        }
    }
}

