/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ml;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.ml.ModelState;

public class MemoryAwareConcurrentHashmap<RCFModelType extends ThresholdedRandomCutForest>
extends ConcurrentHashMap<String, ModelState<RCFModelType>> {
    protected final MemoryTracker memoryTracker;

    public MemoryAwareConcurrentHashmap(MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
    }

    @Override
    public ModelState<RCFModelType> remove(Object key) {
        ModelState deletedModelState = (ModelState)super.remove(key);
        if (deletedModelState != null && deletedModelState.getModel().isPresent()) {
            long memoryToRelease = this.memoryTracker.estimateTRCFModelSize((ThresholdedRandomCutForest)deletedModelState.getModel().get());
            this.memoryTracker.releaseMemory(memoryToRelease, true, MemoryTracker.Origin.REAL_TIME_DETECTOR);
        }
        return deletedModelState;
    }

    @Override
    public ModelState<RCFModelType> put(String key, ModelState<RCFModelType> value) {
        ModelState<RCFModelType> previousAssociatedState = super.put(key, value);
        if (value != null && value.getModel().isPresent()) {
            long memoryToConsume = this.memoryTracker.estimateTRCFModelSize((ThresholdedRandomCutForest)value.getModel().get());
            this.memoryTracker.consumeMemory(memoryToConsume, true, MemoryTracker.Origin.REAL_TIME_DETECTOR);
        }
        return previousAssociatedState;
    }
}

