/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.Version;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.common.Booleans;
import org.opensearch.common.SetOnce;
import org.opensearch.common.UUIDs;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.NoSeedNodeLeftException;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.RemoteConnectionInfo;
import org.opensearch.transport.RemoteConnectionManager;
import org.opensearch.transport.RemoteConnectionStrategy;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class SniffConnectionStrategy
extends RemoteConnectionStrategy {
    public static final Setting.AffixSetting<List<String>> REMOTE_CLUSTER_SEEDS = Setting.affixKeySetting("cluster.remote.", "seeds", (ns, key) -> Setting.listSetting(key, Collections.emptyList(), s -> {
        SniffConnectionStrategy.parsePort(s);
        return s;
    }, new RemoteConnectionStrategy.StrategyValidator((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> REMOTE_CLUSTERS_PROXY = Setting.affixKeySetting("cluster.remote.", "proxy", (ns, key) -> Setting.simpleString(key, new RemoteConnectionStrategy.StrategyValidator<String>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF, s -> {
        if (Strings.hasLength((String)s)) {
            SniffConnectionStrategy.parsePort(s);
        }
    }), Setting.Property.Dynamic, Setting.Property.NodeScope), () -> REMOTE_CLUSTER_SEEDS);
    public static final Setting<Integer> REMOTE_CONNECTIONS_PER_CLUSTER = Setting.intSetting("cluster.remote.connections_per_cluster", 3, 1, Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Integer> REMOTE_NODE_CONNECTIONS = Setting.affixKeySetting("cluster.remote.", "node_connections", (ns, key) -> Setting.intSetting(key, REMOTE_CONNECTIONS_PER_CLUSTER, 1, new RemoteConnectionStrategy.StrategyValidator<Integer>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.SNIFF), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    static final int CHANNELS_PER_CONNECTION = 6;
    private static final Predicate<DiscoveryNode> DEFAULT_NODE_PREDICATE = node -> Version.CURRENT.isCompatible(node.getVersion()) && (!node.isClusterManagerNode() || node.isDataNode() || node.isIngestNode());
    private final List<String> configuredSeedNodes;
    private final List<Supplier<DiscoveryNode>> seedNodes;
    private final int maxNumRemoteConnections;
    private final Predicate<DiscoveryNode> nodePredicate;
    private final SetOnce<ClusterName> remoteClusterName = new SetOnce();
    private final String proxyAddress;

    SniffConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, Settings settings) {
        this(clusterAlias, transportService, connectionManager, REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace(clusterAlias).get(settings), settings, REMOTE_NODE_CONNECTIONS.getConcreteSettingForNamespace(clusterAlias).get(settings), SniffConnectionStrategy.getNodePredicate(settings), REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(clusterAlias).get(settings));
    }

    SniffConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, String proxyAddress, Settings settings, int maxNumRemoteConnections, Predicate<DiscoveryNode> nodePredicate, List<String> configuredSeedNodes) {
        this(clusterAlias, transportService, connectionManager, proxyAddress, settings, maxNumRemoteConnections, nodePredicate, configuredSeedNodes, configuredSeedNodes.stream().map(seedAddress -> () -> SniffConnectionStrategy.resolveSeedNode(clusterAlias, seedAddress, proxyAddress)).collect(Collectors.toList()));
    }

    SniffConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, String proxyAddress, Settings settings, int maxNumRemoteConnections, Predicate<DiscoveryNode> nodePredicate, List<String> configuredSeedNodes, List<Supplier<DiscoveryNode>> seedNodes) {
        super(clusterAlias, transportService, connectionManager, settings);
        this.proxyAddress = proxyAddress;
        this.maxNumRemoteConnections = maxNumRemoteConnections;
        this.nodePredicate = nodePredicate;
        this.configuredSeedNodes = configuredSeedNodes;
        this.seedNodes = seedNodes;
    }

    static Stream<Setting.AffixSetting<?>> enablementSettings() {
        return Stream.of(REMOTE_CLUSTER_SEEDS);
    }

    static Writeable.Reader<RemoteConnectionInfo.ModeInfo> infoReader() {
        return SniffModeInfo::new;
    }

    @Override
    protected boolean shouldOpenMoreConnections() {
        return this.connectionManager.size() < this.maxNumRemoteConnections;
    }

    @Override
    protected boolean strategyMustBeRebuilt(Settings newSettings) {
        String proxy = REMOTE_CLUSTERS_PROXY.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        List<String> addresses = REMOTE_CLUSTER_SEEDS.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        int nodeConnections = REMOTE_NODE_CONNECTIONS.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        return nodeConnections != this.maxNumRemoteConnections || this.seedsChanged(this.configuredSeedNodes, addresses) || this.proxyChanged(this.proxyAddress, proxy);
    }

    @Override
    protected RemoteConnectionStrategy.ConnectionStrategy strategyType() {
        return RemoteConnectionStrategy.ConnectionStrategy.SNIFF;
    }

    @Override
    protected void connectImpl(ActionListener<Void> listener) {
        this.collectRemoteNodes(this.seedNodes.iterator(), listener);
    }

    @Override
    protected RemoteConnectionInfo.ModeInfo getModeInfo() {
        return new SniffModeInfo(this.configuredSeedNodes, this.maxNumRemoteConnections, this.connectionManager.size());
    }

    private void collectRemoteNodes(Iterator<Supplier<DiscoveryNode>> seedNodes, ActionListener<Void> listener) {
        if (Thread.currentThread().isInterrupted()) {
            listener.onFailure((Exception)new InterruptedException("remote connect thread got interrupted"));
            return;
        }
        if (seedNodes.hasNext()) {
            Consumer<Exception> onFailure = e -> {
                if ((e instanceof ConnectTransportException || e instanceof IOException || e instanceof IllegalStateException) && seedNodes.hasNext()) {
                    this.logger.debug(() -> new ParameterizedMessage("fetching nodes from external cluster [{}] failed moving to next seed node", (Object)this.clusterAlias), (Throwable)e);
                    this.collectRemoteNodes(seedNodes, listener);
                    return;
                }
                this.logger.warn((Message)new ParameterizedMessage("fetching nodes from external cluster [{}] failed", (Object)this.clusterAlias), (Throwable)e);
                listener.onFailure(e);
            };
            DiscoveryNode seedNode = seedNodes.next().get();
            this.logger.trace("[{}] opening transient connection to seed node: [{}]", (Object)this.clusterAlias, (Object)seedNode);
            StepListener openConnectionStep = new StepListener();
            try {
                this.connectionManager.openConnection(seedNode, null, (ActionListener<Transport.Connection>)openConnectionStep);
            }
            catch (Exception e2) {
                onFailure.accept(e2);
            }
            StepListener handshakeStep = new StepListener();
            openConnectionStep.whenComplete(connection -> {
                ConnectionProfile connectionProfile = this.connectionManager.getConnectionProfile();
                this.transportService.handshake((Transport.Connection)connection, connectionProfile.getHandshakeTimeout().millis(), this.getRemoteClusterNamePredicate(), (ActionListener<TransportService.HandshakeResponse>)handshakeStep);
            }, onFailure);
            StepListener fullConnectionStep = new StepListener();
            handshakeStep.whenComplete(handshakeResponse -> {
                DiscoveryNode handshakeNode = handshakeResponse.getDiscoveryNode();
                if (this.nodePredicate.test(handshakeNode) && this.shouldOpenMoreConnections()) {
                    this.logger.trace("[{}] opening managed connection to seed node: [{}] proxy address: [{}]", (Object)this.clusterAlias, (Object)handshakeNode, (Object)this.proxyAddress);
                    DiscoveryNode handshakeNodeWithProxy = SniffConnectionStrategy.maybeAddProxyAddress(this.proxyAddress, handshakeNode);
                    this.connectionManager.connectToNode(handshakeNodeWithProxy, null, this.transportService.connectionValidator(handshakeNodeWithProxy), (ActionListener<Void>)fullConnectionStep);
                } else {
                    fullConnectionStep.onResponse(null);
                }
            }, e -> {
                Transport.Connection connection = (Transport.Connection)openConnectionStep.result();
                DiscoveryNode node = connection.getNode();
                this.logger.debug(() -> new ParameterizedMessage("[{}] failed to handshake with seed node: [{}]", (Object)this.clusterAlias, (Object)node), (Throwable)e);
                IOUtils.closeWhileHandlingException((Closeable)connection);
                onFailure.accept((Exception)e);
            });
            fullConnectionStep.whenComplete(aVoid -> {
                if (this.remoteClusterName.get() == null) {
                    TransportService.HandshakeResponse handshakeResponse = (TransportService.HandshakeResponse)((Object)((Object)handshakeStep.result()));
                    assert (handshakeResponse.getClusterName().value() != null);
                    this.remoteClusterName.set((Object)handshakeResponse.getClusterName());
                }
                Transport.Connection connection = (Transport.Connection)openConnectionStep.result();
                ClusterStateRequest request = new ClusterStateRequest();
                request.clear();
                request.nodes(true);
                ThreadPool threadPool = this.transportService.getThreadPool();
                ThreadContext threadContext = threadPool.getThreadContext();
                TransportService.ContextRestoreResponseHandler<ClusterStateResponse> responseHandler = new TransportService.ContextRestoreResponseHandler<ClusterStateResponse>(threadContext.newRestorableContext(false), new SniffClusterStateResponseHandler(connection, listener, seedNodes));
                try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                    ThreadContextAccess.doPrivilegedVoid(threadContext::markAsSystemContext);
                    this.transportService.sendRequest(connection, "cluster:monitor/state", (TransportRequest)request, TransportRequestOptions.EMPTY, responseHandler);
                }
            }, e -> {
                Transport.Connection connection = (Transport.Connection)openConnectionStep.result();
                DiscoveryNode node = connection.getNode();
                this.logger.debug(() -> new ParameterizedMessage("[{}] failed to open managed connection to seed node: [{}]", (Object)this.clusterAlias, (Object)node), (Throwable)e);
                IOUtils.closeWhileHandlingException((Closeable)((Closeable)openConnectionStep.result()));
                onFailure.accept((Exception)e);
            });
        } else {
            listener.onFailure((Exception)((Object)new NoSeedNodeLeftException(this.clusterAlias)));
        }
    }

    private Predicate<ClusterName> getRemoteClusterNamePredicate() {
        return new Predicate<ClusterName>(){

            @Override
            public boolean test(ClusterName c) {
                return SniffConnectionStrategy.this.remoteClusterName.get() == null || c.equals(SniffConnectionStrategy.this.remoteClusterName.get());
            }

            public String toString() {
                return SniffConnectionStrategy.this.remoteClusterName.get() == null ? "any cluster name" : "expected remote cluster name [" + ((ClusterName)SniffConnectionStrategy.this.remoteClusterName.get()).value() + "]";
            }
        };
    }

    private static DiscoveryNode resolveSeedNode(String clusterAlias, String address, String proxyAddress) {
        if (proxyAddress == null || proxyAddress.isEmpty()) {
            TransportAddress transportAddress = new TransportAddress(SniffConnectionStrategy.parseConfiguredAddress(address));
            return new DiscoveryNode(clusterAlias + "#" + transportAddress.toString(), transportAddress, Version.CURRENT.minimumCompatibilityVersion());
        }
        TransportAddress transportAddress = new TransportAddress(SniffConnectionStrategy.parseConfiguredAddress(proxyAddress));
        String hostName = RemoteConnectionStrategy.parseHost(proxyAddress);
        return new DiscoveryNode("", clusterAlias + "#" + address, UUIDs.randomBase64UUID(), hostName, address, transportAddress, Collections.singletonMap("server_name", hostName), DiscoveryNodeRole.BUILT_IN_ROLES, Version.CURRENT.minimumCompatibilityVersion());
    }

    static Predicate<DiscoveryNode> getNodePredicate(Settings settings) {
        if (RemoteClusterService.REMOTE_NODE_ATTRIBUTE.exists(settings)) {
            String attribute = RemoteClusterService.REMOTE_NODE_ATTRIBUTE.get(settings);
            return DEFAULT_NODE_PREDICATE.and(node -> Booleans.parseBoolean((String)node.getAttributes().getOrDefault(attribute, "false")));
        }
        return DEFAULT_NODE_PREDICATE;
    }

    private static DiscoveryNode maybeAddProxyAddress(String proxyAddress, DiscoveryNode node) {
        if (proxyAddress == null || proxyAddress.isEmpty()) {
            return node;
        }
        InetSocketAddress proxyInetAddress = SniffConnectionStrategy.parseConfiguredAddress(proxyAddress);
        return new DiscoveryNode(node.getName(), node.getId(), node.getEphemeralId(), node.getHostName(), node.getHostAddress(), new TransportAddress(proxyInetAddress), node.getAttributes(), node.getRoles(), node.getVersion());
    }

    private boolean seedsChanged(List<String> oldSeedNodes, List<String> newSeedNodes) {
        if (oldSeedNodes.size() != newSeedNodes.size()) {
            return true;
        }
        HashSet<String> oldSeeds = new HashSet<String>(oldSeedNodes);
        HashSet<String> newSeeds = new HashSet<String>(newSeedNodes);
        return !oldSeeds.equals(newSeeds);
    }

    private boolean proxyChanged(String oldProxy, String newProxy) {
        if (oldProxy == null || oldProxy.isEmpty()) {
            return !(newProxy == null || newProxy.isEmpty());
        }
        return !Objects.equals(oldProxy, newProxy);
    }

    public static class SniffModeInfo
    implements RemoteConnectionInfo.ModeInfo {
        final List<String> seedNodes;
        final int maxConnectionsPerCluster;
        final int numNodesConnected;

        public SniffModeInfo(List<String> seedNodes, int maxConnectionsPerCluster, int numNodesConnected) {
            this.seedNodes = seedNodes;
            this.maxConnectionsPerCluster = maxConnectionsPerCluster;
            this.numNodesConnected = numNodesConnected;
        }

        private SniffModeInfo(StreamInput input) throws IOException {
            this.seedNodes = Arrays.asList(input.readStringArray());
            this.maxConnectionsPerCluster = input.readVInt();
            this.numNodesConnected = input.readVInt();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray("seeds");
            for (String address : this.seedNodes) {
                builder.value(address);
            }
            builder.endArray();
            builder.field("num_nodes_connected", this.numNodesConnected);
            builder.field("max_connections_per_cluster", this.maxConnectionsPerCluster);
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.seedNodes.toArray(new String[0]));
            out.writeVInt(this.maxConnectionsPerCluster);
            out.writeVInt(this.numNodesConnected);
        }

        @Override
        public boolean isConnected() {
            return this.numNodesConnected > 0;
        }

        @Override
        public String modeName() {
            return "sniff";
        }

        public List<String> getSeedNodes() {
            return this.seedNodes;
        }

        public int getMaxConnectionsPerCluster() {
            return this.maxConnectionsPerCluster;
        }

        public int getNumNodesConnected() {
            return this.numNodesConnected;
        }

        @Override
        public RemoteConnectionStrategy.ConnectionStrategy modeType() {
            return RemoteConnectionStrategy.ConnectionStrategy.SNIFF;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SniffModeInfo sniff = (SniffModeInfo)o;
            return this.maxConnectionsPerCluster == sniff.maxConnectionsPerCluster && this.numNodesConnected == sniff.numNodesConnected && Objects.equals(this.seedNodes, sniff.seedNodes);
        }

        public int hashCode() {
            return Objects.hash(this.seedNodes, this.maxConnectionsPerCluster, this.numNodesConnected);
        }
    }

    private class SniffClusterStateResponseHandler
    implements TransportResponseHandler<ClusterStateResponse> {
        private final Transport.Connection connection;
        private final ActionListener<Void> listener;
        private final Iterator<Supplier<DiscoveryNode>> seedNodes;

        SniffClusterStateResponseHandler(Transport.Connection connection, ActionListener<Void> listener, Iterator<Supplier<DiscoveryNode>> seedNodes) {
            this.connection = connection;
            this.listener = listener;
            this.seedNodes = seedNodes;
        }

        public ClusterStateResponse read(StreamInput in) throws IOException {
            return new ClusterStateResponse(in);
        }

        @Override
        public void handleResponse(ClusterStateResponse response) {
            this.handleNodes(response.getState().nodes().getNodes().values().iterator());
        }

        private void handleNodes(final Iterator<DiscoveryNode> nodesIter) {
            while (nodesIter.hasNext()) {
                final DiscoveryNode node = nodesIter.next();
                if (!SniffConnectionStrategy.this.nodePredicate.test(node) || !SniffConnectionStrategy.this.shouldOpenMoreConnections()) continue;
                SniffConnectionStrategy.this.logger.trace("[{}] opening managed connection to node: [{}] proxy address: [{}]", (Object)SniffConnectionStrategy.this.clusterAlias, (Object)node, (Object)SniffConnectionStrategy.this.proxyAddress);
                DiscoveryNode nodeWithProxy = SniffConnectionStrategy.maybeAddProxyAddress(SniffConnectionStrategy.this.proxyAddress, node);
                SniffConnectionStrategy.this.connectionManager.connectToNode(nodeWithProxy, null, SniffConnectionStrategy.this.transportService.connectionValidator(node), new ActionListener<Void>(){

                    public void onResponse(Void aVoid) {
                        SniffClusterStateResponseHandler.this.handleNodes(nodesIter);
                    }

                    public void onFailure(Exception e) {
                        if (e instanceof ConnectTransportException || e instanceof IllegalStateException) {
                            SniffConnectionStrategy.this.logger.debug(() -> new ParameterizedMessage("[{}] failed to open managed connection to node [{}]", (Object)SniffConnectionStrategy.this.clusterAlias, (Object)node), (Throwable)e);
                            SniffClusterStateResponseHandler.this.handleNodes(nodesIter);
                        } else {
                            SniffConnectionStrategy.this.logger.warn((Message)new ParameterizedMessage("[{}] failed to open managed connection to node [{}]", (Object)SniffConnectionStrategy.this.clusterAlias, (Object)node), (Throwable)e);
                            IOUtils.closeWhileHandlingException((Closeable)SniffClusterStateResponseHandler.this.connection);
                            SniffConnectionStrategy.this.collectRemoteNodes(SniffClusterStateResponseHandler.this.seedNodes, SniffClusterStateResponseHandler.this.listener);
                        }
                    }
                });
                return;
            }
            IOUtils.closeWhileHandlingException((Closeable)this.connection);
            int openConnections = SniffConnectionStrategy.this.connectionManager.size();
            if (openConnections == 0) {
                this.listener.onFailure((Exception)new IllegalStateException("Unable to open any connections to remote cluster [" + SniffConnectionStrategy.this.clusterAlias + "]"));
            } else {
                this.listener.onResponse(null);
            }
        }

        @Override
        public void handleException(TransportException exp) {
            SniffConnectionStrategy.this.logger.warn((Message)new ParameterizedMessage("fetching nodes from external cluster {} failed", (Object)SniffConnectionStrategy.this.clusterAlias), (Throwable)((Object)exp));
            try {
                IOUtils.closeWhileHandlingException((Closeable)this.connection);
            }
            finally {
                SniffConnectionStrategy.this.collectRemoteNodes(this.seedNodes, this.listener);
            }
        }

        @Override
        public String executor() {
            return "management";
        }
    }
}

