/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.ling.ValueLabel;

public class StringLabel
extends ValueLabel
implements HasOffset {
    private String str;
    private int beginPosition = -1;
    private int endPosition = -1;
    private static final long serialVersionUID = -4153619273767524247L;

    public StringLabel() {
    }

    public StringLabel(String str) {
        this.str = str;
    }

    public StringLabel(String str, int beginPosition, int endPosition) {
        this.str = str;
        this.setBeginPosition(beginPosition);
        this.setEndPosition(endPosition);
    }

    public StringLabel(Label label) {
        this.str = label.value();
        if (label instanceof HasOffset) {
            HasOffset ofs = (HasOffset)((Object)label);
            this.setBeginPosition(ofs.beginPosition());
            this.setEndPosition(ofs.endPosition());
        }
    }

    public String value() {
        return this.str;
    }

    public void setValue(String value) {
        this.str = value;
    }

    public void setFromString(String str) {
        this.str = str;
    }

    public String toString() {
        return this.str;
    }

    public LabelFactory labelFactory() {
        return StringLabelFactoryHolder.lf;
    }

    public static LabelFactory factory() {
        return StringLabelFactoryHolder.lf;
    }

    public int beginPosition() {
        return this.beginPosition;
    }

    public int endPosition() {
        return this.endPosition;
    }

    public void setBeginPosition(int beginPosition) {
        this.beginPosition = beginPosition;
    }

    public void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    private static class StringLabelFactoryHolder {
        static final LabelFactory lf = new StringLabelFactory();

        private StringLabelFactoryHolder() {
        }
    }
}

